      SUBROUTINE PDTRTRI0( UPLO, DIAG, N, A, IA, JA, DESCA, INFO )
*
*     .. Scalar Arguments ..
      CHARACTER          DIAG, UPLO
      INTEGER            IA, INFO, JA, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  ====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            NOUNIT, UPPER
      INTEGER            I, ICOFF, ICTXT, IROFF, ICURCOL, ICURROW,
     $                   IDUMMY, II, IOFFA, J, JB, JJ, JN, LDA, MYCOL,
     $                   MYROW, NN, NPCOL, NPROW, IN
*     ..
*     .. Local Arrays ..
      INTEGER            IDUM1( 2 ), IDUM2( 2 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CHK1MAT, IGAMX2D, INFOG2L,
     $                   PCHK1MAT, PDTRTI2, PDTRMM0, PDTRSM0,
     $                   PXERBLA
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ICHAR, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test input parameters
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -707
      ELSE
         UPPER = LSAME( UPLO, 'U' )
         NOUNIT = LSAME( DIAG, 'N' )
*
         CALL CHK1MAT( N, 3, N, 3, IA, JA, DESCA, 7, INFO )
         IF( INFO.EQ.0 ) THEN
            IROFF = MOD( IA-1, DESCA( MB_ ) )
            ICOFF = MOD( JA-1, DESCA( NB_ ) )
            IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
               INFO = -1
            ELSE IF( .NOT.NOUNIT .AND. .NOT.LSAME( DIAG, 'U' ) ) THEN
               INFO = -2
C           ELSE IF( IROFF.NE.ICOFF .OR. IROFF.NE.0 ) THEN
C              INFO = -6
            ELSE IF( IROFF.NE.ICOFF ) THEN
               INFO = -6
            ELSE IF( DESCA( MB_ ).NE.DESCA( NB_ ) ) THEN
               INFO = -704
            END IF
         END IF
*
         IF( UPPER ) THEN
            IDUM1( 1 ) = ICHAR( 'U' )
         ELSE
            IDUM1( 1 ) = ICHAR( 'L' )
         END IF
         IDUM2( 1 ) = 1
         IF( NOUNIT ) THEN
            IDUM1( 2 ) = ICHAR( 'N' )
         ELSE
            IDUM1( 2 ) = ICHAR( 'U' )
         END IF
         IDUM2( 2 ) = 2
*
         CALL PCHK1MAT( N, 3, N, 3, IA, JA, DESCA, 7, 2, IDUM1, IDUM2,
     $                  INFO )
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDTRTRI', INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
*     Check for singularity if non-unit.
*
      IN = MIN( ICEIL( IA, DESCA( MB_ ) ) * DESCA( MB_ ), IA+N-1 )
      JN = MIN( ICEIL( JA, DESCA( NB_ ) ) * DESCA( NB_ ), JA+N-1 )
      IF( NOUNIT ) THEN
         CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL,
     $                 II, JJ, ICURROW, ICURCOL )
*
*        Handle first block separately
*
         JB = JN-JA+1
         LDA = DESCA( LLD_ )
         IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
            IOFFA = II+(JJ-1)*LDA
            DO 10 I = 0, JB-1
               IF( A( IOFFA ).EQ.ZERO .AND. INFO.EQ.0 )
     $            INFO = I + 1
               IOFFA = IOFFA + LDA + 1
   10       CONTINUE
         END IF
         IF( MYROW.EQ.ICURROW )
     $      II = II + JB
         IF( MYCOL.EQ.ICURCOL )
     $      JJ = JJ + JB
         ICURROW = MOD( ICURROW+1, NPROW )
         ICURCOL = MOD( ICURCOL+1, NPCOL )
*
*        Loop over remaining blocks of columns
*
         DO 30 J = JN+1, JA+N-1, DESCA( NB_ )
            JB = MIN( JA+N-J, DESCA( NB_ ) )
            IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
               IOFFA = II+(JJ-1)*LDA
               DO 20 I = 0, JB-1
                  IF( A( IOFFA ).EQ.ZERO .AND. INFO.EQ.0 )
     $               INFO = J + I - JA + 1
                  IOFFA = IOFFA + LDA + 1
   20          CONTINUE
            END IF
            IF( MYROW.EQ.ICURROW )
     $         II = II + JB
            IF( MYCOL.EQ.ICURCOL )
     $         JJ = JJ + JB
            ICURROW = MOD( ICURROW+1, NPROW )
            ICURCOL = MOD( ICURCOL+1, NPCOL )
   30    CONTINUE
         CALL IGAMX2D( ICTXT, 'All', ' ', 1, 1, INFO, 1, IDUMMY,
     $                 IDUMMY, -1, -1, MYCOL )
         IF( INFO.NE.0 )
     $      RETURN
      END IF
*
*     Use blocked code
*
      IF( UPPER ) THEN
*
*        Compute inverse of upper triangular matrix
*
         JB = JN-JA+1
*
*        Handle first block of column separately
*
         CALL PDTRTI2( UPLO, DIAG, JB, A, IA, JA, DESCA, INFO )
*
*        Loop over remaining block of columns
*
         DO 40 J = JN+1, JA+N-1, DESCA( NB_ )
            JB = MIN( DESCA( NB_ ), JA+N-J )
            I = IA + J - JA
*
*           Compute rows 1:j-1 of current block column
*
            
C           CALL PDTRMM( 'Left', UPLO, 'No transpose', DIAG, J-JA, JB,
C    $                   ONE, A, IA, JA, DESCA, A, IA, J, DESCA )

            CALL PDTRMM0( 'Left', UPLO, 'No transpose', DIAG, JN-JA+1,
     $                   JB, ONE, A, IA, JA, DESCA, A, IA, J, DESCA )
            CALL PDGEMM0( 'N', 'N', JN-JA+1, JB, J-1-JN, ONE, A, IA,
     $                    JN+1, DESCA, A, IN+1, J, DESCA, ONE,
     $                    A, IA, J, DESCA )
            CALL PDTRMM0( 'Left', UPLO, 'No transpose', DIAG, J-JN-1,
     $                    JB, ONE, A, IN+1, JN+1, DESCA, A, IN+1, J,
     $                    DESCA )

            CALL PDTRSM0( 'Right', UPLO, 'No transpose', DIAG, J-JA,
     $                   JB, -ONE, A, I, J, DESCA, A, IA, J, DESCA )
*
*           Compute inverse of current diagonal block
*
            CALL PDTRTI2( UPLO, DIAG, JB, A, I, J, DESCA, INFO )
*
   40    CONTINUE
*
      ELSE
*
*        Compute inverse of lower triangular matrix
*
         NN = ( ( JA+N-2 ) / DESCA( NB_ ) )*DESCA( NB_ ) + 1
         DO 50 J = NN, JN+1, -DESCA( NB_ )
            JB = MIN( DESCA( NB_ ), JA+N-J )
            I = IA + J - JA
            IF( J+JB.LE.JA+N-1 ) THEN
*
*              Compute rows j+jb:ja+n-1 of current block column
*
               CALL PDTRMM( 'Left', UPLO, 'No transpose', DIAG,
     $                      JA+N-J-JB, JB, ONE, A, I+JB, J+JB, DESCA,
     $                      A, I+JB, J, DESCA )
               CALL PDTRSM( 'Right', UPLO, 'No transpose', DIAG,
     $                      JA+N-J-JB, JB, -ONE, A, I, J, DESCA,
     $                      A, I+JB, J, DESCA )
            END IF
*
*           Compute inverse of current diagonal block
*
            CALL PDTRTI2( UPLO, DIAG, JB, A, I, J, DESCA, INFO )
*
   50    CONTINUE
*
*        Handle the last block of columns separately
*
         JB = JN-JA+1
         IF( JA+JB.LE.JA+N-1 ) THEN
*
*           Compute rows ja+jb:ja+n-1 of current block column
*
            CALL PDTRMM( 'Left', UPLO, 'No transpose', DIAG, N-JB, JB,
     $                   ONE, A, IA+JB, JA+JB, DESCA, A, IA+JB, JA,
     $                   DESCA )
            CALL PDTRSM( 'Right', UPLO, 'No transpose', DIAG, N-JB, JB,
     $                   -ONE, A, IA, JA, DESCA, A, IA+JB, JA, DESCA )
         END IF
*
*        Compute inverse of current diagonal block
*
         CALL PDTRTI2( UPLO, DIAG, JB, A, IA, JA, DESCA, INFO )
*
      END IF
*
      RETURN
*
      END
