      SUBROUTINE PDTRTI20( UPLO, DIAG, N, A, IA, JA, DESCA, INFO )
*
*     .. Scalar Arguments ..
      CHARACTER          DIAG, UPLO
      INTEGER            IA, INFO, JA, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE
      PARAMETER          ( ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            NOUNIT, UPPER
      INTEGER            IACOL, IAROW, ICTXT, ICURR, IDIAG, IIA, IOFFA,
     $                   JJA, LDA, MYCOL, MYROW, NA, NPCOL, NPROW
      DOUBLE PRECISION   AJJ
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_GRIDINFO, CHK1MAT, DSCAL,
     $                   DTRMV, INFOG2L, PXERBLA
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -707
      ELSE
         CALL CHK1MAT( N, 3, N, 3, IA, JA, DESCA, 7, INFO )
         UPPER = LSAME( UPLO, 'U' )
         NOUNIT = LSAME( DIAG, 'N' )
         IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
            INFO = -1
         ELSE IF( .NOT.NOUNIT .AND. .NOT.LSAME( DIAG, 'U' ) ) THEN
            INFO = -2
         END IF
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDTRTI2', -INFO )
         CALL BLACS_ABORT( ICTXT, 1 )
         RETURN
      END IF
*
*     Compute local indexes
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
*
      IF( MYROW.EQ.IAROW .AND. MYCOL.EQ.IACOL ) THEN
*
         LDA = DESCA( 8 )
*
         IF( UPPER ) THEN
*
            IOFFA = IIA + ( JJA - 1 ) * LDA
            ICURR = IOFFA + LDA
*
            IF( NOUNIT ) THEN
*
*              Compute inverse of upper non-unit triangular matrix.
*
               A( IOFFA ) = ONE / A( IOFFA )
               IDIAG = ICURR + 1
               DO 10 NA = 1, N-1
                  A( IDIAG ) = ONE / A( IDIAG )
                  AJJ = -A( IDIAG )
*
*                 Compute elements 1:j-1 of j-th column.
*
                  CALL DTRMV( 'Upper', 'No transpose', DIAG, NA,
     $                        A( IOFFA ), LDA, A( ICURR ), 1 )
                  CALL DSCAL( NA, AJJ, A( ICURR ), 1 )
                  IDIAG = IDIAG + LDA + 1
                  ICURR = ICURR + LDA
   10          CONTINUE
*
            ELSE
*
*              Compute inverse of upper unit triangular matrix.
*
               DO 20 NA = 1, N-1
*
*                 Compute elements 1:j-1 of j-th column.
*
                  CALL DTRMV( 'Upper', 'No transpose', DIAG, NA,
     $                        A( IOFFA ), LDA, A( ICURR ), 1 )
                  CALL DSCAL( NA, -ONE, A( ICURR ), 1 )
                  ICURR = ICURR + LDA
   20          CONTINUE
*
            END IF
*
         ELSE
*
            ICURR = IIA + N - 1 + ( JJA + N - 2 ) * LDA
            IOFFA = ICURR - LDA
*
            IF( NOUNIT ) THEN
*
*              Compute inverse of lower non-unit triangular matrix.
*
               A( ICURR ) = ONE / A( ICURR )
               IDIAG = IOFFA - 1
               DO 30 NA = 1, N-1
                  A( IDIAG ) = ONE / A( IDIAG )
                  AJJ = -A( IDIAG )
*
*                 Compute elements j+1:n of j-th column.
*
                  CALL DTRMV( 'Lower', 'No transpose', DIAG, NA,
     $                        A( ICURR ), LDA, A( IOFFA ), 1 )
                  CALL DSCAL( NA, AJJ, A( IOFFA ), 1 )
                  ICURR = IDIAG
                  IDIAG = IDIAG - LDA - 1
                  IOFFA = IDIAG + 1
   30          CONTINUE
*
            ELSE
*
*              Compute inverse of lower unit triangular matrix.
*
               DO 40 NA = 1, N-1
*
*                 Compute elements j+1:n of j-th column.
*
                  CALL DTRMV( 'Lower', 'No transpose', DIAG, NA,
     $                     A( ICURR ), LDA, A( IOFFA ), 1 )
                  CALL DSCAL( NA, -ONE, A( IOFFA ), 1 )
                  ICURR = ICURR - LDA - 1
                  IOFFA = ICURR - LDA
   40          CONTINUE
*
            END IF
*
         END IF
*
      END IF
*
      END
