#include "pblas0.h"

void pdtrsm0_( side, uplo, transa, diag, m, n, alpha, A, ia, ja, desc_A,
               B, ib, jb, desc_B )
/*
*  .. Scalar Arguments ..
*/
   F_CHAR      diag, side, transa, uplo;
   int         * ia, * ib, * ja, * jb, * m, * n;
   double      * alpha;
/* ..
*  .. Array Arguments ..
*/
   int         desc_A[], desc_B[];
   double      A[], B[];
{
/*
*  .. Local Scalars ..
*/
   char        * ctop, DiagA, matblk, * rtop, SideA, TrA, UploA;
   int         block, i, iacol, iarow, ibcol, iblk, ibpos, ibrow,
               icoffa, icoffb, ictxt, iia, iib, in, info, iroffa,
               iroffb, j, jblk, jja, jjb, jn, lcm, lcmp, lcmq, lside,
               mone=-1, mp0, mq0, mycol, myrow, nca, ncb, np0, nprow,
               npcol, nq0, nra, nrb, tmp0, tmp1, tmp2, wksz;
/* ..
*  .. PBLAS Buffer ..
*/
  double      * buff;
/* ..
*  .. External Functions ..
*/
   void        blacs_gridinfo_();
   void        pberror_();
   void        pbchkmat();
   char        * getpbbuf();
   char        * ptop();
   F_VOID_FCT  pbdtrsm_();
   F_INTG_FCT  ilcm_();
/* ..
*  .. Executable Statements ..
*
*  Get grid parameters
*/
   ictxt = desc_A[CTXT_];
   blacs_gridinfo_( &ictxt, &nprow, &npcol, &myrow, &mycol );
#if( _MACH_ == _T3D_ )
   blacs_pack( _cptofcd( YES, 1 ) );
#endif
/*
*  Test the input parameters
*/
   info = 0;
   if( nprow == -1 )
      info = -1107;
   else
   {
      DiagA = Mupcase( F2C_CHAR( diag )[0] );
      UploA = Mupcase( F2C_CHAR( uplo )[0] );
      SideA = Mupcase( F2C_CHAR( side )[0] );
      lside  = ( SideA == 'L' );
      TrA = Mupcase( F2C_CHAR( transa )[0] );
      iroffa = (*ia-1) % desc_A[MB_];
      icoffa = (*ja-1) % desc_A[NB_];
      iroffb = (*ib-1) % desc_B[MB_];
      icoffb = (*jb-1) % desc_B[NB_];
      if( lside )
      {
         block = ( ( ( (*m) + iroffa ) <= desc_A[MB_] ) &&
                   ( ( (*m) + icoffa ) <= desc_A[NB_] ) );
         pbchkmat( *m, 5, *m, 5, *ia, *ja, desc_A, 11, &iia, &jja,
                   &iarow, &iacol, nprow, npcol, myrow, mycol,
                   &nra, &nca, &info );
      }
      else
      {
         block = ( ( ( (*n) + iroffa ) <= desc_A[MB_] ) &&
                   ( ( (*n) + icoffa ) <= desc_A[NB_] ) );
         pbchkmat( *n, 6, *n, 6, *ia, *ja, desc_A, 11, &iia, &jja,
                   &iarow, &iacol, nprow, npcol, myrow, mycol,
                   &nra, &nca, &info );
      }
      pbchkmat( *m, 5, *n, 6, *ib, *jb, desc_B, 15, &iib, &jjb,
                &ibrow, &ibcol, nprow, npcol, myrow, mycol,
                &nrb, &ncb, &info );
      if( info == 0 )
      {
         if( ( SideA != 'R' ) && ( SideA != 'L' ) )
            info = -1;
         else if( ( UploA != 'U' ) && (UploA != 'L' ) )
            info = -2;
         else if( ( TrA != 'N' ) && ( TrA != 'T' ) && ( TrA != 'C' ) )
            info = -3;
         else if( ( DiagA != 'U' ) && ( DiagA != 'N' ) )
            info = -4;
         else if( !block && desc_A[MB_] != desc_A[NB_] )
            info = -1104;
         else if( !block && ( iroffa != 0 ) )
            info = -9;
         else if( !block && ( icoffa != 0 ) )
            info = -10;
         if( lside )
         {
/*          if( ( block && ( iroffb != 0 ) ) || ( ibrow != iarow ) ) */
            if( ( ibrow != iarow ) )
               info = -13;
            else if( block && ( nprow != 1 ) &&
                     ( (*m)+iroffb > desc_B[MB_] ) )
               info = -13;
            else if( !block && ( desc_A[NB_] != desc_B[MB_] ) )
               info = -1503;
         }
         else
         {
/*          if( ( block && ( icoffb != 0 ) ) || ( ibcol != iacol ) ) */
            if( ( ibcol != iacol ) )
               info = -14;
            else if( block && ( npcol != 1 ) &&
                     ( (*n)+icoffb > desc_B[NB_] ) )
               info = -14;
            else if( !block && (desc_A[MB_] != desc_B[NB_]) )
               info = -1504;
         }
         if( ictxt != desc_B[CTXT_] )
            info = -1507;
      }
   }
   if( info )
   {
      pberror_( &ictxt, "PDTRSM", &info );
      return;
   }
/*
*  Quick return if possible
*/
   if( *m == 0 || *n == 0 )
      return;
/*
*  Figure out the arguments to be passed to pbdtrsm
*/
   if( lside )
   {
      ibpos = ibcol;
      if( block )
      {
         matblk = 'B';
         wksz = (*m) * (*m);
      }
      else
      {
         matblk = 'M';
         if( TrA == 'N' )
         {
            tmp0 = npcol-1;
            tmp0 = CEIL( tmp0, nprow );
            tmp0 = MAX( 1, tmp0 );
            tmp1 = (*m) / desc_A[MB_];
            wksz = desc_B[NB_] * ( desc_A[MB_] * tmp0 +
                   MYROC0( tmp1, *m, desc_A[MB_], nprow ) );
         }
         else
         {
            tmp0 = nprow-1;
            tmp0 = CEIL( tmp0, npcol );
            tmp0 = desc_A[MB_] * MAX( 1, tmp0 );
            lcm = ilcm_( &nprow, &npcol );
            lcmq = lcm / npcol;
            tmp1 = (*m) / desc_A[NB_];
            mq0 = MYROC0( tmp1, *m, desc_A[NB_], npcol );
            tmp1 = mq0 / desc_A[NB_];
            tmp1 = MYROC0( tmp1, mq0, desc_A[NB_], lcmq );
            lcmp = lcm / nprow;
            tmp2 = (*m) / desc_A[MB_];
            mp0 = MYROC0( tmp2, *m, desc_A[MB_], nprow );
            tmp2 = mp0 / desc_A[NB_];
            tmp2 = MYROC0( tmp2, mp0, desc_A[MB_], lcmp );
            tmp2 = MAX( tmp1, tmp2 );
            wksz = desc_B[NB_] * ( mq0 + MAX( tmp0, tmp2 ) );
         }
      }
   }
   else
   {
      ibpos = ibrow;
      if( block )
      {
         matblk = 'B';
         wksz = (*n) * (*n);
      }
      else
      {
         matblk = 'M';
         if( TrA == 'N' )
         {
            tmp0 = nprow-1;
            tmp0 = CEIL( tmp0, npcol );
            tmp0 = MAX( 1, tmp0 );
            tmp1 = (*n) / desc_A[MB_];
            wksz = desc_B[MB_] * ( desc_A[MB_]*tmp0 +
                   MYROC0( tmp1, *n, desc_A[MB_], npcol ) );
         }
         else
         {
            tmp0 = npcol-1;
            tmp0 = CEIL( tmp0, nprow );
            tmp0 = desc_A[MB_] * MAX( 1, tmp0 );
            lcm = ilcm_( &nprow, &npcol );
            lcmq = lcm / npcol;
            tmp1 = (*n) / desc_A[NB_];
            nq0 = MYROC0( tmp1, *n, desc_A[NB_], npcol );
            tmp1 = nq0 / desc_A[NB_];
            tmp1 = MYROC0( tmp1, nq0, desc_A[NB_], lcmq );
            lcmp = lcm / nprow;
            tmp2 = (*n) / desc_A[MB_];
            np0 = MYROC0( tmp2, *n, desc_A[MB_], nprow );
            tmp2 = np0 / desc_A[NB_];
            tmp2 = MYROC0( tmp2, np0, desc_A[MB_], lcmp );
            tmp2 = MAX( tmp1, tmp2 );
            wksz = desc_B[MB_] * ( np0 + MAX( tmp0, tmp2 ) );
         }
      }
   }
   buff = (double *)getpbbuf( "PDTRSM", wksz*sizeof(double) );
/*
*  Call PB-BLAS routine
*/
   if( block )
   {
      if( lside )
      {
         rtop = ptop( BROADCAST, ROW, TOPGET );
         j = CEIL( (*jb), desc_B[NB_] ) * desc_B[NB_];
         jn = (*jb)+(*n)-1;
         jn = MIN( j, jn );
                                     /* Handle first block separately */
         jblk = jn-(*jb)+1;
         pbdtrsm_( &ictxt, C2F_CHAR( &matblk ), side, uplo, transa,
                   diag, m, &jblk, &desc_B[NB_], alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                   &iarow, &iacol, &ibpos, C2F_CHAR( rtop ),
                   C2F_CHAR( NO ), buff );
         if( mycol == ibpos )
         {
            jjb += jblk;
            jjb = MIN( jjb, ncb );
         }
         ibpos = (ibpos+1) % npcol;
         jblk = (*n) - jblk;
         pbdtrsm_( &ictxt, C2F_CHAR( &matblk ), side, uplo, transa,
                   diag, m, &jblk, &desc_B[NB_], alpha, buff, m,
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], &iarow,
                   &mone, &ibpos, C2F_CHAR( rtop ), C2F_CHAR( YES ), buff );
      }
      else
      {
         ctop = ptop( BROADCAST, COLUMN, TOPGET );
         i = CEIL( (*ib), desc_B[MB_] ) * desc_B[MB_];
         in = (*ib)+(*m)-1;
         in = MIN( i, in );
                                     /* Handle first block separately */
         iblk = in-(*ib)+1;
         pbdtrsm_( &ictxt, C2F_CHAR( &matblk ), side, uplo, transa,
                   diag, &iblk, n, &desc_B[MB_], alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                   &iarow, &iacol, &ibpos, C2F_CHAR( ctop ),
                   C2F_CHAR( NO ), buff );
         if( myrow == ibpos )
         {
            iib += iblk;
            iib = MIN( iib, nrb );
         }
         ibpos = (ibpos+1) % nprow;
         iblk = (*m) - iblk;
         pbdtrsm_( &ictxt, C2F_CHAR( &matblk ), side, uplo, transa,
                   diag, &iblk, n, &desc_B[MB_], alpha, buff, n,
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                   &mone, &iacol, &ibpos, C2F_CHAR( ctop ),
                   C2F_CHAR( YES ), buff );
      }
   }
   else
   {
      if( lside )
      {
         j = CEIL( (*jb), desc_B[NB_] ) * desc_B[NB_];
         jn = (*jb)+(*n)-1;
         jn = MIN( j, jn );
                                     /* Handle first block separately */
         jblk = jn-(*jb)+1;
         pbdtrsm_( &ictxt, C2F_CHAR( &matblk ), side, uplo, transa,
                   diag, m, &jblk, &desc_A[MB_], alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                   &iarow, &iacol, &ibpos, C2F_CHAR( TOPDEF ),
                   C2F_CHAR( NO ), buff );
         if( mycol == ibpos )
         {
            jjb += jblk;
            jjb = MIN( jjb, ncb );
         }
         ibpos = (ibpos+1) % npcol;
                              /* loop over remaining block of columns */
         tmp0 = (*jb)+(*n)-1;
         for( j=jn+1; j<=tmp0; j+=desc_B[NB_] )
         {
             jblk = (*n)-j+(*jb);
             jblk = MIN( desc_B[NB_], jblk );
             pbdtrsm_( &ictxt, C2F_CHAR( &matblk ), side, uplo, transa,
                       diag, m, &jblk, &desc_A[MB_], alpha,
                       &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                       &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                       &iarow, &iacol, &ibpos, C2F_CHAR( TOPDEF ),
                       C2F_CHAR( NO ), buff );
             if( mycol == ibpos )
             {
                jjb += jblk;
                jjb = MIN( jjb, ncb );
             }
             ibpos = (ibpos+1) % npcol;
         }
      }
      else
      {
         i = CEIL( (*ib), desc_B[MB_] ) * desc_B[MB_];
         in = (*ib)+(*m)-1;
         in = MIN( i, in );
                                     /* Handle first block separately */
         iblk = in-(*ib)+1;
         pbdtrsm_( &ictxt, C2F_CHAR( &matblk ), side, uplo, transa,
                   diag, &iblk, n, &desc_A[MB_], alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                   &iarow, &iacol, &ibpos, C2F_CHAR( TOPDEF ),
                   C2F_CHAR( NO ), buff );
         if( myrow == ibpos )
         {
            iib += iblk;
            iib = MIN( iib, nrb );
         }
         ibpos = (ibpos+1) % nprow;
                                 /* loop over remaining block of rows */
         tmp0 =  (*ib)+(*m)-1;
         for( i=in+1; i<=tmp0; i+=desc_B[MB_] )
         {
             iblk = *m-i+(*ib);
             iblk = MIN( desc_B[MB_], iblk );
             pbdtrsm_( &ictxt, C2F_CHAR( &matblk ), side, uplo, transa,
                       diag, &iblk, n, &desc_A[MB_], alpha,
                       &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                       &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                       &iarow, &iacol, &ibpos, C2F_CHAR( TOPDEF ),
                       C2F_CHAR( NO ), buff );
             if( myrow == ibpos )
             {
                iib += iblk;
                iib = MIN( iib, nrb );
             }
             ibpos = (ibpos+1) % nprow;
         }
      }
   }
#if( _MACH_ == _T3D_ )
   blacs_pack( _cptofcd( NO, 1 ) );
#endif
}
