      SUBROUTINE PDSUMCHK0( M, N, K, ALPHA, IASEED, IA, JA, DESCA,
     $                      IBSEED, IB, JB, DESCB, BETA, C, IC, JC, 
     $                      DESCC, ICSEED, WORK, RESID )
*
*     .. Scalar Arguments ..
      INTEGER            IA, IB, IC, IASEED, IBSEED, ICSEED, JA, JB,
     $                   JC, K, M, N
      DOUBLE PRECISION   ALPHA, BETA, RESID
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * ), DESCC( * )
      DOUBLE PRECISION   C( * ), WORK( * )
*     ..
*
* ======================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ONE,           ZERO
      PARAMETER        ( ONE  = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IBB, ICTXT, ICURCOL, ICURROW, II, IPA, IPB,
     $                   IPC, J, JBB, JJ, KK, KQ, LL, MP, MYCOL, MYROW,
     $                   NPCOL, NPROW, NQ, IAROW, IACOL, IBROW, IBCOL,
     $                   ICROW, ICCOL, ICOFFA, ICOFFB, ICOFFC, IIA, IIB,
     $                   IIC, IIWA, IIWB, IIWC, IN, IOFFC, IPA0, IPB0,
     $                   IPC0, IROFFA, IROFFB, IROFFC, JJA, JJB, JJC,
     $                   JJWA, JJWB, JJWC, JN, KQA, LDW, MPC, NCOLB,
     $                   NQC, NROWA
*     ..
*     .. External Subroutines ..
      EXTERNAL           DGEMM, PDMATGEN, DMATADD, BLACS_GRIDINFO,
     $                   DGEBR2D, DGEBS2D, DGSUM2D
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            NUMROC, ICEIL
      DOUBLE PRECISION   PDLANGE
      EXTERNAL           LSAME, NUMROC, PDLANGE, ICEIL
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Start the operations
*
      IROFFA = MOD( IA-1, DESCA( MB_ ) )
      ICOFFA = MOD( JA-1, DESCA( NB_ ) )
      IROFFB = MOD( IB-1, DESCB( MB_ ) )
      ICOFFB = MOD( JB-1, DESCB( NB_ ) )
      IROFFC = MOD( IC-1, DESCC( MB_ ) )
      ICOFFC = MOD( JC-1, DESCC( NB_ ) )
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
      CALL INFOG2L( IB, JB, DESCB, NPROW, NPCOL, MYROW, MYCOL, IIB, JJB,
     $              IBROW, IBCOL )
      CALL INFOG2L( IC, JC, DESCC, NPROW, NPCOL, MYROW, MYCOL, IIC, JJC,
     $              ICROW, ICCOL )
*
      MPC = NUMROC( M+IROFFC, DESCC( MB_ ), MYROW, ICROW, NPROW )
      NQC = NUMROC( N+ICOFFC, DESCC( NB_ ), MYCOL, ICCOL, NPCOL )
      KQA = NUMROC( K+ICOFFA, DESCA( NB_ ), MYCOL, IACOL, NPCOL )
*
      IF( MYCOL.EQ.IACOL ) THEN
         KQ = KQA - ICOFFA
      ELSE
         KQ = KQA
      END IF
*
      IF( MYROW.EQ.ICROW ) THEN
         MP = MPC - IROFFC
      ELSE
         MP = MPC
      END IF
*
      IF( MYCOL.EQ.ICCOL ) THEN
         NQ = NQC - ICOFFC
      ELSE
         NQ = NQC
      END IF
*
*     Pointers for working array of size
*     DESCC( MB_ )*KQA + KQA*DESCC( NB_ ) + DESCC( MB_ )*DESCC( NB_ )
*
      IPA = 1
      IPB = DESCC( MB_ )*KQA + IPA
      IPC = KQA*DESCC( NB_ ) + IPB
*
      IF( MYROW.EQ.ICROW ) THEN
         IIWC = IIC - IROFFC
         IPC0 = IPC + IROFFC
         MP = MPC - IROFFC
      ELSE
         IIWC = IIC
         IPC0 = IPC
         MP = MPC
      END IF
*
      IF( MYCOL.EQ.ICCOL ) THEN
         JJWC = JJC - ICOFFC
         IPC0 = IPC0 + ICOFFC * DESCC( MB_ )
         NQ = NQC - ICOFFC
      ELSE
         JJWC = JJC
         IPC0 = IPC0
         NQ = NQC
      END IF
*
*     Computes C := C - beta*C (WORK of size DESCC( MB_ ) * NQC)
*
*     Handle first block separately
*
      LDW = MAX( 1, DESCC( MB_ ) )
      IOFFC = IIC + ( JJC - 1 ) * DESCC( LLD_ )
      IN = MIN( ICEIL( IC, DESCC( MB_ ) ) * DESCC( MB_ ), IC+M-1 )
      JN = MIN( ICEIL( JC, DESCC( NB_ ) ) * DESCC( NB_ ), JC+N-1 )
*
      IF( MYROW.EQ.ICROW .AND. IROFFC.NE.0 ) THEN
         IBB = IN-IC+1
         CALL PDMATGEN( ICTXT, 'N', 'N', DESCC( M_ ), DESCC( N_ ),
     $                  DESCC( MB_ ), DESCC( NB_ ), WORK, LDW,
     $                  DESCC( RSRC_ ), DESCC( CSRC_ ), ICSEED, IIWC-1,
     $                  IBB+IROFFC, JJWC-1, NQC, MYROW, MYCOL,
     $                  NPROW, NPCOL )
         IF( MYCOL.EQ.ICCOL ) THEN
            CALL DMATADD( IBB, NQ, -BETA, WORK(IROFFC+1+ICOFFC*LDW),
     $                    LDW, ONE, C( IOFFC ), DESCC( LLD_ ) )
         ELSE
            CALL DMATADD( IBB, NQ, -BETA, WORK(IROFFC+1), LDW, ONE,
     $                    C( IOFFC ), DESCC( LLD_ ) )
         END IF
         MP  = MP - IBB
         IIC = IIC + IBB
         IOFFC = IOFFC + IBB
      END IF
*
*     Handle the remaning blocks of columns
*
      DO 10 II = IIC, IIC+MP-1, DESCC( MB_ )
         IBB = MIN( DESCC( MB_ ), IIC+MP-II )
         IOFFC = II + ( JJC - 1 ) * DESCC( LLD_ )
         CALL PDMATGEN( ICTXT, 'N', 'N', DESCC( M_ ), DESCC( N_ ),
     $                  DESCC( MB_ ), DESCC( NB_ ), WORK, LDW,
     $                  DESCC( RSRC_ ), DESCC( CSRC_ ), ICSEED, II-1,
     $                  IBB, JJWC-1, NQC, MYROW, MYCOL, NPROW, NPCOL )
         IF( MYCOL.EQ.ICCOL ) THEN
            CALL DMATADD( IBB, NQ, -BETA, WORK(1+ICOFFC*LDW), LDW, ONE,
     $                    C( IOFFC ), DESCC( LLD_ ) )
         ELSE
            CALL DMATADD( IBB, NQ, -BETA, WORK, LDW, ONE, C( IOFFC ),
     $                    DESCC( LLD_ ) )
         END IF
   10 CONTINUE
*
      IF( MYROW.EQ.IAROW ) THEN
         IIWA = IIA - IROFFA
         IPA0 = IPA + IROFFA
      ELSE
         IIWA = IIA
         IPA0 = IPA
      END IF
*
      IF( MYCOL.EQ.IACOL ) THEN
         JJWA = JJA - ICOFFA
         IPA0 = IPA0 + ICOFFA * DESCA( MB_ )
      ELSE
         JJWA = JJA
         IPA0 = IPA0
      END IF
*
      IF( MYROW.EQ.IBROW ) THEN
         IIWB = IIB - IROFFB
         IPB0 = IPB + IROFFB
      ELSE
         IIWB = IIB
         IPB0 = IPB
      END IF
*
      IF( MYCOL.EQ.IBCOL ) THEN
         JJWB = JJB - ICOFFB
         IPB0 = IPB0 + ICOFFB * DESCB( NB_ )
      ELSE
         JJWB = JJB
         IPB0 = IPB0
      END IF
*
      IF( MYROW.EQ.ICROW ) THEN
         II = IIWC + IROFFC
         MP = MPC - IROFFC
      ELSE
         II = IIWC
         MP = MPC
      END IF
*
      ICURROW = IAROW
      ICURCOL = IBCOL
*
      DO 60 I = IA-ICOFFA, IA+M-1, NPROW*DESCA( MB_ )
         IBB = MIN( IIWC+MPC-IIWA, DESCA( MB_ ) )
*
*        regenerate NPROW*DESCA( MB_ ) rows of A
*
         CALL PDMATGEN( ICTXT, 'N', 'N', DESCA( M_ ), DESCA( N_ ),
     $                  DESCA( MB_ ), DESCA( NB_ ), WORK( IPA ),
     $                  DESCA( MB_ ), DESCA( RSRC_ ), DESCA( CSRC_ ), 
     $                  IASEED, IIWA-1,
     $                  IBB, JJWA-1, KQA, MYROW, MYCOL, NPROW,
     $                  NPCOL )
         IF( I.EQ.( IA-ICOFFA ) ) THEN
*
            IF( MYROW.EQ.IAROW ) THEN
               NROWA = MIN( IN - IA + 1, IBB )
            ELSE
               NROWA = IBB
            END IF
*
            IF( MYROW.EQ.IAROW ) THEN
               IPA0 = IPA + IROFFA
            ELSE
               IPA0 = IPA
            END IF
*
            IF( MYCOL.EQ.IACOL ) THEN
               IPA0 = IPA0 + ICOFFA * DESCA( MB_ )
            ELSE
               IPA0 = IPA0
            END IF
*
            IF( MYROW.EQ.ICROW ) THEN
               IPC0 = IPC + IROFFC
            ELSE
               IPC0 = IPC
            END IF
*
         ELSE
            NROWA = IBB
            IF( MYCOL.EQ.IACOL ) THEN
               IPA0 = IPA + ICOFFA * DESCA( MB_ )
            ELSE
               IPA0 = IPA
            END IF
            IPC0 = IPC
         END IF
*
         KK = IIWB
         IF( MYCOL.EQ.ICCOL ) THEN
            NQ = NQC - IROFFC
         ELSE
            NQ = NQC
         END IF
         JJ = JJC
         ICURCOL = IBCOL
         ICURROW = IBROW
*
         DO 50 J = JB-ICOFFB, JB+N-1, DESCB( NB_ )
            JBB = MIN( JB+N-J, DESCB( NB_ ) )
*
*           Regenerate DESCB( NB_ ) (JBB) columns of B (JBB rows of B')
*
            IF( MYROW.EQ.ICURROW ) THEN
                CALL PDMATGEN( ICTXT, 'T', 'N', DESCB( N_ ), 
     $                         DESCB( M_ ), DESCB( NB_ ),
     $                         DESCB( MB_ ), WORK( IPB ),
     $                         DESCB( NB_ ), DESCB( RSRC_ ),
     $                         DESCB( CSRC_ ), IBSEED, KK-1, JBB,
     $                         JJWB-1, KQA, MYROW, MYCOL, NPROW, NPCOL )
                CALL DGEBS2D( ICTXT, 'Col', '1-tree', JBB, KQA,
     $                        WORK( IPB ), DESCB( NB_ ) )
            ELSE
                CALL DGEBR2D( ICTXT, 'Col', '1-tree', JBB, KQA,
     $                        WORK( IPB ), DESCB( NB_ ), ICURROW,
     $                        MYCOL )
            END IF
*
            IF( J.EQ.( JB-ICOFFB ) ) THEN
               NCOLB = MIN( JN - JB + 1, JBB )
               IPB0 = IPB + ICOFFB
*
               IF( MYCOL.EQ.IBCOL ) THEN
                  IPB0 = IPB0 + IROFFB * DESCB( NB_ )
               ELSE
                  IPB0 = IPB0
               END IF
*
               IF( MYCOL.EQ.IBCOL ) THEN
                  IPC0 = IPC0 + ICOFFB * DESCC( MB_ )
               ELSE
                  IPC0 = IPC0
               END IF
*
            ELSE
               NCOLB = JBB
               IF( MYCOL.EQ.IBCOL ) THEN
                  IPB0 = IPB + IROFFB * DESCB( NB_ )
               ELSE
                  IPB0 = IPB
               END IF
               IPC0 = IPC0
            END IF
*
*           Computes C := C - alpha*A*B
*
            IF( KQ.GT.0 .AND. NROWA.GT.0 .AND. NCOLB.GT.0 ) THEN
               CALL DGEMM( 'N', 'T', NROWA, NCOLB, KQ, ALPHA,
     $                     WORK( IPA0 ), DESCA( MB_ ), WORK( IPB0 ),
     $                     DESCB( NB_ ), ZERO, WORK( IPC0 ),
     $                     DESCC( MB_ ) )
            ELSE
               DO 30 LL = 0, DESCC( MB_ )*NCOLB-1
                  WORK( IPC0 + LL ) = ZERO
   30          CONTINUE
            END IF
*
            CALL DGSUM2D( ICTXT, 'Row', '1-tree', NROWA, NCOLB,
     $                    WORK( IPC0 ), DESCC( MB_ ), MYROW, ICURCOL )
*
            IF( II-IIC.LE.MP ) THEN
               IF( MYCOL.EQ.ICURCOL ) THEN
                  CALL DMATADD( NROWA, NCOLB, -ONE, WORK( IPC0 ),
     $                          DESCC( MB_ ), ONE, 
     $                          C(II+(JJ-1)*DESCC( LLD_ )),
     $                          DESCC( LLD_ ) )
               END IF
            END IF
*
            IF( MYROW.EQ.ICURROW ) KK = KK + JBB
            IF( MYCOL.EQ.ICURCOL ) JJ = JJ + NCOLB
            ICURCOL = MOD( ICURCOL+1, NPCOL )
            ICURROW = MOD( ICURROW+1, NPROW )
*
   50    CONTINUE
*
         II = II + NROWA
         IIWA = IIWA + IBB
*
   60 CONTINUE
*
      RESID = PDLANGE( 'I', M, N, C, IC, JC, DESCC, WORK )
*
      RETURN
*
      END
