      SUBROUTINE PDSDCUPD( WANTT, WANTZ, M, N, ILO, A, IA, JA, DESCA,
     $                     Z, IZ, JZ, DESCZ, Q, IQ, JQ, DESCQ,
     $                     WORK )
*
*     Updates the Schur vectors and/or block triangular matrix based 
*     on the orthogonal matrix computed from the current matrix block --
*        A(IA+ILO-1:IA+ILO+N-1, JA+ILO-1:JA+ILO+N-1)
*
*     Please see the comments in PDHALFP for additional details.
*
      LOGICAL             WANTT, WANTZ
      INTEGER             M, N, ILO, IA, JA, IZ, JZ, IQ, JQ
      INTEGER             DESCA( * ), DESCZ( * ), DESCQ( * )
      DOUBLE PRECISION    A( * ), Z( * ), Q( * ), WORK( * )
*
*     .. Parameters ..
      INTEGER            CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            IZ2, JZ2, IROFF, ICOFF, IZW, JZW,
     $                   IROW, ICOL, MP, NQ, IPZW, 
     $                   IA2, JA2, IAW, JAW, IPAW, MROWS, NCOLS,
     $                   NPROW, NPCOL, MYROW, MYCOL, M2
*     ..
*     .. Local Arrays ..
      INTEGER            DESCZW( DLEN_ ), DESCAW( DLEN_ )
*     ..
*     .. External Functions ..
      INTEGER            INDXG2P, NUMROC
      EXTERNAL           INDXG2P, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           PDGEMM0, PDLACPY, BLACS_GRIDINFO, DESCSET
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN, MOD
***
***   Debugging variables/functions/subroutines
***
      logical            debug, printit
      integer            ipw
      double precision   dummy, dummy2, pdlange
      external           pdlange, print_desc
*     ..
*     .. Executable Statements ..
*
      IF ( .NOT. WANTZ .AND. .NOT. WANTT )
     $   RETURN

      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, MYROW, MYCOL )
***
***   Debugging - intialization
***
      debug = .false.
      printit = debug .and. myrow .eq. 0 .and. mycol .eq. 0

      IF ( WANTZ ) THEN
*
*        Accumulate orthogonal transformations.
*        Must compute the new orthogonal matrix from the previous
*        Z and the Schur vectors of the (N x N) system just computed.
*        Only update the (IA:IA+M-1, IA+ILO:IA+ILO+N-1) block of Z.
*
         IPZW = 1
         IZ2 = IZ
         JZ2 = JZ + ILO - 1
         IROFF = MOD( IZ2-1, DESCZ( MB_ ) )
         ICOFF = MOD( JZ2-1, DESCZ( NB_ ) )
         IZW = IROFF + 1
         JZW = ICOFF + 1
         IROW = INDXG2P( IZ2, DESCZ( MB_ ), MYROW,
     $                   DESCZ( RSRC_ ), NPROW )
         ICOL = INDXG2P( JZ2, DESCZ( NB_ ), MYCOL,
     $                   DESCZ( CSRC_ ), NPCOL )
         MP = NUMROC( M + IROFF, DESCZ( MB_ ), MYROW, IROW, NPROW )
         NQ = NUMROC( N + ICOFF, DESCZ( NB_ ), MYCOL, ICOL, NPCOL )

         CALL DESCSET( DESCZW, M + IROFF, N + ICOFF, DESCZ( MB_ ),
     $               DESCZ( NB_ ), IROW, ICOL, DESCZ( CTXT_ ),
     $               MAX( 1, MP ) )

	call BLACS_BARRIER( DESCA( CTXT_ ), 'All' )

         CALL PDGEMM0( 'No trans', 'No trans', M, N, N, ONE,
     $                 Z, IZ2, JZ2, DESCZ, Q, IQ, JQ, DESCQ,
     $                 ZERO, WORK( IPZW ), IZW, JZW, DESCZW )

         CALL PDLACPY( 'FULL', M, N, WORK( IPZW ), IZW, JZW, DESCZW,
     $                 Z, IZ2, JZ2, DESCZ )
      END IF

      IF ( WANTT ) THEN
*
*     Update the off-diagonal blocks.
*
         IPAW = 1
         IF ( ILO .NE. 1 ) THEN
*
*        A12 = A12 * Q
*
            IA2 = IA
            JA2 = JA + ILO - 1
            IROFF = MOD( IA2 - 1, DESCA( MB_ ) )
            ICOFF = MOD( JA2 - 1, DESCA( NB_ ) )
            IAW = IROFF + 1
            JAW = ICOFF + 1
            IROW = INDXG2P( IA2, DESCA( MB_ ), MYROW,
     $                      DESCA( RSRC_ ), NPROW )
            ICOL = INDXG2P( JA2, DESCA( NB_ ), MYCOL,
     $                      DESCA( CSRC_ ), NPCOL )
            MROWS = ILO - 1
            IF ( MROWS .LT. N ) THEN
               M2 = N
            ELSE
               M2 = MROWS
            END IF
            MP = NUMROC( M2 + IROFF, DESCA( MB_ ), MYROW, 
     $                   IROW, NPROW )
            NQ = NUMROC( N + ICOFF, DESCA( NB_ ), MYCOL, ICOL, NPCOL )

            CALL DESCSET( DESCAW, M2 + IROFF, N + ICOFF, 
     $                    DESCA( MB_ ), DESCA( NB_ ), IROW, ICOL,
     $                    DESCA( CTXT_ ), MAX( 1, MP ) )
***
***         Debugging
***
            if (debug) then
               if (printit) call print_desc(DESCAW, 'A12     ')
               if (printit) call print_desc(DESCA,  'A       ')
               if (printit) call print_desc(DESCQ,  'SmallQ  ')
            end if

            CALL PDGEMM0( 'No trans', 'No trans', M2, N, N, ONE,
     $                    A, IA2, JA2, DESCA, Q, IQ, JQ, DESCQ,
     $                    ZERO, WORK( IPAW ), IAW, JAW, DESCAW )

            CALL PDLACPY( 'All', MROWS, N, WORK( IPAW ), IAW, JAW,
     $                    DESCAW, A, IA2, JA2, DESCA )
         END IF

         IF ( ( ILO + N - 1 ) .NE. M ) THEN
*
*           A23 = Q^t * A23
*
            IA2 = IA + ILO - 1
            JA2 = JA + ILO + N - 1
            IROFF = MOD( IA2 - 1, DESCA( MB_ ) )
            ICOFF = MOD( JA2 - 1, DESCA( NB_ ) )
            IAW = IROFF + 1
            JAW = ICOFF + 1
            IROW = INDXG2P( IA2, DESCA( MB_ ), MYROW,
     $                      DESCA( RSRC_ ), NPROW )
            ICOL = INDXG2P( JA2, DESCA( NB_ ), MYCOL,
     $                      DESCA( CSRC_ ), NPCOL )
            NCOLS = M - ( ILO + N - 1 )
            MP = NUMROC( N + IROFF, DESCA( MB_ ), MYROW,
     $                   IROW, NPROW )
            NQ = NUMROC( NCOLS + ICOFF, DESCA( NB_ ), MYCOL, 
     $                   ICOL, NPCOL )
            CALL DESCSET( DESCAW, N + IROFF, NCOLS + ICOFF,
     $                    DESCA( MB_ ), DESCA( NB_ ), IROW, ICOL,
     $                    DESCA( CTXT_ ), MAX( 1, MP ) )

            CALL PDGEMM0( 'Trans', 'No trans', N, NCOLS, N, ONE,
     $                    Q, IQ, JQ, DESCQ, A, IA2, JA2, DESCA,
     $                    ZERO, WORK( IPAW ), IAW, JAW, DESCAW )

            CALL PDLACPY( 'All', N, NCOLS, WORK( IPAW ), IAW, JAW,
     $                    DESCAW, A, IA2, JA2, DESCA )

         END IF

      END IF

*
*     End of PDSDCUPD
*
	RETURN
	END

      SUBROUTINE PDSDCUPD2( WANTT, WANTZ, M, N, ILO, A, IA, JA, DESCA,
     $                     Z, IZ, JZ, DESCZ, Q, IQ, JQ, DESCQ,
     $                     QT, WORK )
*
*     Updates the Schur vectors and/or Schur form based on the orthogonal
*     matrix computed from the current matrix block --
*        A(IA+ILO-1:IA+ILO+N-1, JA+ILO-1:JA+ILO+N-1)
*   
*     NOTE: this is a temporary hack since PDGEMM0 won't handle transposes yet.
*

      LOGICAL             WANTT, WANTZ
      INTEGER             M, N, ILO, IA, JA, IZ, JZ, IQ, JQ
      INTEGER             DESCA( * ), DESCZ( * ), DESCQ( * )
      DOUBLE PRECISION    A( * ), Z( * ), Q( * ), WORK( * ), QT( * )
*
*     .. Parameters ..
      INTEGER            CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            IZ2, JZ2, IROFF, ICOFF, IZW, JZW,
     $                   IROW, ICOL, MP, NQ, IPZW, 
     $                   IA2, JA2, IAW, JAW, IPAW, MROWS, NCOLS,
     $                   NPROW, NPCOL, MYROW, MYCOL, M2, EXTRACOLS, N2
	integer ipw
	double precision dummy, dummy2, pdlange
	external pdlange
*     ..
*     .. Local Arrays ..
      INTEGER            DESCZW( DLEN_ ), DESCAW( DLEN_ )
*     ..
*     .. External Functions ..
      INTEGER            INDXG2P, NUMROC
      EXTERNAL           INDXG2P, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           PDGEMM0, PDLACPY, BLACS_GRIDINFO, DESCSET
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN, MOD
***
***   Debugging variables/functions/subroutines
***
      logical            debug, printit
      external           print_desc
*     ..
*     .. Executable Statements ..
*
      IF ( .NOT. WANTZ .AND. .NOT. WANTT )
     $   RETURN

      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, MYROW, MYCOL )

      debug = .false.
      printit = debug .and. myrow .eq. 0 .and. mycol .eq. 0

      IF ( WANTZ ) THEN
*
*        Accumulate orthogonal transformations.
*        Must compute the new orthogonal matrix from the previous
*        Z and the Schur vectors of the (N x N) system just computed.
*        Only update the (IA:IA+M-1, IA+ILO:IA+ILO+N-1) block of Z.
*
         IPZW = 1
         IZ2 = IZ
         JZ2 = JZ + ILO - 1
         IROFF = MOD( IZ2-1, DESCZ( MB_ ) )
         ICOFF = MOD( JZ2-1, DESCZ( NB_ ) )
         IZW = IROFF + 1
         JZW = ICOFF + 1
         IROW = INDXG2P( IZ2, DESCZ( MB_ ), MYROW,
     $                   DESCZ( RSRC_ ), NPROW )
         ICOL = INDXG2P( JZ2, DESCZ( NB_ ), MYCOL,
     $                   DESCZ( CSRC_ ), NPCOL )
         MP = NUMROC( M + IROFF, DESCZ( MB_ ), MYROW, IROW, NPROW )
         NQ = NUMROC( N + ICOFF, DESCZ( NB_ ), MYCOL, ICOL, NPCOL )

         CALL DESCSET( DESCZW, M + IROFF, N + ICOFF, DESCZ( MB_ ),
     $               DESCZ( NB_ ), IROW, ICOL, DESCZ( CTXT_ ),
     $               MAX( 1, MP ) )

	call BLACS_BARRIER( DESCA( CTXT_ ), 'All' )

         CALL PDGEMM0( 'No trans', 'No trans', M, N, N, ONE,
     $                 Z, IZ2, JZ2, DESCZ, Q, IQ, JQ, DESCQ,
     $                 ZERO, WORK( IPZW ), IZW, JZW, DESCZW )

         CALL PDLACPY( 'FULL', M, N, WORK( IPZW ), IZW, JZW, DESCZW,
     $                 Z, IZ2, JZ2, DESCZ )
      END IF

      IF ( WANTT ) THEN
*
*     Update the off-diagonal blocks.
*
         IPAW = 1
         IF ( ILO .NE. 1 ) THEN
*
*        A12 = A12 * Q
*
            IA2 = IA
            JA2 = JA + ILO - 1
            IROFF = MOD( IA2 - 1, DESCA( MB_ ) )
            ICOFF = MOD( JA2 - 1, DESCA( NB_ ) )
            IAW = IROFF + 1
            JAW = ICOFF + 1
            IROW = INDXG2P( IA2, DESCA( MB_ ), MYROW,
     $                      DESCA( RSRC_ ), NPROW )
            ICOL = INDXG2P( JA2, DESCA( NB_ ), MYCOL,
     $                      DESCA( CSRC_ ), NPCOL )
            MROWS = ILO - 1
            IF ( MROWS .LT. N ) THEN
               M2 = N
            ELSE
               M2 = MROWS
            END IF
            MP = NUMROC( M2 + IROFF, DESCA( MB_ ), MYROW, 
     $                   IROW, NPROW )
            NQ = NUMROC( N + ICOFF, DESCA( NB_ ), MYCOL, ICOL, NPCOL )

            CALL DESCSET( DESCAW, M2 + IROFF, N + ICOFF, 
     $                    DESCA( MB_ ), DESCA( NB_ ), IROW, ICOL,
     $                    DESCA( CTXT_ ), MAX( 1, MP ) )
***
***         Debugging
***
            if (debug) then
               if (printit) call print_desc(DESCAW, 'A12     ')
               if (printit) call print_desc(DESCA,  'A       ')
               if (printit) call print_desc(DESCQ,  'SmallQ  ')
            end if

            CALL PDGEMM0( 'No trans', 'No trans', M2, N, N, ONE,
     $                    A, IA2, JA2, DESCA, Q, IQ, JQ, DESCQ,
     $                    ZERO, WORK( IPAW ), IAW, JAW, DESCAW )

            CALL PDLACPY( 'All', MROWS, N, WORK( IPAW ), IAW, JAW,
     $                    DESCAW, A, IA2, JA2, DESCA )
         END IF

	call BLACS_BARRIER( DESCA( CTXT_ ), 'All' )

         IF ( ( ILO + N - 1 ) .NE. M ) THEN
*
*           A23 = Q^t * A23
*
            NCOLS = M - ( ILO + N - 1 )
            IF ( NCOLS .LT. N ) THEN
               N2 = N
               EXTRACOLS = N - NCOLS
            ELSE
               N2 = NCOLS
               EXTRACOLS = 0
            END IF

            IA2 = IA + ILO - 1
            JA2 = JA + M - N2
            IROFF = MOD( IA2 - 1, DESCA( MB_ ) )
            ICOFF = MOD( JA2 - 1, DESCA( NB_ ) )
            IAW = IROFF + 1
            JAW = ICOFF + 1
            IROW = INDXG2P( IA2, DESCA( MB_ ), MYROW,
     $                      DESCA( RSRC_ ), NPROW )
            ICOL = INDXG2P( JA2, DESCA( NB_ ), MYCOL,
     $                      DESCA( CSRC_ ), NPCOL )
            MP = NUMROC( N + IROFF, DESCA( MB_ ), MYROW,
     $                   IROW, NPROW )
            NQ = NUMROC( N2 + ICOFF, DESCA( NB_ ), MYCOL, 
     $                   ICOL, NPCOL )
            CALL DESCSET( DESCAW, N + IROFF, N2 + ICOFF,
     $                    DESCA( MB_ ), DESCA( NB_ ), IROW, ICOL,
     $                    DESCA( CTXT_ ), MAX( 1, MP ) )

            CALL PDGEMM0( 'No Trans', 'No trans', N, N2, N, ONE,
     $                    QT, IQ, JQ, DESCQ, A, IA2, JA2, DESCA,
     $                    ZERO, WORK( IPAW ), IAW, JAW, DESCAW )

            CALL PDLACPY( 'All', N, NCOLS, WORK( IPAW ), 
     $                    IAW, JAW + EXTRACOLS,
     $                    DESCAW, A, IA2, JA2 + EXTRACOLS, DESCA )

         END IF

      END IF

*
*     End of PDSDCUPD2
*
	RETURN
	END
