      SUBROUTINE PDLAPIV0( DIREC, ROWCOL, PIVROC, M, N, A, IA, JA,
     $                     DESCA, IPIV, IP, JP, DESCIP, IWORK )
*
*     .. Scalar Arguments ..
      CHARACTER*1        DIREC, PIVROC, ROWCOL
      INTEGER            IA, IP, JA, JP, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCIP( * ), IPIV( * ), IWORK( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     ..
*     .. Local Scalars ..
      LOGICAL            ROWPVT
      INTEGER            I, ICTXT, ICURCOL, ICURROW, IIP, ITMP, IPT,
     $                   JJP, JPT, MYCOL, MYROW, NPCOL, NPROW
*     ..
*     .. Local Arrays ..
      INTEGER            DESCPT( DLEN_ )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, IGEBR2D, IGEBS2D,
     $                   INFOG2L, PDLAPV2, PDLAPV20, PICOL2ROW,
     $                   PIROW2COL
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            NUMROC, INDXG2P
      EXTERNAL           LSAME, NUMROC, INDXG2P
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
      ROWPVT = LSAME( ROWCOL, 'R' )
*
*     If we're pivoting the rows of sub( A )
*
      IF( ROWPVT ) THEN
         IF( M.LE.1 .OR. N.LT.1 )
     $      RETURN
*
*        If the pivot vector is already distributed correctly
*
         IF( LSAME( PIVROC, 'C' ) ) THEN
            CALL PDLAPV20( DIREC, ROWCOL, M, N, A, IA, JA, DESCA, IPIV,
     $                     IP, JP, DESCIP )
*
*        Otherwise, we must redistribute IPIV to match PDLAPV2
*
         ELSE
*
*           Take IPIV distributed over row 0, and store it in
*           iwork, distributed over column 0
*
            IPT = MOD( JP-1, DESCIP( NB_ ) )
            DESCPT( DT_ ) = BLOCK_CYCLIC_2D
            DESCPT( M_ ) = N + IPT + NPROW*DESCIP( NB_ )
            DESCPT( N_ ) = 1
            DESCPT( MB_ ) = DESCIP( NB_ )
            DESCPT( NB_ ) = 1
            DESCPT( RSRC_ ) = INDXG2P( IA, DESCA( MB_ ), IA, 
     $                                 DESCA( RSRC_ ), NPROW )
            DESCPT( CSRC_ ) = MYCOL
            DESCPT( CTXT_ ) = ICTXT
            DESCPT( LLD_ ) = NUMROC( DESCPT( M_ ), DESCPT( MB_ ), 
     $                               MYROW, DESCPT( RSRC_ ), NPROW )
            ITMP = NUMROC( DESCIP( N_ ), DESCIP( NB_ ), MYCOL, 
     $                     DESCIP( CSRC_ ), NPCOL )
            CALL INFOG2L( IP, JP-IPT, DESCIP, NPROW, NPCOL, MYROW,
     $                    MYCOL, IIP, JJP, ICURROW, ICURCOL )
            CALL PIROW2COL( ICTXT, N+IPT, 1, DESCIP( NB_ ), 
     $                      IPIV(JJP), ITMP, IWORK, DESCPT( LLD_ ),
     $                      0, ICURCOL, DESCPT( RSRC_ ), MYCOL,
     $                      IWORK(DESCPT( LLD_ )-DESCPT( MB_ )+1) )
*
*           Send column-distributed pivots to all columns
*
            ITMP = DESCPT( LLD_ ) - DESCPT( MB_ )
            IF( MYCOL.EQ.0 ) THEN
               CALL IGEBS2D( ICTXT, 'Row', ' ', ITMP, 1, IWORK, ITMP )
            ELSE
               CALL IGEBR2D( ICTXT, 'Row', ' ', ITMP, 1, IWORK, ITMP,
     $                       MYROW, 0 )
            END IF
*
*           Adjust pivots so they are relative to the start of IWORK,
*           not IPIV
*
            IPT = IPT + 1
            DO 10 I = 1, ITMP
               IWORK(I) = IWORK(I) - JP + IPT
   10       CONTINUE
            CALL PDLAPV2( DIREC, ROWCOL, M, N, A, IA, JA, DESCA, IWORK,
     $                    IPT, 1, DESCPT )
         END IF
*
*     Otherwise, we're pivoting the columns of sub( A )
*
      ELSE
         IF( M.LT.1 .OR. N.LE.1 )
     $      RETURN
*
*        If the pivot vector is already distributed correctly
*
         IF( LSAME( PIVROC, 'R' ) ) THEN
            CALL PDLAPV2( DIREC, ROWCOL, M, N, A, IA, JA, DESCA, IPIV,
     $                    IP, JP, DESCIP )
*
*        Otherwise, we must redistribute IPIV to match PDLAPV2
*
         ELSE
*
*           Take IPIV distributed over column 0, and store it in
*           iwork, distributed over row 0
*
            JPT = MOD( IP-1, DESCIP( MB_ ) )
            DESCPT( DT_ ) = BLOCK_CYCLIC_2D
            DESCPT( M_ ) = 1
            DESCPT( N_ ) = M + JPT + NPCOL*DESCIP( MB_ )
            DESCPT( MB_ ) = 1
            DESCPT( NB_ ) = DESCIP( MB_ )
            DESCPT( RSRC_ ) = MYROW
            DESCPT( CSRC_ ) = INDXG2P( JA, DESCA( NB_ ), JA, 
     $                                 DESCA( CSRC_ ), NPCOL )
            DESCPT( CTXT_ ) = ICTXT
            DESCPT( LLD_ ) = 1
            CALL INFOG2L( IP-JPT, JP, DESCIP, NPROW, NPCOL, MYROW,
     $                    MYCOL, IIP, JJP, ICURROW, ICURCOL )
            ITMP = NUMROC( M+JPT, DESCPT( NB_ ), MYCOL, DESCPT( CSRC_ ),
     $                     NPCOL )
            CALL PICOL2ROW( ICTXT, M+JPT, 1, DESCIP( MB_ ), IPIV(IIP),
     $                      DESCIP( LLD_ ), IWORK, MAX(1, ITMP),
     $                      ICURROW, 0, 0, DESCPT( CSRC_ ), 
     $                      IWORK(ITMP+1) )
*
*           Send row-distributed pivots to all rows
*
            IF( MYROW.EQ.0 ) THEN
               CALL IGEBS2D( ICTXT, 'Column', ' ', ITMP, 1, IWORK,
     $                       ITMP )
            ELSE
               CALL IGEBR2D( ICTXT, 'Column', ' ', ITMP, 1, IWORK,
     $                       ITMP, 0, MYCOL )
            END IF
*
*           Adjust pivots so they are relative to the start of IWORK,
*           not IPIV
*
            JPT = JPT + 1
            DO 20 I = 1, ITMP
               IWORK(I) = IWORK(I) - IP + JPT
   20       CONTINUE
            CALL PDLAPV20( DIREC, ROWCOL, M, N, A, IA, JA, DESCA, IWORK,
     $                     1, JPT, DESCPT )
         END IF
      END IF
*
      RETURN
*
      END
