      SUBROUTINE PDLAFCHK0( AFORM, DIAG, M, N, A, IA, JA, DESCA, IASEED,
     $                      ANORM, FRESID, WORK )
*
*     .. Scalar Arguments ..
      CHARACTER          AFORM, DIAG
      INTEGER            IA, IASEED, JA, M, N
      DOUBLE PRECISION   ANORM, FRESID
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), WORK( * )
*     ..
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ONE
      PARAMETER          ( ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            IACOL, IAROW, ICOFF, ICTXT, IIA, IOFFA, IROFF,
     $                   JB, JJ, JJA, JN, MP, MYCOL, MYROW, NPCOL,
     $                   NPROW, NQ, MPW, NQW, IIW, JJW, LDW
      DOUBLE PRECISION   EPS
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DMATADD, INFOG2L, PDMATGEN
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, NUMROC
      DOUBLE PRECISION   PDLAMCH, PDLANGE
      EXTERNAL           ICEIL, NUMROC, PDLAMCH, PDLANGE
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
      EPS = PDLAMCH( ICTXT, 'eps' )
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
*
*     Compute sub( A ) := sub( A ) - sub( Ao )
*
      IROFF = MOD( IA-1, DESCA( MB_ ) )
      ICOFF = MOD( JA-1, DESCA( NB_ ) )
      MPW = NUMROC( M+IROFF, DESCA( MB_ ), MYROW, IAROW, NPROW )
      NQW = NUMROC( N+ICOFF, DESCA( NB_ ), MYCOL, IACOL, NPCOL )
      IF( MYROW.EQ.IAROW ) THEN
         MP = MPW - IROFF
         IIW = IIA - IROFF
      ELSE
         MP = MPW
         IIW = IIA
      END IF
      IF( MYCOL.EQ.IACOL ) THEN
         NQ = NQW - ICOFF
         JJW = JJA - ICOFF
      ELSE
         NQ = NQW
         JJW = JJA
      END IF
      LDW = MAX( 1, MPW )

      IOFFA = IIA + ( JJA - 1 ) * DESCA( LLD_ )
      JN = MIN( ICEIL( JA, DESCA( NB_ ) ) * DESCA( NB_ ), JA+N-1 )
*
*     Handle first block of columns separately
*
      IF( MYCOL.EQ.IACOL .AND. ICOFF.NE.0 ) THEN
         JB = JN-JA+1
         CALL PDMATGEN( ICTXT, AFORM, DIAG, DESCA( M_ ), DESCA( N_ ),
     $                  DESCA( MB_ ), DESCA( NB_ ), WORK, LDW,
     $                  DESCA( RSRC_ ), DESCA( CSRC_ ), 
     $                  IASEED, IIW-1, MPW,
     $                  JJW-1, JB+ICOFF, MYROW, MYCOL, NPROW, NPCOL )
         CALL DMATADD( MP, JB, -ONE, WORK(IROFF+1+ICOFF*LDW), LDW,
     $                 ONE, A( IOFFA ), DESCA( LLD_ ) )
         NQ  = NQ - JB
         JJA = JJA + JB
         IOFFA = IOFFA + JB * DESCA( LLD_ )
      END IF
*
*     Handle the remaning blocks of columns
*
      DO 10 JJ = JJA, JJA+NQ-1, DESCA( NB_ )
         JB = MIN( DESCA( NB_ ), JJA+NQ-JJ )
         IOFFA = IIA + ( JJ - 1 ) * DESCA( LLD_ )
         CALL PDMATGEN( ICTXT, AFORM, DIAG, DESCA( M_ ), DESCA( N_ ),
     $                  DESCA( MB_ ), DESCA( NB_ ), WORK, LDW,
     $                  DESCA( RSRC_ ), DESCA( CSRC_ ), IASEED, IIW-1,
     $                  MPW, JJ-1, JB, MYROW, MYCOL, NPROW, NPCOL )
         CALL DMATADD( MP, JB, -ONE, WORK(IROFF+1), LDW,
     $                 ONE, A( IOFFA ), DESCA( LLD_ ) )
   10 CONTINUE
*
*     Calculate factor residual
*
      FRESID = PDLANGE( 'I', M, N, A, IA, JA, DESCA, WORK ) /
     $                  ( MAX( M, N ) * EPS * ANORM )
*
      RETURN
*
      END
