      SUBROUTINE PDINVCHK0( MATTYP, N, A, IA, JA, DESCA, IASEED, ANORM,
     $                      FRESID, RCOND, WORK )
*
*     .. Scalar Arguments ..
      INTEGER            IA, IASEED, JA, N
      DOUBLE PRECISION   ANORM, FRESID, RCOND
*     ..
*     .. Array Arguments ..
      CHARACTER*3        MATTYP
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), WORK( * )
*     ..
*
* =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO,          ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER          AFORM, DIAG
      INTEGER            ICTXT, ICURCOL, ICURROW, II, IIA, IPW, IROFF,
     $                   IW, J, JB, JJA, JN, KK, MYCOL, MYROW,
     $                   NPCOL, NPROW, NPW, IIW, JJW, ICOFF,
     $                   IOFFW
      DOUBLE PRECISION   AUXNORM, EPS, NRMINVAXA, TEMP
*     ..
*     .. Local Arrays ..
      INTEGER            DESCW( DLEN_ )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, INFOG2L, PDGEMM0,
     $                   PDLASET, PDMATGEN
*     ..
*     .. External Functions ..
      LOGICAL            LSAMEN
      INTEGER            ICEIL, NUMROC
      DOUBLE PRECISION   PDLAMCH, PDLANGE
      EXTERNAL           ICEIL, LSAMEN, NUMROC, PDLAMCH, PDLANGE
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
      EPS = PDLAMCH( DESCA( CTXT_ ), 'eps' )
*
*     Get grid parameters
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Compute the condition number
*
      AFORM = 'N'
      DIAG = 'D'
      AUXNORM = PDLANGE( '1', N, N, A, IA, JA, DESCA, WORK )
      RCOND   = ANORM*AUXNORM
*
*     Compute inv(A)*A
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              ICURROW, ICURCOL )
*
*     Define array descriptor for working array WORK
*
      IROFF = MOD( IA-1, DESCA( MB_ ) )
      ICOFF = MOD( JA-1, DESCA( NB_ ) )
      NPW = NUMROC( N+IROFF, DESCA( MB_ ), MYROW, ICURROW, NPROW )
      CALL DESCSET( DESCW, N+IROFF, DESCA( NB_ ), DESCA( MB_ ), 
     $              DESCA( NB_ ),
     $              ICURROW, ICURCOL, DESCA( CTXT_ ), MAX( 1, NPW ) )
      IPW = DESCW( LLD_ ) * DESCW( NB_ ) + 1
*
      IF( MYROW.EQ.ICURROW ) THEN
         II = IROFF + 1
         IIW = IIA - IROFF
      ELSE
         II = 1
         IIW = IIA
      END IF
      IF( MYCOL.EQ.ICURCOL ) THEN
         JJW = JJA - ICOFF
      ELSE
         JJW = JJA
      END IF
*
      JN = MIN( ICEIL( JA, DESCA( NB_ ) ) * DESCA( NB_ ), JA+N-1 )
      JB = JN - JA + 1
*
*     Handle first block separately, regenerate a block of columns of A
*
      IW = IROFF + 1
      IF( MYCOL.EQ.ICURCOL ) THEN
         CALL PDMATGEN( ICTXT, AFORM, DIAG, DESCA( M_ ), DESCA( N_ ),
     $                  DESCW( MB_ ), DESCW( NB_ ), WORK( IPW ),
     $                  DESCW( LLD_ ), DESCA( RSRC_ ), DESCA( CSRC_ ),
     $                  IASEED, IIW-1, NPW, JJW-1, JB+ICOFF, MYROW,
     $                  MYCOL, NPROW, NPCOL )
      END IF
*
*     Multiply A^{-1}*A
*
      CALL PDGEMM0( 'No tranpose', 'No transpose', N, JB, N, ONE, A,
     $              IA, JA, DESCA, WORK( IPW ), IW, ICOFF+1, DESCW,
     $              ZERO, WORK, IW, ICOFF+1, DESCW )
*
*     subtract the identity matrix to the diagonal block of these cols.
*
      IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
         IOFFW = II + ICOFF*DESCW( LLD_ )
         DO 10 KK = 0, JB-1
            WORK( IOFFW+KK*(DESCW( LLD_ )+1) ) =
     $                 WORK( IOFFW+KK*(DESCW( LLD_ )+1) )-ONE
   10    CONTINUE
      END IF
*
      NRMINVAXA = PDLANGE( '1', N, JB, WORK, IW, ICOFF+1, DESCW,
     $                     WORK( IPW ) )
*
      IF( MYROW.EQ.ICURROW )
     $   II = II + JB
      IF( MYCOL.EQ.ICURCOL )
     $   JJA = JJA + JB
      ICURROW = MOD( ICURROW+1, NPROW )
      ICURCOL = MOD( ICURCOL+1, NPCOL )
      DESCW( CSRC_ ) = ICURCOL
*
      DO 30 J = JN+1, JA+N-1, DESCA( NB_ )
*
         JB = MIN( N-J+JA, DESCA( NB_ ) )
*
*        regenerate a block of columns of A
*
         IF( MYCOL.EQ.ICURCOL ) THEN
            CALL PDMATGEN( ICTXT, AFORM, DIAG, DESCA( M_ ),
     $                     DESCA( N_ ), DESCW( MB_ ), DESCW( NB_ ),
     $                     WORK( IPW ), DESCW( LLD_ ), DESCA( RSRC_ ),
     $                     DESCA( CSRC_ ), IASEED, IIW-1, NPW,
     $                     JJA-1, JB, MYROW, MYCOL, NPROW, NPCOL )
         END IF
*
*        Multiply A^{-1}*A
*
         CALL PDGEMM0( 'No tranpose', 'No transpose', N, JB, N, ONE,
     $                 A, IA, JA, DESCA, WORK( IPW ), IW, 1, DESCW,
     $                 ZERO, WORK, IW, 1, DESCW )
*
*        substract the identity matrix to the diagonal block of these cols.
*
         IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
            DO 20 KK = 0, JB-1
               WORK( II+KK*(DESCW( LLD_ )+1) ) =
     $                   WORK( II+KK*(DESCW( LLD_ )+1) ) - ONE
   20       CONTINUE
         END IF
*
*        Compute the 1-norm of these JB cols
*
         TEMP = PDLANGE( '1', N, JB, WORK, IW, 1, DESCW, WORK( IPW ) )
         NRMINVAXA = MAX( TEMP, NRMINVAXA )
*
         IF( MYROW.EQ.ICURROW )
     $      II = II + JB
         IF( MYCOL.EQ.ICURCOL )
     $      JJA = JJA + JB
         ICURROW = MOD( ICURROW+1, NPROW )
         ICURCOL = MOD( ICURCOL+1, NPCOL )
         DESCW( CSRC_ ) = ICURCOL
*
   30 CONTINUE
*
*     Compute the scaled residual
*
      FRESID = NRMINVAXA / ( N * EPS * ANORM )
*
      RETURN
*
      END
