      SUBROUTINE PDGETRRV0( M, N, A, IA, JA, DESCA, IPIV, WORK )
*
*     .. Scalar Arguments ..
      INTEGER            IA, JA, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), IPIV( * )
      DOUBLE PRECISION   A( * ), WORK( * )
*     ..
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER          COLBTOP, ROWBTOP
      INTEGER            IACOL, IAROW, ICTXT, IL, IPL, IPU, IROFF, J,
     $                   JB, JL, JN, MN, MP, MYCOL, MYROW, NPCOL, NPROW
*     .. Local Arrays ..
      INTEGER            DESCIP( DLEN_ ), DESCL( DLEN_ ),
     $                   DESCU( DLEN_ ), IDUM( 1 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, PDGEMM0, PDLACPY,
     $                   PDLAPIV0, PDLASET, PTOPGET, PTOPSET
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, INDXG2P, NUMROC
      EXTERNAL           ICEIL, INDXG2P, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters.
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      IROFF = MOD( IA-1, DESCA( MB_ ) )
      IAROW = INDXG2P( IA, DESCA( MB_ ), MYROW, DESCA( RSRC_ ), NPROW )
      MP = NUMROC( M+IROFF, DESCA( MB_ ), MYROW, IAROW, NPROW )
      IPL = 1
      IPU = IPL + MP * DESCA( NB_ )
      CALL PTOPGET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( ICTXT, 'Broadcast', 'Columnwise', COLBTOP )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', 'S-ring' )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', ' ' )
*
*     Define array descriptors for L and U
*
      MN = MIN( M, N )
      IL = MAX( ( ( IA+MN-2 ) / DESCA( MB_ ) ) * DESCA( MB_ ) + 1, IA )
      JL = MAX( ( ( JA+MN-2 ) / DESCA( NB_ ) ) * DESCA( NB_ ) + 1, JA )
      JN = MIN( ICEIL( JA, DESCA( NB_ ) )*DESCA( NB_ ), JA+MN-1 )
      IAROW = INDXG2P( IL, DESCA( MB_ ), MYROW, DESCA( RSRC_ ), NPROW )
      IACOL = INDXG2P( JL, DESCA( NB_ ), MYCOL, DESCA( CSRC_ ), NPCOL )
*
      CALL DESCSET( DESCL, IA+M-IL, DESCA( NB_ ), DESCA( MB_ ), 
     $              DESCA( NB_ ), IAROW, IACOL, ICTXT, MAX( 1, MP ) )
*
      CALL DESCSET( DESCU, DESCA( MB_ ), JA+N-JL, DESCA( MB_ ),
     $              DESCA( NB_ ), IAROW, IACOL, ICTXT, DESCA( MB_ ) )
*
      CALL DESCSET( DESCIP, DESCA( M_ ) + DESCA( MB_ )*NPROW, 1,
     $              DESCA( MB_ ), 1, DESCA( RSRC_ ), MYCOL, ICTXT,
     $              NUMROC( DESCA( M_ ), DESCA( MB_ ), MYROW,
     $                      DESCA( RSRC_ ), NPROW ) + DESCA( MB_ ) )
*
      DO 10 J = JL, JN+1, -DESCA( NB_ )
*
         JB = MIN( JA+MN-J, DESCA( NB_ ) )
*
*        Copy unit lower triangular part of sub( A ) into WORK
*
         CALL PDLACPY( 'Lower', M-IL+IA, JB, A, IL, J, DESCA,
     $                 WORK( IPL ), 1, 1, DESCL )
         CALL PDLASET( 'Upper', M-IL+IA, JB, ZERO, ONE, WORK( IPL ),
     $                 1, 1, DESCL )
*
*        Copy upper triangular part of sub( A ) into WORK(IPU)
*
         CALL PDLACPY( 'Upper', JB, JA+N-J, A, IL, J, DESCA,
     $                 WORK( IPU ), 1, 1, DESCU )
         CALL PDLASET( 'Lower', JB-1, JA+N-J, ZERO, ZERO,
     $                 WORK( IPU ), 2, 1, DESCU )
*
*        Zero the strict lower triangular piece of the current block.
*
         CALL PDLASET( 'Lower', IA+M-IL-1, JB, ZERO, ZERO, A, IL+1, J,
     $                 DESCA )
*
*        Zero the upper triangular piece of the current block.
*
         CALL PDLASET( 'Upper', JB, JA+N-J, ZERO, ZERO, A, IL, J,
     $                 DESCA )
*
*        Update the matrix sub( A ).
*
         CALL PDGEMM0( 'No transpose', 'No transpose', IA+M-IL,
     $                 JA+N-J, JB, ONE, WORK( IPL ), 1, 1, DESCL,
     $                 WORK( IPU ), 1, 1, DESCU, ONE, A, IL, J, DESCA )
*
         IL = IL - DESCA( MB_ )
         DESCL( M_ ) = DESCL( M_ ) + DESCL( MB_ )
         DESCL( RSRC_ ) = MOD( DESCL( RSRC_ ) + NPROW - 1, NPROW )
         DESCL( CSRC_ ) = MOD( DESCL( CSRC_ ) + NPCOL - 1, NPCOL )
         DESCU( N_ ) = DESCU( N_ ) + DESCU( NB_ )
         DESCU( RSRC_ ) = DESCL( RSRC_ )
         DESCU( CSRC_ ) = DESCL( CSRC_ )
*
   10 CONTINUE
*
*     Handle first block separately
*
      JB = MIN( JN-JA+1, DESCA( NB_ ) )
*
*     Copy unit lower triangular part of sub( A ) into WORK
*
      CALL PDLACPY( 'Lower', M, JB, A, IA, JA, DESCA, WORK( IPL ),
     $              1, 1, DESCL )
      CALL PDLASET( 'Upper', M, JB, ZERO, ONE, WORK( IPL ), 1, 1,
     $              DESCL )
*
*     Copy upper triangular part of sub( A ) into WORK(IPU)
*
      CALL PDLACPY( 'Upper', JB, N, A, IA, JA, DESCA, WORK( IPU ), 1,
     $              1, DESCU )
      CALL PDLASET( 'Lower', JB-1, N, ZERO, ZERO, WORK( IPU ), 2, 1,
     $              DESCU )
*
*     Zero the strict lower triangular piece of the current block.
*
      CALL PDLASET( 'Lower', M-1, JB, ZERO, ZERO, A, IA+1, JA, DESCA )
*
*     Zero the upper triangular piece of the current block.
*
      CALL PDLASET( 'Upper', JB, N, ZERO, ZERO, A, IA, JA, DESCA )
*
*     Update the matrix sub( A ).
*
      CALL PDGEMM0( 'No transpose', 'No transpose', M, N, JB, ONE,
     $              WORK( IPL ), 1, 1, DESCL, WORK( IPU ), 1, 1,
     $              DESCU, ONE, A, IA, JA, DESCA )
*
*     Apply pivots so that sub( A ) = P*L*U
*
      CALL PDLAPIV0( 'Backward', 'Row', 'Col', MIN( M, N ), N, A, IA,
     $               JA, DESCA, IPIV, IA, 1, DESCIP, IDUM )
*
      CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', COLBTOP )
*
      RETURN
*
*     End of PDGETRRV
*
      END
