      SUBROUTINE PDGETRI0( N, A, IA, JA, DESCA, IPIV, WORK, LWORK,
     $                     IWORK, LIWORK, INFO )
*
*     .. Scalar Arguments ..
      INTEGER            IA, INFO, JA, LIWORK, LWORK, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), IPIV( * ), IWORK( * )
      DOUBLE PRECISION   A( * ), WORK( * )
*     ..
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO, ONE
      PARAMETER          ( ZERO = 0.0D+0, ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IACOL, IAROW, ICOFF, ICTXT, IROFF, IW, J,
     $                   JB, JN, LCM, LIWMIN, LWMIN, MP, MYCOL, MYROW,
     $                   NN, NP, NPCOL, NPROW, NQ
*     ..
*     .. Local Arrays ..
      INTEGER            DESCW( DLEN_ ), IDUM1( 1 ), IDUM2( 1 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CHK1MAT, DESCSET, PCHK1MAT,
     $                   PDGEMM0, PDLACPY, PDLASET, PDLAPIV0,
     $                   PDTRSM0, PDTRTRI0, PXERBLA
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, ILCM, INDXG2P, NUMROC
      EXTERNAL           ICEIL, ILCM, INDXG2P, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -507
      ELSE
         CALL CHK1MAT( N, 1, N, 1, IA, JA, DESCA, 5, INFO )
         IF( INFO.EQ.0 ) THEN
            IROFF = MOD( IA-1, DESCA( MB_ ) )
            ICOFF = MOD( JA-1, DESCA( NB_ ) )
            IAROW = INDXG2P( IA, DESCA( MB_ ), MYROW, DESCA( RSRC_ ), 
     $                       NPROW )
            NP = NUMROC( N+IROFF, DESCA( MB_ ), MYROW, IAROW, NPROW )
            LWMIN = NP * DESCA( NB_ )
*
            MP = NUMROC( DESCA( M_ ), DESCA( MB_ ), MYROW,
     $                   DESCA( RSRC_ ), NPROW )
            NQ = NUMROC( DESCA( N_ ), DESCA( NB_ ), MYCOL,
     $                   DESCA( CSRC_ ), NPCOL )
            IF( NPROW.EQ.NPCOL ) THEN
               LIWMIN = NQ + DESCA( NB_ )
            ELSE
               LCM = ILCM( NPROW, NPCOL )
               LIWMIN = NQ + MAX( ICEIL( ICEIL( MP, DESCA( MB_ ) ),
     $                            LCM / NPROW ), DESCA( NB_ ) )
            END IF
*
            WORK( 1 ) = DBLE( LWMIN )
            IWORK( 1 ) = LIWMIN
C           IF( IROFF.NE.ICOFF .OR. IROFF.NE.0 ) THEN
C              INFO = -4
            IF( IROFF.NE.ICOFF ) THEN
               INFO = -4
            ELSE IF( DESCA( MB_ ).NE.DESCA( NB_ ) ) THEN
               INFO = -504
            ELSE IF( LWORK.LT.LWMIN ) THEN
               INFO = -8
            ELSE IF( LIWORK.LT.LIWMIN ) THEN
               INFO = -10
            END IF
         END IF
         CALL PCHK1MAT( N, 1, N, 1, IA, JA, DESCA, 5, 0, IDUM1, IDUM2,
     $                  INFO )
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDGETRI0', INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
*     Form inv(U).  If INFO > 0 from PDTRTRI0, then U is singular,
*     and the inverse is not computed.
*
      CALL PDTRTRI0( 'Upper', 'Non-unit', N, A, IA, JA, DESCA, INFO )
      IF( INFO.GT.0 )
     $   RETURN
*
*     Define array descriptor for working array WORK
*
      JN = MIN( ICEIL( JA, DESCA( NB_ ) ) * DESCA( NB_ ), JA+N-1 )
      NN = ( ( JA+N-2 ) / DESCA( NB_ ) ) * DESCA( NB_ ) + 1
      IACOL = INDXG2P( NN, DESCA( NB_ ), MYCOL, DESCA( CSRC_ ), NPCOL )
      CALL DESCSET( DESCW, N+IROFF, DESCA( NB_ ), DESCA( MB_ ), 
     $              DESCA( NB_ ), IAROW, IACOL, ICTXT, MAX( 1, NP ) )
      IW = IROFF + 1
*
*     Solve the equation inv(A)*L=inv(U) for inv(A) using blocked code.
*
      DO 10 J = NN, JN+1, -DESCA( NB_ )
         JB = MIN( DESCA( NB_ ), JA+N-J )
         I = IA + J - JA
*
*        Copy current block column of L to WORK and replace with zeros.
*
         CALL PDLACPY( 'Lower', JA+N-1-J, JB, A, I+1, J, DESCA,
     $                 WORK, IW+J-JA+1, 1, DESCW )
         CALL PDLASET( 'Lower', JA+N-1-J, JB, ZERO, ZERO, A, I+1, J,
     $                 DESCA )
*
*        Compute current block column of inv(A).
*
         IF( J+JB.LE.JA+N-1 )
     $      CALL PDGEMM0( 'No transpose', 'No transpose', N, JB,
     $                    JA+N-J-JB, -ONE, A, IA, J+JB, DESCA, WORK,
     $                    IW+J+JB-JA, 1, DESCW, ONE, A, IA, J, DESCA )
         CALL PDTRSM0( 'Right', 'Lower', 'No transpose', 'Unit', N, JB,
     $                 ONE, WORK, IW+J-JA, 1, DESCW, A, IA, J, DESCA )
         DESCW( CSRC_ ) = MOD( DESCW( CSRC_ ) + NPCOL - 1, NPCOL )
*
   10 CONTINUE
*
*     Handle the last block of columns separately
*
      JB = JN-JA+1
*
*     Copy current block column of L to WORK and replace with zeros.
*
      CALL PDLACPY( 'Lower', N-1, JB, A, IA+1, JA, DESCA, WORK, IW+1,
     $              1, DESCW )
      CALL PDLASET( 'Lower', N-1, JB, ZERO, ZERO, A, IA+1, JA, DESCA )
*
*     Compute current block column of inv(A).
*
      IF( JA+JB.LE.JA+N-1 )
     $   CALL PDGEMM0( 'No transpose', 'No transpose', N, JB,
     $                 N-JB, -ONE, A, IA, JA+JB, DESCA, WORK, IW+JB, 1,
     $                 DESCW, ONE, A, IA, JA, DESCA )
      CALL PDTRSM0( 'Right', 'Lower', 'No transpose', 'Unit', N, JB,
     $              ONE, WORK, IW, 1, DESCW, A, IA, JA, DESCA )
*
*     Use the row pivots and apply them to the columns of the global
*     matrix.
*
      CALL DESCSET( DESCW, DESCA( M_ ) + DESCA( N_ )*NPROW, 1,
     $              DESCA( MB_ ), 1, DESCA( RSRC_ ), MYCOL, ICTXT, 
     $              MP+DESCA( MB_ ) )
      CALL PDLAPIV0( 'Backward', 'Columns', 'Column', N, N, A, IA,
     $               JA, DESCA, IPIV, IA, 1, DESCW, IWORK )
*
      WORK( 1 ) = DBLE( LWMIN )
      IWORK( 1 ) = LIWMIN
*
      RETURN
*
      END
