      SUBROUTINE PDGETF20( M, N, A, IA, JA, DESCA, IPIV, INFO )
*
*     .. Scalar Arguments ..
      INTEGER            IA, INFO, JA, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), IPIV( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER          ROWBTOP
      INTEGER            I, IACOL, IAROW, ICOFF, ICTXT, IIA, IROFF, J,
     $                   JJA, MN, MYCOL, MYROW, NPCOL, NPROW
      DOUBLE PRECISION   GMAX
*     ..
*     .. External Functions ..
      INTEGER            INDXG2P, NUMROC
      EXTERNAL           INDXG2P, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_GRIDINFO, CHK1MAT, IGEBR2D,
     $                   IGEBS2D, INFOG2L, PDAMAX, PDGER,
     $                   PDSCAL, PDSWAP, PTOPGET, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters.
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters.
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -607
      ELSE
         CALL CHK1MAT( M, 1, N, 2, IA, JA, DESCA, 6, INFO )
         IF( INFO.EQ.0 ) THEN
            IROFF = MOD( IA-1, DESCA( MB_ ) )
            ICOFF = MOD( JA-1, DESCA( NB_ ) )
            IF( N+ICOFF.GT.DESCA( NB_ ) ) THEN
               INFO = -2
C           ELSE IF( IROFF.NE.0 ) THEN
C              INFO = -4
C           ELSE IF( ICOFF.NE.0 ) THEN
C              INFO = -5
            ELSE IF( IROFF.NE.ICOFF ) THEN
               INFO = -5
            ELSE IF( DESCA( MB_ ).NE.DESCA( NB_ ) ) THEN
               INFO = -604
            END IF
         END IF
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDGETF2', -INFO )
         CALL BLACS_ABORT( ICTXT, 1 )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
      MN = MIN( M, N )
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
      CALL PTOPGET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
*
      IF( MYCOL.EQ.IACOL ) THEN
         DO 10 J = JA, JA+MN-1
            I = IA + J - JA
*
*           Find pivot and test for singularity.
*
            CALL PDAMAX( M-J+JA, GMAX, IPIV( IIA+J-JA ), A, I, J,
     $                   DESCA, 1 )
            IF( GMAX.NE.ZERO ) THEN
*
*              Apply the row interchanges to columns JA:JA+N-1
*
               CALL PDSWAP( N, A, I, JA, DESCA, DESCA( M_ ), A,
     $                      IPIV( IIA+J-JA ), JA, DESCA, DESCA( M_ ) )
*
*              Compute elements I+1:IA+M-1 of J-th column.
*
               IF( J-JA+1.LT.M )
     $            CALL PDSCAL( M-J+JA-1, ONE / GMAX, A, I+1, J,
     $                         DESCA, 1 )
            ELSE IF( INFO.EQ.0 ) THEN
               INFO = J - JA + 1
            END IF
*
*           Update trailing submatrix
*
            IF( J-JA+1.LT.MN ) THEN
               CALL PDGER( M-J+JA-1, N-J+JA-1, -ONE, A, I+1, J, DESCA,
     $                     1, A, I, J+1, DESCA, DESCA( M_ ), A, I+1,
     $                     J+1, DESCA )
            END IF
   10    CONTINUE
*
         CALL IGEBS2D( ICTXT, 'Rowwise', ROWBTOP, MN, 1, IPIV( IIA ),
     $                 MN )
*
      ELSE
*
         CALL IGEBR2D( ICTXT, 'Rowwise', ROWBTOP, MN, 1, IPIV( IIA ),
     $                 MN, MYROW, IACOL )
*
      END IF
*
      RETURN
*
*     End of PDGETF2
*
      END
