
      SUBROUTINE PDGERSH( JOB, N, A, IA, JA, DESCA, REALBD,
     $                    IMAGBD, WORK )
*
*     Computes Gershgorin bounds for the square input matrix denoted
*     by A(IA:IA+N-1, JA:JA+N-1) == sub( A )
*
*     Algorithm:
*        1. Copy sub( A ) to B
*        2. Set the diagonal of B to all zero
*        3. Compute the 1 and/or infinity norm of B
*

*     ..
*     .. Scalar Arguments ..
      CHARACTER          JOB
      INTEGER            IA, JA, N
      DOUBLE PRECISION   REALBD, IMAGBD
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), WORK( * )
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            NPROW, NPCOL, MYROW, MYCOL,
     $                   MB, NB, IROFF, ICOFF, IAROW,
     $                   IACOL, MP, NQ, IPB, IB, JB, IPW
      double precision dummy
*     ..
*     .. Local arrays ..
      INTEGER            DESCB( DLEN_ )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, PDLACPY, PDAJDIAG
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXG2P, NUMROC
      DOUBLE PRECISION   PDLANGE
      EXTERNAL           INDXG2P, NUMROC, PDLANGE, LSAME

      logical debug, printit
*
*     .. Executable Statements ..
*
*     Get process grid information
*
      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, 
     $                     MYROW, MYCOL)
*
*     Carve up workspace
*
      MB = DESCA( MB_ )
      NB = DESCA( NB_ )
      IROFF = MOD( IA - 1, MB )
      ICOFF = MOD( JA - 1, NB )
      IAROW = INDXG2P( IA, MB, MYROW, DESCA( RSRC_ ), NPROW )
      IACOL = INDXG2P( JA, NB, MYCOL, DESCA( CSRC_ ), NPCOL )
      MP = NUMROC( N + IROFF, MB, MYROW, IAROW, NPROW )
      NQ = NUMROC( N + ICOFF, NB, MYCOL, IACOL, NPCOL )
      IPB = 1
      IPW = IPB + MP * NQ
      IB = IROFF + 1
      JB = ICOFF + 1
      CALL DESCSET( DESCB, N + IROFF, N + ICOFF, MB, NB,
     $              IAROW, IACOL, DESCA( CTXT_ ), MAX( 1, MP ) )
*
*     Compute
*
      CALL PDLACPY( 'FULL', N, N, A, IA, JA, DESCA,
     $              WORK( IPB ), IB, JB, DESCB )
      CALL PDAJDIAG( 'SET', N, WORK( IPB ), IB, JB, DESCB, ZERO )
      IF ( LSAME( JOB, 'B' ) .OR. LSAME( JOB, 'R' ) )
     $    REALBD = PDLANGE( 'INF', N, N, WORK( IPB ), IB, JB, DESCB, 
     $                      WORK( IPW ) )
      IF ( LSAME( JOB, 'B' ) .OR. LSAME( JOB, 'I' ) )
     $    IMAGBD = PDLANGE( '1', N, N, WORK( IPB ), IB, JB, DESCB, 
     $                      WORK( IPW ) )
*
      RETURN
      END
