      SUBROUTINE PDGEQRRV0( M, N, A, IA, JA, DESCA, TAU, WORK )
*
*     .. Scalar Arguments ..
      INTEGER            IA, JA, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), TAU( * ), WORK( * )
*     ..
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER          COLBTOP, ROWBTOP
      INTEGER            IACOL, IAROW, I, ICTXT, IIA, IPT, IPV, IPW,
     $                   IROFF, IV, J, JB, JJA, JL, JN, K, MP, MYCOL,
     $                   MYROW, NPCOL, NPROW
*     ..
*     .. Local Arrays ..
      INTEGER            DESCV( DLEN_ )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, INFOG2L, PDLACPY,
     $                   PDLARFB, PDLARFT, PDLASET, PTOPGET,
     $                   PTOPSET
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, INDXG2P, NUMROC
      EXTERNAL           ICEIL, INDXG2P, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      IROFF = MOD( IA-1, DESCA( MB_ ) )
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
      MP = NUMROC( M+IROFF, DESCA( MB_ ), MYROW, IAROW, NPROW )
      IPV = 1
      IPT = IPV + MP * DESCA( NB_ )
      IPW = IPT + DESCA( NB_ ) * DESCA( NB_ )
      CALL PTOPGET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( ICTXT, 'Broadcast', 'Columnwise', COLBTOP )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', 'D-ring' )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', ' ' )
*
      K  = MIN( M, N )
      JN = MIN( ICEIL( JA, DESCA( NB_ ) ) * DESCA( NB_ ), JA+K-1 )
      JL = MAX( ( (JA+K-2) / DESCA( NB_ ) ) * DESCA( NB_ ) + 1, JA )
*
      CALL DESCSET( DESCV, M+IROFF, DESCA( NB_ ), DESCA( MB_ ),
     $              DESCA( NB_ ), IAROW, INDXG2P( JL, DESCA( NB_ ), 
     $              MYCOL, DESCA( CSRC_ ),
     $              NPCOL ), ICTXT, MAX( 1, MP ) )
*
      DO 10 J = JL, JN+1, -DESCA( NB_ )
         JB = MIN( JA+K-J, DESCA( NB_ ) )
         I  = IA + J - JA
         IV = 1  + J - JA + IROFF
*
*        Compute upper triangular matrix T
*
         CALL PDLARFT( 'Forward', 'Columnwise', M-I+IA, JB, A, I, J,
     $                 DESCA, TAU, WORK( IPT ), WORK( IPW ) )
*
*        Copy Householder vectors into workspace
*
         CALL PDLACPY( 'Lower', M-I+IA, JB, A, I, J, DESCA, WORK( IPV ),
     $                 IV, 1, DESCV )
         CALL PDLASET( 'Upper', M-I+IA, JB, ZERO, ONE, WORK( IPV ), IV,
     $                 1, DESCV )
*
*        Zeroes the strict lower triangular part of sub( A ) to get
*        block column of R
*
         CALL PDLASET( 'Lower', M-I+IA-1, JB, ZERO, ZERO, A, I+1, J,
     $                 DESCA )
*
*        Apply block Householder transformation
*
         CALL PDLARFB( 'Left', 'No transpose', 'Forward', 'Columnwise',
     $                 M-I+IA, N-J+JA, JB, WORK( IPV ), IV, 1, DESCV,
     $                 WORK( IPT ), A, I, J, DESCA, WORK( IPW ) )
*
         DESCV( CSRC_ ) = MOD( DESCV( CSRC_ ) + NPCOL - 1, NPCOL )
*
   10 CONTINUE
*
*     Handle first block separately
*
      JB = JN - JA + 1
*
*     Compute upper triangular matrix T
*
      CALL PDLARFT( 'Forward', 'Columnwise', M, JB, A, IA, JA, DESCA,
     $              TAU, WORK( IPT ), WORK( IPW ) )
*
*     Copy Householder vectors into workspace
*
      CALL PDLACPY( 'Lower', M, JB, A, IA, JA, DESCA, WORK( IPV ),
     $              IROFF+1, 1, DESCV )
      CALL PDLASET( 'Upper', M, JB, ZERO, ONE, WORK, IROFF+1, 1, DESCV )
*
*     Zeroes the strict lower triangular part of sub( A ) to get block
*     column of R
*
      CALL PDLASET( 'Lower', M-1, JB, ZERO, ZERO, A, IA+1, JA, DESCA )
*
*     Apply block Householder transformation
*
      CALL PDLARFB( 'Left', 'No transpose', 'Forward', 'Columnwise', M,
     $              N, JB, WORK( IPV ), IROFF+1, 1, DESCV, WORK( IPT ),
     $              A, IA, JA, DESCA, WORK( IPW ) )
*
      CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', COLBTOP )
*
      RETURN
*
*     End of PDGEQRRV
*
      END
