#include "pblas0.h"

void pdgemm0_( transa, transb, m, n, k, alpha, A, ia, ja, desc_A,
               B, ib, jb, desc_B, beta, C, ic, jc, desc_C )
/*
*  .. Scalar Arguments ..
*/
   F_CHAR      transa, transb;
   int         * ia, * ib, * ic, * ja, * jb, * jc, * k, * m, * n;
   double      * alpha, * beta;
/* ..
*  .. Array Arguments ..
*/
   int         desc_A[], desc_B[], desc_C[];
   double      A[], B[], C[];
{
/*
*  .. Local Scalars ..
*/
   char        * ctop, * rtop, matpos, TrA, TrB;
   int         ablkcol, ablkrow, bblkrow, cblkcol, cblkrow, i, iacol,
               iarow, ibcol, iblk, ibrow, iccol, icoffa, icoffb, icoffc,
               icrow, ictxt, iia, iib, iic, in, info, iroffa, iroffb,
               iroffc, j, jblk, jja, jjb, jjc, jn, kb, kp0, kq0, lcm,
               lcmp, lcmq, mp0, mycol, myrow, nca, ncb, ncc, nota, notb,
               nprow, npcol, nq0, nra, nrb, nrc, tmp0, tmp1, tmp2, tmp3,
               tmp4, wksz;
   double      tbeta;
/* ..
*  .. PBLAS Buffer ..
*/
   double          * buff;
/* ..
*  .. External Functions ..
*/
   void        blacs_gridinfo_();
   void        pberror_();
   void        pbchkmat();
   char        * getpbbuf();
   char        * ptop();
   void        dgebs2d_();
   void        dgebr2d_();
   void        dgsum2d_();
   F_INTG_FCT  numroc_();
   F_VOID_FCT  dlaset_();
   F_VOID_FCT  dlacpy_();
   F_VOID_FCT  dgemm_();
   F_VOID_FCT  pbdgemm_();
   F_INTG_FCT  ilcm_();
/* ..
*  .. Executable Statements ..
*
*  Get grid parameters
*/
   ictxt = desc_A[CTXT_];
   blacs_gridinfo_( &ictxt, &nprow, &npcol, &myrow, &mycol );

#if( _MACH_ == _T3D_ )
   blacs_pack( _cptofcd( YES, 1 ) );
#endif
/*
*  Test the input parameters
*/
   info = 0;
   if( nprow == -1 )
      info = -1007;
   else
   {
      TrA = Mupcase( F2C_CHAR( transa )[0] );
      nota = ( TrA == 'N' );
      TrB = Mupcase( F2C_CHAR( transb )[0] );
      notb = ( TrB == 'N' );
      iroffa = (*ia-1) % desc_A[MB_];
      icoffa = (*ja-1) % desc_A[NB_];
      iroffb = (*ib-1) % desc_B[MB_];
      icoffb = (*jb-1) % desc_B[NB_];
      iroffc = (*ic-1) % desc_C[MB_];
      icoffc = (*jc-1) % desc_C[NB_];
      if( nota )
      {
         kb = desc_A[NB_];
         ablkrow = ( (*m) + iroffa <= desc_A[MB_] );
         ablkcol = ( (*k) + icoffa <= desc_A[NB_] );
         pbchkmat( *m, 3, *k, 5, *ia, *ja, desc_A, 10, &iia, &jja,
                   &iarow, &iacol, nprow, npcol, myrow, mycol,
                   &nra, &nca, &info );
      }
      else
      {
         kb = desc_A[MB_];
         ablkrow = ( (*k) + iroffa <= desc_A[MB_] );
         ablkcol = ( (*m) + icoffa <= desc_A[NB_] );
         pbchkmat( *k, 5, *m, 3, *ia, *ja, desc_A, 10, &iia, &jja,
                   &iarow, &iacol, nprow, npcol, myrow, mycol,
                   &nra, &nca, &info );
      }
      if( notb )
      {
         bblkrow = ( (*k) + iroffb <= desc_B[MB_] );
         pbchkmat( *k, 5, *n, 4, *ib, *jb, desc_B, 14, &iib, &jjb,
                   &ibrow, &ibcol, nprow, npcol, myrow, mycol,
                   &nrb, &ncb, &info );
      }
      else
      {
         bblkrow = ( (*n) + iroffb <= desc_B[MB_] );
         pbchkmat( *n, 4, *k, 5, *ib, *jb, desc_B, 14, &iib, &jjb,
                   &ibrow, &ibcol, nprow, npcol, myrow, mycol,
                   &nrb, &ncb, &info );
      }
      cblkrow = ( (*m) + iroffc <= desc_C[MB_] );
      cblkcol = ( (*n) + icoffc <= desc_C[NB_] );
      pbchkmat( *m, 3, *n, 4, *ic, *jc, desc_C, 19, &iic, &jjc,
                &icrow, &iccol, nprow, npcol, myrow, mycol,
                &nrc, &ncc, &info );
      if( info == 0 )
      {
         if( ( (*k) <= (*n) ) && ( (*k) <= (*m) ) )
         {
            matpos = 'C';
            if( nota && notb )
            {
               tmp0 = ( iroffa || icoffb );
#if 0
               if( iroffc || icoffc || tmp0 ||
                   ( !tmp0 && !ablkcol && icoffa != iroffb ) )
               {
                  fprintf( stderr, "if 1\n" );
                  if( iroffa )
                     info = -8;
                  else if( icoffb )
                     info = -13;
                  else if( iroffc )
                     info = -17;
                  else if( icoffc )
                     info = -18;
                  else
                     info = -12;
                  matpos = 'A';
                  tmp0 = ( iroffb || iroffc );
                  if( iroffa || icoffa || tmp0 ||
                      ( !tmp0 && !cblkcol && icoffb != icoffc ) )
                  {
                     fprintf( stderr, "if 2\n" );
                     if( iroffa )
                        info = -8;
                     else if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else
                        info = -18;
                     matpos = 'B';
                     if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( icoffb )
                        info = -13;
                     else if( icoffc )
                        info = -18;
                     else if( !icoffa && !icoffc && !cblkrow &&
                              iroffa != iroffc )
                        info = -17;
                     else
                        info = 0;
                  }
                  else
                  {
                     fprintf( stderr, "else 2\n" );
                     info = 0;
                  }
               }
#endif
            }
            else if( !nota && notb )
            {
               tmp0 = ( icoffa || icoffb );
               if( iroffc || icoffc || tmp0 ||
                   ( !tmp0 && !bblkrow && iroffa != iroffb ) )
               {
                  if( icoffa )
                     info = -9;
                  else if( icoffb )
                     info = -13;
                  else if( iroffc )
                     info = -17;
                  else if( icoffc )
                     info = -18;
                  else
                     info = -12;
                  matpos = 'A';
                  tmp0 = ( iroffb || iroffc );
                  if( iroffa || icoffa || tmp0 ||
                      ( !tmp0 && !cblkcol && icoffb != icoffc ) )
                  {
                     if( iroffa )
                        info = -8;
                     else if( iroffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else
                        info = -18;
                     matpos = 'B';
                     if( iroffa )
                        info = -8;
                     else if( iroffb )
                        info = -12;
                     else if( iroffb )
                        info = -13;
                     else if( icoffc )
                        info = -18;
                     else if( !iroffa && !icoffc && !cblkrow &&
                              icoffa != iroffc )
                        info = -17;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
            else if( nota && !notb )
            {
               tmp0 = ( iroffa || iroffb );
               if( iroffc || icoffc || tmp0 ||
                   ( !tmp0 && !ablkcol && icoffa != icoffb ) )
               {
                  if( iroffa )
                     info = -8;
                  else if( iroffb )
                     info = -12;
                  else if( iroffc )
                     info = -17;
                  else if( icoffc )
                     info = -18;
                  else
                     info = -13;
                  matpos = 'A';
                  tmp0 = ( icoffb || iroffc );
                  if( iroffa || icoffa || tmp0 ||
                      ( !tmp0 && !cblkcol && iroffb != icoffc ) )
                  {
                     if( iroffa )
                        info = -8;
                     else if( icoffa )
                        info = -9;
                     else if( icoffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else
                        info = -18;
                     matpos = 'B';
                     if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( iroffb )
                        info = -13;
                     else if( icoffc )
                        info = -18;
                     else if( !icoffa && !icoffc && !cblkrow &&
                              iroffa != iroffc )
                        info = -17;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
            else if( !nota && !notb )
            {
               tmp0 = ( icoffa || iroffb );
               if( iroffc || icoffc || tmp0 ||
                   ( !tmp0 && !ablkrow && iroffa != icoffb ) )
               {
                  if( icoffa )
                     info = -9;
                  else if( iroffb )
                     info = -12;
                  else if( iroffc )
                     info = -17;
                  else if( icoffc )
                     info = -18;
                  else
                     info = -13;
                  matpos = 'A';
                  tmp0 = ( icoffb || iroffc );
                  if( iroffa || icoffa || tmp0 ||
                      ( !tmp0 && !cblkcol && iroffb != icoffc ) )
                  {
                     if( iroffa )
                        info = -8;
                     else if( icoffa )
                        info = -9;
                     else if( icoffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else
                        info = -18;
                     matpos = 'B';
                     if( iroffa )
                        info = -8;
                     else if( iroffb )
                        info = -12;
                     else if( iroffb )
                        info = -13;
                     else if( icoffc )
                        info = -18;
                     else if( !iroffa && !icoffc && !cblkrow &&
                              icoffa != iroffc )
                        info = -17;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
            if( info )
               fprintf( stderr, "info = %d\n", info );
         }
         else if( ( (*n) <= (*m) ) && ( (*n) <= (*k) ) )
         {
            matpos = 'A';
            if( nota && notb )
            {
#if 0
               tmp0 = ( iroffb || iroffc );
               if( iroffa || icoffa || tmp0 ||
                   ( !tmp0 && !cblkcol && icoffb != icoffc ) )
               {
                  if( iroffa )
                     info = -8;
                  else if( icoffa )
                     info = -9;
                  else if( iroffb )
                     info = -12;
                  else if( iroffc )
                     info = -17;
                  else
                     info = -18;
                  matpos = 'B';
                  tmp0 = ( icoffa || icoffc );
                  if( iroffb || icoffb || tmp0 ||
                      ( !tmp0 && !cblkrow && iroffa != iroffc ) )
                  {
                     if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( icoffb )
                        info = -13;
                     else if( icoffc )
                        info = -18;
                     else
                        info = -17;
                     matpos = 'C';
                     if( iroffa )
                        info = -8;
                     else if( icoffb )
                        info = -13;
                     else if( !iroffa && !icoffb && !ablkcol &&
                              icoffa != iroffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else if( icoffc )
                        info = -18;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
#endif
            }
            else if( !nota && notb )
            {
               tmp0 = ( iroffb || iroffc );
               if( iroffa || icoffa || tmp0 ||
                   ( !tmp0 && !cblkcol && icoffb != icoffc ) )
               {
                  if( iroffa )
                     info = -8;
                  else if( icoffa )
                     info = -9;
                  else if( iroffb )
                     info = -12;
                  else if( iroffc )
                     info = -17;
                  else
                     info = -18;
                  matpos = 'B';
                  tmp0 = ( iroffa || icoffc );
                  if( iroffb || icoffb || tmp0 ||
                      ( !tmp0 && !cblkrow && icoffa != iroffc ) )
                  {
                     if( iroffa )
                        info = -8;
                     else if( iroffb )
                        info = -12;
                     else if( icoffb )
                        info = -13;
                     else if( icoffc )
                        info = -18;
                     else
                        info = -17;
                     matpos = 'C';
                     if( icoffa )
                        info = -9;
                     else if( icoffb )
                        info = -13;
                     else if( !icoffa && !icoffb && !bblkrow &&
                              iroffa != iroffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else if( icoffc )
                        info = -18;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
            else if( nota && !notb )
            {
               tmp0 = ( icoffb || iroffc );
               if( iroffa || icoffa || tmp0 ||
                   ( !tmp0 && !cblkcol && iroffb != icoffc ) )
               {
                  if( iroffa )
                     info = -8;
                  else if( icoffa )
                     info = -9;
                  else if( icoffb )
                     info = -12;
                  else if( iroffc )
                     info = -17;
                  else
                     info = -18;
                  matpos = 'B';
                  tmp0 = ( icoffa || icoffc );
                  if( iroffb || icoffb || tmp0 ||
                      ( !tmp0 && !cblkrow && iroffa != iroffc ) )
                  {
                     if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( icoffb )
                        info = -13;
                     else if( icoffc )
                        info = -18;
                     else
                        info = -17;
                     matpos = 'C';
                     if( iroffa )
                        info = -8;
                     else if( iroffb )
                        info = -12;
                     else if( !iroffa && !iroffb && !ablkcol &&
                              icoffa != icoffb )
                       info = -13;
                     else if( iroffc )
                        info = -17;
                     else if( icoffc )
                        info = -18;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
            else if( !nota && !notb )
            {
               tmp0 = ( icoffb || iroffc );
               if( iroffa || icoffa || tmp0 ||
                   ( !tmp0 && !cblkcol && iroffb != icoffc ) )
               {
                  if( iroffa )
                     info = -8;
                  else if( icoffa )
                     info = -9;
                  else if( icoffb )
                     info = -12;
                  else if( iroffc )
                     info = -17;
                  else
                     info = -18;
                  matpos = 'B';
                  tmp0 = ( iroffa || icoffc );
                  if( iroffb || icoffb || tmp0 ||
                      ( !tmp0 && !cblkrow && icoffa != iroffc ) )
                  {
                     if( iroffa )
                        info = -8;
                     else if( iroffb )
                        info = -12;
                     else if( icoffb )
                        info = -13;
                     else if( icoffc )
                        info = -18;
                     else
                        info = -17;
                     matpos = 'C';
                     if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( !icoffa && !iroffb && !ablkrow &&
                              iroffa != icoffb )
                        info = -13;
                     else if( iroffc )
                        info = -17;
                     else if( icoffc )
                        info = -18;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
         }
         else if( ( (*m) <= (*n) ) && ( (*m) <= (*k) ) )
         {
            matpos = 'B';
            if( nota && notb )
            {
               tmp0 = ( icoffa || icoffc );
               if( iroffb || icoffb || tmp0 ||
                   ( !tmp0 && !cblkrow && iroffa != iroffc ) )
               {
                  if( icoffa )
                     info = -9;
                  else if( iroffb )
                     info = -12;
                  else if( icoffb )
                     info = -13;
                  else if( icoffc )
                     info = -18;
                  else
                     info = -17;
                  matpos = 'C';
                  tmp0 = ( iroffa || icoffb );
                  if( iroffc || icoffc || tmp0 ||
                      ( !tmp0 && !ablkcol && icoffa != iroffb ) )
                  {
                     if( iroffa )
                        info = -8;
                     else if( icoffb )
                        info = -13;
                     else if( iroffc )
                        info = -17;
                     else if( icoffc )
                        info = -18;
                     else
                        info = -12;
                     matpos = 'A';
                     if( iroffa )
                        info = -8;
                     else if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else if( !iroffb && !iroffc && !cblkcol &&
                              icoffb != icoffc )
                        info = -18;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
            else if( !nota && notb )
            {
               tmp0 = ( iroffa || icoffc );
               if( iroffb || icoffb || tmp0 ||
                   ( !tmp0 && !cblkrow && icoffa != iroffc ) )
               {
                  if( iroffa )
                     info = -8;
                  else if( iroffb )
                     info = -12;
                  else if( icoffb )
                     info = -13;
                  else if( icoffc )
                     info = -18;
                  else
                     info = -17;
                  matpos = 'C';
                  tmp0 = ( icoffa || icoffb );
                  if( iroffc || icoffc || tmp0 ||
                      ( !tmp0 && !bblkrow && iroffa != iroffb ) )
                  {
                     if( icoffa )
                        info = -9;
                     else if( icoffb )
                        info = -13;
                     else if( iroffc )
                        info = -17;
                     else if( icoffc )
                        info = -18;
                     else
                        info = -12;
                     matpos = 'A';
                     if( iroffa )
                        info = -8;
                     else if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else if( !iroffb && !iroffc && !cblkcol &&
                              icoffb != icoffc )
                        info = -18;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
            else if( nota && !notb )
            {
               tmp0 = ( icoffa || icoffc );
               if( iroffb || icoffb || tmp0 ||
                   ( !tmp0 && !cblkrow && iroffa != iroffc ) )
               {
                  if( icoffa )
                     info = -9;
                  else if( iroffb )
                     info = -12;
                  else if( icoffb )
                     info = -13;
                  else if( icoffc )
                     info = -18;
                  else if( !icoffa && !icoffc && !cblkrow &&
                           iroffa != iroffc )
                     info = -17;
                  matpos = 'C';
                  tmp0 = ( iroffa || iroffb );
                  if( iroffc || icoffc || tmp0 ||
                      ( !tmp0 && !ablkcol && icoffa != icoffb ) )
                  {
                     if( iroffa )
                        info = -8;
                     else if( iroffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else if( icoffc )
                        info = -18;
                     else
                        info = -13;
                     matpos = 'A';
                     if( iroffa )
                        info = -8;
                     else if( icoffa )
                        info = -9;
                     else if( icoffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else if( !icoffb && !iroffc && !cblkcol &&
                              iroffb != icoffc )
                        info = -18;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
            else if( !nota && !notb )
            {
               tmp0 = ( iroffa || icoffc );
               if( iroffb || icoffb || tmp0 ||
                   ( !tmp0 && !cblkrow && icoffa != iroffc ) )
               {
                  if( iroffa )
                     info = -8;
                  else if( iroffb )
                     info = -12;
                  else if( icoffb )
                     info = -13;
                  else if( icoffc )
                     info = -18;
                  else
                     info = -17;
                  matpos = 'C';
                  tmp0 = ( icoffa || iroffb );
                  if( iroffc || icoffc || tmp0 ||
                      ( !tmp0 && !ablkrow && iroffa != icoffb ) )
                  {
                     if( icoffa )
                        info = -9;
                     else if( iroffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else if( icoffc )
                        info = -18;
                     else
                        info = -13;
                     matpos = 'A';
                     if( iroffa )
                        info = -8;
                     else if( icoffa )
                        info = -9;
                     else if( icoffb )
                        info = -12;
                     else if( iroffc )
                        info = -17;
                     else if( !icoffb && !iroffc && !cblkcol &&
                              iroffb != icoffc )
                        info = -18;
                     else
                        info = 0;
                  }
                  else
                  {
                     info = 0;
                  }
               }
            }
         }

         if( info == 0 )
         {
            if( (TrA != 'N') && (TrA != 'T') && (TrA != 'C') )
               info = -1;
            else if( (TrB != 'N') && (TrB != 'T') && (TrB != 'C') )
               info = -2;
            if( nota )
            {
               if( desc_A[MB_] != desc_C[MB_] )
                  info = -1903;
               if( notb )
               {
                  if( desc_A[NB_] != desc_B[MB_] )
                     info = -1403;
                  else if( desc_B[NB_] != desc_C[NB_] )
                     info = -1904;
               }
               else
               {
                  if( desc_A[NB_] != desc_B[NB_] )
                     info = -1404;
                  else if( desc_B[MB_] != desc_C[NB_] )
                     info = -1904;
               }
            }
            else
            {
               if( desc_A[NB_] != desc_C[MB_] )
                  info = -1903;
               if( notb )
               {
                  if( desc_A[MB_] != desc_B[MB_] )
                     info = -1403;
                  else if( desc_B[NB_] != desc_C[NB_] )
                     info = -1904;
               }
               else
               {
                  if( desc_A[MB_] != desc_B[NB_] )
                     info = -1404;
                  else if( desc_B[MB_] != desc_C[NB_] )
                     info = -1904;
               }
            }
            if( ictxt != desc_B[CTXT_] )
               info = -1407;
            else if( ictxt != desc_C[CTXT_] )
               info = -1907;
         }
      }
   }
   if( info )
   {
     pberror_( &ictxt, "PDGEMM", &info );
     return;
   }
/*
*  Quick return if possible.
*/
   if( ( *m == 0 ) || ( *n == 0 ) ||
       ( ( *alpha == ZERO || *k == 0 ) && ( *beta == ONE ) ) )
      return;
/*
*  Figure out the arguments to be passed to pbdgemm and compute
*  adequate workspace size
*/
   lcm = ilcm_( &nprow, &npcol );
   if( nota )
   {
      if( notb )
      {
         if( matpos == 'C' )
         {
            int mpc, nqc;
/*            tmp1 = (*m) / desc_C[MB_];
            tmp2 = (*n) / desc_C[NB_];
            wksz = ( MYROC0( tmp1, *m, desc_C[MB_], nprow ) +
                     MYROC0( tmp2, *n, desc_C[NB_], npcol ) ) * desc_A[NB_];
*/
            tmp1 = *m + iroffc;
            mpc = numroc_( &tmp1, &desc_C[MB_], &myrow, &icrow, &nprow );
            tmp2 = *n + icoffc;
            nqc = numroc_( &tmp2, &desc_C[NB_], &mycol, &iccol, &npcol );
            wksz = ( mpc + nqc ) * desc_A[NB_];

         }
         else if( matpos == 'A' )
         {
            lcmq = lcm / npcol;
            /* tmp1 = (*m) / desc_C[MB_];
            mp0 = MYROC0( tmp1, *m, desc_C[MB_], nprow ); */

            tmp1 = *m + iroffc;
            mp0 = numroc_( &tmp1, &desc_C[MB_], &myrow, &icrow, &nprow );


            tmp2 = (*k+icoffa) / kb;
            kq0 = MYROC0( tmp2, *k, kb, npcol );

            tmp2 = kq0 / kb;
            tmp1 = MYROC0( tmp2, kq0, kb, lcmq );
            wksz = desc_C[NB_] * ( kq0 + MAX( tmp1, mp0 ) );
         }
         else
         {
            lcmp = lcm / nprow;
            tmp1 = (*k) / kb;
            kp0 = MYROC0( tmp1, *k, kb, nprow );
            tmp2 = (*n) / desc_C[NB_];
            nq0 = MYROC0( tmp2, *n, desc_C[NB_], npcol );
            tmp2 = kp0 / kb;
            tmp1 = MYROC0( tmp2, kp0, kb, lcmp );
            wksz = desc_C[MB_] * ( kp0 + MAX( tmp1, nq0 ) );
         }
      }
      else
      {
         if( matpos == 'C' )
         {
            tmp0 = (*m) / desc_C[MB_];
            lcmq = lcm / npcol;
            tmp1 = (*n) / desc_C[NB_];
            nq0 = MYROC0( tmp1, *n, desc_C[NB_], npcol );
            tmp1 = nq0 / desc_C[NB_];
            wksz = ( MYROC0( tmp0, *m, desc_C[MB_], nprow ) +
                     nq0 + MYROC0( tmp1, nq0, desc_C[NB_], lcmq ) ) *
                     desc_A[NB_];
         }
         else if( matpos == 'A' )
         {
            tmp0 = (*m) / desc_C[MB_];
            tmp1 = (*k) / kb;
            wksz = ( MYROC0( tmp1, *k, kb, npcol ) +
                     MYROC0( tmp0, *m, desc_C[MB_], nprow ) ) * desc_C[NB_];
         }
         else
         {
            lcmq = lcm / npcol;
            tmp1 = (*n) / desc_C[NB_];
            nq0 = MYROC0( tmp1, *n, desc_C[NB_], npcol );
            tmp2 = (*k) / kb;
            kq0 = MYROC0( tmp2, *k, kb, npcol );
            tmp3 = nq0 / desc_C[NB_];
            tmp2 = MYROC0( tmp3, nq0, desc_C[NB_], lcmq );
            wksz = ( MYROC0( tmp1, *n, desc_C[NB_], nprow ) +
                     MAX( tmp2, kq0 ) ) * desc_C[MB_];
         }
      }
   }
   else
   {
      if( notb )
      {
         if( matpos == 'C' )
         {
            lcmp = lcm / nprow;
            tmp1 = (*m) / desc_C[MB_];
            mp0 = MYROC0( tmp1, *m, desc_C[MB_], nprow );
            tmp2 = (*n) / desc_C[NB_];
            nq0 = MYROC0( tmp2, *n, desc_C[NB_], npcol );
            tmp2 = mp0 / desc_C[MB_];
            tmp1 = MYROC0( tmp2, mp0, desc_C[MB_], lcmp );
            wksz = desc_B[MB_] * ( mp0 + MAX( tmp1, nq0 ) );
         }
         else if( matpos == 'A' )
         {
            lcmp = lcm / nprow;
            tmp1 = (*m) / desc_C[MB_];
            mp0 = MYROC0( tmp1, *m, desc_C[MB_], nprow );
            tmp2 = (*k) / kb;
            kp0 = MYROC0( tmp2, *k, kb, nprow );
            tmp3 = mp0 / desc_C[MB_];
            tmp2 = MYROC0( tmp3, mp0, desc_C[MB_], lcmp );
            wksz = ( MYROC0( tmp1, *m, desc_C[MB_], npcol ) +
                     MAX( tmp2, kp0 ) ) * desc_C[NB_];
         }
         else
         {
            tmp1 = (*k) / kb;
            tmp2 = (*n) / desc_C[NB_];
            wksz = ( MYROC0( tmp1, *k, kb, nprow ) +
                     MYROC0( tmp2, *n, desc_C[NB_], npcol ) ) * desc_C[MB_];
         }
      }
      else
      {
         if( matpos == 'C' )
         {
            lcmp = lcm / nprow;
            lcmq = lcm / npcol;
            tmp1 = (*m) / desc_C[MB_];
            mp0 = MYROC0( tmp1, *m, desc_C[MB_], nprow );
            tmp2 = (*n) / desc_C[NB_];
            nq0 = MYROC0( tmp2, *n, desc_C[NB_], npcol );
            tmp3 = mp0 / desc_C[MB_];
            tmp1 = MYROC0( tmp3, mp0, desc_C[MB_], lcmp );
            tmp3 = nq0 / desc_C[NB_];
            tmp2 = MYROC0( tmp3, nq0, desc_C[NB_], lcmq );
            wksz = desc_A[MB_] * ( mp0 + nq0 + MAX( tmp1, tmp2 ) );
         }
         else if( matpos == 'A' )
         {
            lcmp = lcm / nprow;
            tmp1 = (*m) / desc_C[MB_];
            mp0 = MYROC0( tmp1, *m, desc_C[MB_], nprow );
            tmp2 = (*k) / kb;
            kp0 = MYROC0( tmp2, *k, kb, nprow );
            tmp3 = mp0 / desc_C[MB_];
            tmp2 = MYROC0( tmp3, mp0, desc_C[MB_], lcmp );
            tmp4 = kp0 / kb;
            tmp3 = kp0 + MYROC0( tmp4, kp0, kb, lcmp );
            wksz = ( MYROC0( tmp1, *m, desc_C[MB_], npcol ) +
                     MAX( tmp2, tmp3 ) ) * desc_C[NB_];
         }
         else
         {
            lcmq = lcm / npcol;
            tmp1 = (*n) / desc_C[NB_];
            nq0 = MYROC0( tmp1, *n, desc_C[NB_], npcol );
            tmp2 = (*k) / kb;
            kq0 = MYROC0( tmp2, *k, kb, npcol );
            tmp3 = nq0 / desc_C[NB_];
            tmp2 = MYROC0( tmp3, nq0, desc_C[NB_], lcmq );
            tmp4 = kq0 / kb;
            tmp3 = kq0 + MYROC0( tmp4, kq0, kb, lcmq );
            wksz = ( MYROC0( tmp1, *n, desc_C[NB_], nprow ) +
                     MAX( tmp2, tmp3 ) ) * desc_C[MB_];
         }
      }
   }
   buff = (double *)getpbbuf( "PDGEMM", wksz*sizeof(double) );
/*
*  Call PB-BLAS routine
*/
   if( matpos == 'A' && cblkcol )
   {
      if( nota && notb )
      {
         int kqa, kq, mone=-1, tmp, mpc, ioffb;
         double zero=ZERO;

         tmp = *k+icoffa;
         kqa = numroc_( &tmp, &desc_A[NB_], &mycol, &iacol, &npcol );
         if( mycol == iacol )
            kq = kqa-icoffa;
         else
            kq = kqa;

         tmp = *m+iroffc;
         mpc = numroc_( &tmp, &desc_C[MB_], &myrow, &icrow, &nprow );
         if( myrow == icrow ) mpc -= iroffc;

         tmp = *k + iroffb;
         if( myrow == ibrow )
            ioffb = iib-iroffb-1+(jjb-1)*desc_B[LLD_];
         else
            ioffb = iib-1+(jjb-1)*desc_B[LLD_];
         pbdtran_( &ictxt, C2F_CHAR( "C" ), C2F_CHAR( "T" ), &tmp, n,
                   &desc_B[MB_], &B[ioffb], &desc_B[LLD_], &zero, buff,
                   n, &ibrow, &ibcol, &mone, &iacol, buff+(kqa**n) );
         if( mycol == iacol )
            ioffb = icoffa*(*n);
         else
            ioffb = 0;

         if( mycol == iccol )
         {
            dgemm_( C2F_CHAR( "N" ), C2F_CHAR( "T" ), &mpc, n, &kq,
                    alpha, &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                    buff+ioffb, n, beta, &C[iic-1+(jjc-1)*desc_C[LLD_]],
                    &desc_C[LLD_] );
            dgsum2d_( &ictxt, C2F_CHAR( "R" ), C2F_CHAR( " " ), &mpc, n,
                      &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                      &myrow, &iccol );
         }
         else
         {
            tmp = MAX( 1, mpc );
            dgemm_( C2F_CHAR( "N" ), C2F_CHAR( "T" ), &mpc, n, &kq,
                    alpha, &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                    buff+ioffb, n, &zero, buff+(kqa**n), &tmp );
            dgsum2d_( &ictxt, C2F_CHAR( "R" ), C2F_CHAR( " " ), &mpc, n,
                      buff+(kqa**n), &tmp, &myrow, &iccol );
         }
      }
      else if( nota && !notb )
      {
         ctop = ptop( BROADCAST, COLUMN, TOPGET );
         pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m, n, k,
                   &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                   &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                   &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                   C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                   C2F_CHAR( ctop ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                   buff );
      }
      else
      {
         pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m, n, k,
                   &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                   &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                   &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                   C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                   C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                   buff );
      }
   }
   else if( matpos == 'B' && cblkrow )
   {
      if( !nota && notb )
      {
         rtop = ptop( BROADCAST, ROW, TOPGET );
         pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m, n, k,
                   &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                   &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                   &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                   C2F_CHAR( "A" ), C2F_CHAR( rtop ), C2F_CHAR( NO ),
                   C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                   buff );
      }
      else
      {
         pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m, n, k,
                   &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                   &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                   &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                   C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                   C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                   buff );
      }
   }
   else if( ( ( ablkcol && nota  ) || ( ablkrow && !nota ) ) &&
            ( matpos == 'C' ) )
   {
      if( nota && notb )
      {
         int tmp, mpc, nqc;

         rtop = ptop( BROADCAST, ROW, TOPGET );
         ctop = ptop( BROADCAST, COLUMN, TOPGET );
         if( ablkrow && !nota )
         {
         pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m, n, k,
                   &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                   &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                   &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                   C2F_CHAR( "A" ), C2F_CHAR( rtop ), C2F_CHAR( NO ),
                   C2F_CHAR( ctop ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                   buff );
         }
         else
         {
         tmp = *m + iroffc;
         mpc = numroc_( &tmp, &desc_C[MB_], &myrow, &icrow, &nprow );
         tmp = *n + icoffc;
         nqc = numroc_( &tmp, &desc_C[NB_], &mycol, &iccol, &npcol );
         if( myrow == icrow )
            mpc -= iroffc;
         if( mycol == iccol )
            nqc -= icoffc;

         tmp = MAX( 1, mpc );
         if( mycol == iacol )
         {
            dgebs2d_( &ictxt, C2F_CHAR( "R" ), C2F_CHAR( rtop ),
                      &mpc, k, &A[iia-1+(jja-1)*desc_A[LLD_]],
                      &desc_A[LLD_] );
            dlacpy_( C2F_CHAR( "A" ), &mpc, k, &A[iia-1+(jja-1)*desc_A[LLD_]],
                    &desc_A[LLD_], buff, &tmp ); 
         }
         else
            dgebr2d_( &ictxt, C2F_CHAR( "R" ), C2F_CHAR( rtop ),
                      &mpc, k, buff, &tmp, &myrow, &iacol );

         if( myrow == ibrow )
         {
            dgebs2d_( &ictxt, C2F_CHAR( "C" ), C2F_CHAR( ctop ),
                      k, &nqc, &B[iib-1+(jjb-1)*desc_B[LLD_]], 
                      &desc_B[LLD_] );
            dlacpy_( C2F_CHAR( "A" ), k, &nqc, &B[iib-1+(jjb-1)*desc_B[LLD_]],
                     &desc_B[LLD_], buff+(mpc**k), k ); 
         }
         else
         {
            dgebr2d_( &ictxt, C2F_CHAR( "C" ), C2F_CHAR( ctop ),
                      k, &nqc, buff+(mpc**k), k, &ibrow, &mycol );
         }

         dgemm_( transa, transb, &mpc, &nqc, k, alpha, buff, &tmp,
                 buff+(mpc**k), k, beta, &C[iic-1+(jjc-1)*desc_C[LLD_]],
                 &desc_C[LLD_] );
         }
      }
      else
      {
         pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m, n, k,
                   &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                   &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                   &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                   &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                   &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                   C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                   C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                   buff );
      }
   }
   else
   {
      if( matpos == 'A' )               /* loop over the columns of C */
      {
         j = CEIL( (*jc), desc_C[NB_] ) * desc_C[NB_];
         jn = (*jc)+(*n)-1;
         jn = MIN( j, jn );
         jblk = jn-(*jc)+1;

         if( notb )                     /* loop over the columns of B */
         {                           /* Handle first block separately */
            pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m,
                      &jblk, k, &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                      &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                      &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                      beta, &C[iic-1+(jjc-1)*desc_C[LLD_]],
                      &desc_C[LLD_], &iarow, &iacol, &ibrow, &ibcol,
                      &icrow, &iccol, C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ),
                      C2F_CHAR( NO ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                      C2F_CHAR( NO ), buff );
            if( mycol == ibcol )
            {
               jjb += jblk;
               jjb = MIN( jjb, ncb );
            }
            if( mycol == iccol )
            {
               jjc += jblk;
               jjc = MIN( jjc, ncc );
            }
            ibcol = (ibcol+1) % npcol;
            iccol = (iccol+1) % npcol;
                              /* loop over remaining block of columns */
            tmp0 = (*jc)+(*n)-1;
            for( j=jn+1; j <= tmp0; j+=desc_C[NB_] )
            {
               jblk = (*n)-j+(*jc);
               jblk = MIN( jblk, desc_C[NB_] );
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m,
                         &jblk, k, &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                         beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                         C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( mycol == ibcol )
               {
                  jjb += jblk;
                  jjb = MIN( jjb, ncb );
               }
               if( mycol == iccol )
               {
                  jjc += jblk;
                  jjc = MIN( jjc, ncc );
               }
               ibcol = (ibcol+1) % npcol;
               iccol = (iccol+1) % npcol;
            }
         }
         else                              /* loop over the rows of B */
         {                           /* Handle first block separately */
            if( nota )
            {
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m,
                         &jblk, k, &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                         C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( myrow == ibrow )
               {
                  iib += jblk;
                  iib = MIN( iib, nrb );
               }
               if( mycol == iccol )
               {
                  jjc += jblk;
                  jjc = MIN( jjc, ncc );
               }
               ibrow = (ibrow+1) % nprow;
               iccol = (iccol+1) % npcol;
                                        /* loop over remaining blocks */
               tmp0 = (*jc)+(*n)-1;
               for( j=jn+1; j <= tmp0; j+=desc_C[NB_] )
               {
                  jblk = (*n)-j+(*jc);
                  jblk = MIN( jblk, desc_C[NB_] );
                  pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                            m, &jblk, k, &desc_C[MB_], &desc_C[NB_], &kb,
                            alpha,
                            &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                            &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                            beta,
                            &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                            &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                            C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( NO ), buff );
                  if( myrow == ibrow )
                  {
                     iib += jblk;
                     iib = MIN( iib, nrb );
                  }
                  if( mycol == iccol )
                  {
                     jjc += jblk;
                     jjc = MIN( jjc, ncc );
                  }
                  ibrow = (ibrow+1) % nprow;
                  iccol = (iccol+1) % npcol;
               }
            }
            else
            {
               ctop = ptop( BROADCAST, COLUMN, TOPGET );
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                         m, &jblk, k, &desc_C[MB_], &desc_C[NB_], &kb,
                         alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                         beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                         C2F_CHAR( ctop ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( myrow == ibrow )
               {
                  iib += jblk;
                  iib = MIN( iib, nrb );
               }
               if( mycol == iccol )
               {
                  jjc += jblk;
                  jjc = MIN( jjc, ncc );
               }
               ibrow = (ibrow+1) % nprow;
               iccol = (iccol+1) % npcol;
                                        /* loop over remaining blocks */
               tmp0 = (*jc)+(*n)-1;
               for( j=jn+1; j <= tmp0; j+=desc_C[NB_] )
               {
                  jblk = (*n)-j+(*jc);
                  jblk = MIN( jblk, desc_C[NB_] );
                  pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                            m, &jblk, k, &desc_C[MB_], &desc_C[NB_], &kb,
                            alpha,
                            &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                            &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                            beta,
                            &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                            &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                            C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( ctop ), C2F_CHAR( NO ),
                            C2F_CHAR( NO ), buff );
                  if( myrow == ibrow )
                  {
                     iib += jblk;
                     iib = MIN( iib, nrb );
                  }
                  if( mycol == iccol )
                  {
                     jjc += jblk;
                     jjc = MIN( jjc, ncc );
                  }
                  ibrow = (ibrow+1) % nprow;
                  iccol = (iccol+1) % npcol;
               }
            }
         }
      }
      else if( matpos == 'B' )             /* loop over the rows of C */
      {
         i = CEIL( (*ic), desc_C[MB_] ) * desc_C[MB_];
         in = (*ic)+(*m)-1;
         in = MIN( i, in );
         iblk = in-(*ic)+1;

         if( nota )                        /* loop over the rows of A */
         {                           /* Handle first block separately */
            pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                      &iblk, n, k, &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                      &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                      &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                      &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                      &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                      C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                      C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                      buff );
            if( myrow == iarow )
            {
               iia += iblk;
               iia = MIN( iia, nra );
            }
            if( myrow == icrow )
            {
               iic += iblk;
               iic = MIN( iic, nrc );
            }
            iarow = (iarow+1) % nprow;
            icrow = (icrow+1) % nprow;
                                        /* loop over remaining blocks */
            tmp0 = (*ic)+(*m)-1;
            for( i=in+1; i <= tmp0; i+=desc_C[MB_] )
            {
               iblk = (*m)-i+(*ic);
               iblk = MIN( iblk, desc_C[MB_] );
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                         &iblk, n, k, &desc_C[MB_], &desc_C[NB_], &kb,
                         alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                         beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                         C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( myrow == iarow )
               {
                  iia += iblk;
                  iia = MIN( iia, nra );
               }
               if( myrow == icrow )
               {
                  iic += iblk;
                 iic = MIN( iic, nrc );
               }
               iarow = (iarow+1) % nprow;
               icrow = (icrow+1) % nprow;
            }
         }
         else                           /* loop over the columns of A */
         {                           /* Handle first block separately */
            if( notb )
            {
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                         &iblk, n, k, &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                         C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( mycol == iacol )
               {
                  jja += iblk;
                  jja = MIN( jja, nca );
               }
               if( myrow == icrow )
               {
                  iic += iblk;
                  iic = MIN( iic, nrc );
               }
               iacol = (iacol+1) % npcol;
               icrow = (icrow+1) % nprow;
                                        /* loop over remaining blocks */
               tmp0 = (*ic)+(*m)-1;
               for( i=in+1; i <= tmp0; i+=desc_C[MB_] )
               {
                  iblk = (*m)-i+(*ic);
                  iblk = MIN( iblk, desc_C[MB_] );
                  pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                            &iblk, n, k, &desc_C[MB_], &desc_C[NB_], &kb,
                            alpha,
                            &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                            &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                            beta,
                            &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                            &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                            C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( NO ), buff );
                  if( mycol == iacol )
                  {
                     jja += iblk;
                     jja = MIN( jja, nca );
                  }
                  if( myrow == icrow )
                  {
                     iic += iblk;
                     iic = MIN( iic, nrc );
                  }
                  iacol = (iacol+1) % npcol;
                  icrow = (icrow+1) % nprow;
               }
            }
            else
            {
               rtop = ptop( BROADCAST, ROW, TOPGET );
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                         &iblk, n, k, &desc_C[MB_], &desc_C[NB_], &kb,
                         alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                         beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( rtop ), C2F_CHAR( NO ),
                         C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( mycol == iacol )
               {
                  jja += iblk;
                  jja = MIN( jja, nca );
               }
               if( myrow == icrow )
               {
                  iic += iblk;
                  iic = MIN( iic, nrc );
               }
               iacol = (iacol+1) % npcol;
               icrow = (icrow+1) % nprow;
                                        /* loop over remaining blocks */
               tmp0 = (*ic)+(*m)-1;
               for( i=in+1; i <= tmp0; i+=desc_C[MB_] )
               {
                  iblk = (*m)-i+(*ic);
                  iblk = MIN( iblk, desc_C[MB_] );
                  pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                            &iblk, n, k, &desc_C[MB_], &desc_C[NB_], &kb,
                            alpha,
                            &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                            &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                            beta,
                            &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                            &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                            C2F_CHAR( "A" ), C2F_CHAR( rtop ), C2F_CHAR( NO ),
                            C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                            C2F_CHAR( NO ), buff );
                  if( mycol == iacol )
                  {
                     jja += iblk;
                     jja = MIN( jja, nca );
                  }
                  if( myrow == icrow )
                  {
                     iic += iblk;
                     iic = MIN( iic, nrc );
                  }
                  iacol = (iacol+1) % npcol;
                  icrow = (icrow+1) % nprow;
               }
            }
         }
      }
      else if( matpos == 'C' )
      {
         tbeta = ONE;
         if( nota )                     /* loop over the columns of A */
         {
            j = CEIL( (*ja), desc_A[NB_] ) * desc_A[NB_];
            jn = (*ja)+(*k)-1;
            jn = MIN( j, jn );
            jblk = jn-(*ja)+1;

            if( notb )                     /* loop over the rows of B */
            {                        /* Handle first block separately */
               int mpc, nqc, ldw, ioffa, ioffb, ioffc, ipw;
               double zero = ZERO, one = ONE;

               tmp1 = *m + iroffc;
               mpc = numroc_( &tmp1, &desc_C[MB_], &myrow, &icrow, &nprow );
               if( myrow == icrow ) mpc -= iroffc;
               
               tmp2 = *n + icoffc;
               nqc = numroc_( &tmp2, &desc_C[NB_], &mycol, &iccol, &npcol );

               if( *alpha == ZERO )
               {
                  if( *beta == ZERO )
                  {
                     dlaset_( C2F_CHAR( "F" ), &mpc, &nqc, &zero, &zero,
                              &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_] );
                  }
                  else
                  {
                     ioffc = iic-1+(jjc-1)*desc_C[LLD_];
                     for( j=0; j<nqc; j++ )
                     {
                         for( i=0; i<mpc; i++ ) C[ioffc+i] *= (*beta);
                         ioffc += desc_C[LLD_];
                     }
                  }
                  return;
               }

               if( *beta == ZERO )     /* C := beta*C */
               {
                  dlaset_( C2F_CHAR( "F" ), &mpc, &nqc, &zero, &zero,
                           &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_] );
               }
               else
               {
                  ioffc = iic-1+(jjc-1)*desc_C[LLD_];
                  for( j=0; j<nqc; j++ )
                  {
                      for( i=0; i<mpc; i++ ) C[ioffc+i] *= (*beta);
                      ioffc += desc_C[LLD_];
                  }
               }

               ipw = desc_A[NB_] * nqc; 
               ldw = MAX( 1, mpc );     /* Handle first block separately */
               ioffa = iia-1+(jja-1)*desc_A[LLD_];
               ioffb = iib-1+(jjb-1)*desc_B[LLD_];
               ioffc = iic-1+(jjc-1)*desc_C[LLD_];

               if( myrow == ibrow )
               {
                  dlacpy_( C2F_CHAR( "F" ), &jblk, &nqc, &B[ioffb],
                           &desc_B[LLD_], buff, &jblk );
                  dgebs2d_( &ictxt, C2F_CHAR( "C" ), C2F_CHAR( "I" ),
                            &jblk, &nqc, buff, &jblk );
               }
               else
               {
                  dgebr2d_( &ictxt, C2F_CHAR( "C" ), C2F_CHAR( "I" ),
                            &jblk, &nqc, buff, &jblk, &ibrow, &mycol );
               }

               if( mycol == iacol )
               {
                  dlacpy_( C2F_CHAR( "F" ), &mpc, &jblk, &A[ioffa],
                           &desc_A[LLD_], buff+ipw, &ldw );
                  dgebs2d_( &ictxt, C2F_CHAR( "R" ), C2F_CHAR( "I" ),
                            &mpc, &jblk, buff+ipw, &ldw );
               }
               else
               {
                  dgebr2d_( &ictxt, C2F_CHAR( "R" ), C2F_CHAR( "I" ),
                            &mpc, &jblk, buff+ipw, &ldw, &myrow, &iacol );
               }

               dgemm_( C2F_CHAR( "N" ), C2F_CHAR( "N" ), &mpc, &nqc,
                       &jblk, alpha, buff+ipw, &ldw, buff, &jblk, &one,
                       &C[ioffc], &desc_C[LLD_] );

               if( mycol == iacol )
               {
                  jja += jblk;
                  jja = MIN( jja, nca );
                  ioffa = iia-1+(jja-1)*desc_A[LLD_];
               }
               if( myrow == ibrow )
               {
                  iib += jblk;
                  iib = MIN( iib, nrb );
                  ioffb = iib-1+(jjb-1)*desc_B[LLD_];
               }
               iacol = (iacol+1) % npcol;
               ibrow = (ibrow+1) % nprow;

                                        /* loop over remaining blocks */
               tmp0 = (*ja)+(*k)-1;
               for( j=jn+1; j <= tmp0; j+=desc_A[NB_] )
               {
                  jblk = (*k)-j+(*ja);
                  jblk = MIN( jblk, desc_A[NB_] );

                  if( myrow == ibrow )
                  {
                     dlacpy_( C2F_CHAR( "F" ), &jblk, &nqc, &B[ioffb],
                              &desc_B[LLD_], buff, &jblk );
                     dgebs2d_( &ictxt, C2F_CHAR( "C" ), C2F_CHAR( "I" ),
                               &jblk, &nqc, buff, &jblk );
                  }
                  else
                  {
                     dgebr2d_( &ictxt, C2F_CHAR( "C" ), C2F_CHAR( "I" ),
                               &jblk, &nqc, buff, &jblk, &ibrow, &mycol );
                  }

                  if( mycol == iacol )
                  {
                     dlacpy_( C2F_CHAR( "F" ), &mpc, &jblk, &A[ioffa],
                              &desc_A[LLD_], buff+ipw, &ldw );
                     dgebs2d_( &ictxt, C2F_CHAR( "R" ), C2F_CHAR( "I" ),
                              &mpc, &jblk, buff+ipw, &ldw );
                  }
                  else
                  {
                     dgebr2d_( &ictxt, C2F_CHAR( "R" ), C2F_CHAR( "I" ),
                               &mpc, &jblk, buff+ipw, &ldw, &myrow, &iacol );
                  }

                  dgemm_( C2F_CHAR( "N" ), C2F_CHAR( "N" ), &mpc, &nqc,
                          &jblk, alpha, buff+ipw, &ldw, buff, &jblk, &one,
                          &C[ioffc], &desc_C[LLD_] );

                  if( mycol == iacol )
                  {
                     jja += jblk;
                     jja = MIN( jja, nca );
                     ioffa = iia-1+(jja-1)*desc_A[LLD_];
                  }
                  if( myrow == ibrow )
                  {
                     iib += jblk;
                     iib = MIN( iib, nrb );
                     ioffb = iib-1+(jjb-1)*desc_B[LLD_];
                  }
                  iacol = (iacol+1) % npcol;
                  ibrow = (ibrow+1) % nprow;
               }

#if 0
               rtop = ptop( BROADCAST, ROW, TOPGET );
               ctop = ptop( BROADCAST, COLUMN, TOPGET );
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                         m, n, &jblk, &desc_C[MB_], &desc_C[NB_], &kb,
                         alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                         beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( rtop ), C2F_CHAR( NO ),
                         C2F_CHAR( ctop ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( mycol == iacol )
               {
                  jja += jblk;
                  jja = MIN( jja, nca );
               }
               if( myrow == ibrow )
               {
                  iib += jblk;
                  iib = MIN( iib, nrb );
               }
               iacol = (iacol+1) % npcol;
               ibrow = (ibrow+1) % nprow;
                                        /* loop over remaining blocks */
               tmp0 = (*ja)+(*k)-1;
               for( j=jn+1; j <= tmp0; j+=desc_A[NB_] )
               {
                  jblk = (*k)-j+(*ja);
                  jblk = MIN( jblk, desc_A[NB_] );
                  pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                            m, n, &jblk, &desc_C[MB_], &desc_C[NB_], &kb,
                            alpha,
                            &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                            &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                            &tbeta,
                            &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                            &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                            C2F_CHAR( "A" ), C2F_CHAR( rtop ), C2F_CHAR( NO ),
                            C2F_CHAR( ctop ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                            buff );
                  if( mycol == iacol )
                  {
                     jja += jblk;
                     jja = MIN( jja, nca );
                  }
                  if( myrow == ibrow )
                  {
                     iib += jblk;
                     iib = MIN( iib, nrb );
                  }
                  iacol = (iacol+1) % npcol;
                  ibrow = (ibrow+1) % nprow;
               }
#endif
            }
            else                        /* loop over the columns of B */
            {                        /* Handle first block separately */
              pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m,
                         n, &jblk, &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                         C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( mycol == iacol )
               {
                  jja += jblk;
                  jja = MIN( jja, nca );
               }
               if( mycol == ibcol )
               {
                  jjb += jblk;
                  jjb = MIN( jjb, ncb );
               }
               iacol = (iacol+1) % npcol;
               ibcol = (ibcol+1) % npcol;
                                        /* loop over remaining blocks */
               tmp0 = (*ja)+(*k)-1;
               for( j=jn+1; j <= tmp0; j+=desc_A[NB_] )
               {
                  jblk = (*k)-j+(*ja);
                  jblk = MIN( jblk, desc_A[NB_] );
                  pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                            m, n, &jblk, &desc_C[MB_], &desc_C[NB_], &kb,
                            alpha,
                            &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                            &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                            &tbeta,
                            &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                            &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                            C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( NO ), buff );
                  if( mycol == iacol )
                  {
                     jja += jblk;
                     jja = MIN( jja, nca );
                  }
                  if( mycol == ibcol )
                  {
                     jjb += jblk;
                     jjb = MIN( jjb, ncb );
                  }
                  iacol = (iacol+1) % npcol;
                  ibcol = (ibcol+1) % npcol;
               }
            }
         }
         else                              /* loop over the rows of A */
         {
            i = CEIL( (*ia), desc_A[MB_] ) * desc_A[MB_];
            in = (*ia)+(*k)-1;
            in = MIN( i, in );
            iblk = in-(*ia)+1;

            if( notb )                     /* loop over the rows of B */
            {                        /* Handle first block separately */
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m,
                         n, &iblk, &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                         C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( myrow == iarow )
               {
                  iia += iblk;
                  iia = MIN( iia, nra );
               }
               if( myrow == ibrow )
               {
                  iib += iblk;
                  iib = MIN( iib, nrb );
               }
               iarow = (iarow+1) % nprow;
               ibrow = (ibrow+1) % nprow;
                                        /* loop over remaining blocks */
               tmp0 = (*ia)+(*k)-1;
               for( i=in+1; i <= tmp0; i+=desc_A[MB_] )
               {
                  iblk = (*k)-i+(*ia);
                  iblk = MIN( iblk, desc_A[MB_] );
                  pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                            m, n, &iblk, &desc_C[MB_], &desc_C[NB_], &kb,
                            alpha,
                            &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                            &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                            &tbeta,
                            &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                            &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                            C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( NO ), buff );
                  if( myrow == iarow )
                  {
                     iia += iblk;
                     iia = MIN( iia, nra );
                  }
                  if( myrow == ibrow )
                  {
                     iib += iblk;
                     iib = MIN( iib, nrb );
                  }
                  iarow = (iarow+1) % nprow;
                  ibrow = (ibrow+1) % nprow;
               }
            }
            else                        /* loop over the columns of B */
            {                        /* Handle first block separately */
               pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb, m,
                         n, &iblk, &desc_C[MB_], &desc_C[NB_], &kb, alpha,
                         &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                         &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_], beta,
                         &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                         &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                         C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ), C2F_CHAR( NO ),
                         C2F_CHAR( TOPDEF ), C2F_CHAR( NO ), C2F_CHAR( NO ),
                         buff );
               if( myrow == iarow )
               {
                  iia += iblk;
                  iia = MIN( iia, nra );
               }
               if( mycol == ibcol )
               {
                  jjb += iblk;
                  jjb = MIN( jjb, ncb );
               }
               iarow = (iarow+1) % nprow;
               ibcol = (ibcol+1) % npcol;
                                        /* loop over remaining blocks */
               tmp0 = (*ia)+(*k)-1;
               for( i=in+1; i <= tmp0; i+=desc_A[MB_] )
               {
                  iblk = (*k)-i+(*ia);
                  iblk = MIN( iblk, desc_A[MB_] );
                  pbdgemm_( &ictxt, C2F_CHAR( &matpos ), transa, transb,
                            m, n, &iblk, &desc_C[MB_], &desc_C[NB_], &kb,
                            alpha,
                            &A[iia-1+(jja-1)*desc_A[LLD_]], &desc_A[LLD_],
                            &B[iib-1+(jjb-1)*desc_B[LLD_]], &desc_B[LLD_],
                            &tbeta,
                            &C[iic-1+(jjc-1)*desc_C[LLD_]], &desc_C[LLD_],
                            &iarow, &iacol, &ibrow, &ibcol, &icrow, &iccol,
                            C2F_CHAR( "A" ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( TOPDEF ),
                            C2F_CHAR( NO ), C2F_CHAR( NO ), buff );
                  if( myrow == iarow )
                  {
                     iia += iblk;
                     iia = MIN( iia, nra );
                  }
                  if( mycol == ibcol )
                  {
                     jjb += iblk;
                     jjb = MIN( jjb, ncb );
                  }
                  iarow = (iarow+1) % nprow;
                  ibcol = (ibcol+1) % npcol;
               }
            }
         }
      }
   }
#if( _MACH_ == _T3D_ )
   blacs_pack( _cptofcd( NO, 1 ) );
#endif
}
