      SUBROUTINE PDGELQF0( M, N, A, IA, JA, DESCA, TAU, WORK, LWORK,
     $                     INFO )
*
*     .. Scalar Arguments ..
      INTEGER             IA, INFO, JA, LWORK, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), TAU( * ), WORK( * )
*     ..
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
*     .. Local Scalars ..
      CHARACTER          COLBTOP, ROWBTOP
      INTEGER            I, IACOL, IAROW, IB, ICTXT, IINFO, IN, IPW,
     $                   IROFF, J, K, LWMIN, MP0, MYCOL, MYROW, NPCOL,
     $                   NPROW, NQ0
*     ..
*     .. Local Arrays ..
      INTEGER            IDUM1( 1 ), IDUM2( 1 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CHK1MAT, PCHK1MAT, PDGELQ2,
     $                   PDLARFB, PDLARFT, PTOPGET, PTOPSET, PXERBLA
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, INDXG2P, NUMROC
      EXTERNAL           ICEIL, INDXG2P, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -607
      ELSE
         CALL CHK1MAT( M, 1, N, 2, IA, JA, DESCA, 6, INFO )
         IF( INFO.EQ.0 ) THEN
            IROFF = MOD( IA-1, DESCA( MB_ ) )
            IAROW = INDXG2P( IA, DESCA( MB_ ), MYROW, DESCA( RSRC_ ), 
     $                       NPROW )
            IACOL = INDXG2P( JA, DESCA( NB_ ), MYCOL, DESCA( CSRC_ ), 
     $                       NPCOL )
            MP0 = NUMROC( M+IROFF, DESCA( MB_ ), MYROW, IAROW, NPROW )
            NQ0 = NUMROC( N+MOD( JA-1, DESCA( NB_ ) ), DESCA( NB_ ), 
     $                    MYCOL, IACOL, NPCOL )
            LWMIN = DESCA( MB_ ) * ( MP0 + NQ0 + DESCA( MB_ ) )
*
            WORK( 1 ) = DBLE( LWMIN )
            IF( LWORK.LT.LWMIN )
     $         INFO = -9
         END IF
         CALL PCHK1MAT( M, 1, N, 2, IA, JA, DESCA, 6, 0, IDUM1, IDUM2,
     $                  INFO )
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDGELQF', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
      K = MIN( M, N )
      IPW = DESCA( MB_ ) * DESCA( MB_ ) + 1
      CALL PTOPGET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( ICTXT, 'Broadcast', 'Columnwise', COLBTOP )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', ' ' )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', 'I-ring' )
*
*     Handle the first block of rows separately
*
      IN = MIN( ICEIL( IA, DESCA( MB_ ) ) * DESCA( MB_ ), IA+K-1 )
      IB = IN - IA + 1
*
*     Compute the LQ factorization of the first block A(ia:in:ja:ja+n-1)
*
      CALL PDGELQ2( IB, N, A, IA, JA, DESCA, TAU, WORK, LWORK, IINFO )
*
      IF( IA+IB.LE.IA+M-1 ) THEN
*
*        Form the triangular factor of the block reflector
*        H = H(ia) H(ia+1) . . . H(in)
*
         CALL PDLARFT( 'Forward', 'Rowwise', N, IB, A, IA, JA, DESCA,
     $                 TAU, WORK, WORK( IPW ) )
*
*        Apply H to A(ia+ib:ia+m-1,ja:ja+n-1) from the right
*
         CALL PDLARFB( 'Right', 'No transpose', 'Forward', 'Rowwise',
     $                 M-IB, N, IB, A, IA, JA, DESCA, WORK, A, IA+IB,
     $                 JA, DESCA, WORK( IPW ) )
      END IF
*
*     Loop over the remaining blocks of rows
*
      DO 10 I = IN+1, IA+K-1, DESCA( MB_ )
         IB = MIN( K-I+IA, DESCA( MB_ ) )
         J = JA + I - IA
*
*        Compute the LQ factorization of the current block
*        A(i:i+ib-1:j:ja+n-1)
*
         CALL PDGELQ2( IB, N-I+IA, A, I, J, DESCA, TAU, WORK, LWORK,
     $                 IINFO )
*
         IF( I+IB.LE.IA+M-1 ) THEN
*
*           Form the triangular factor of the block reflector
*           H = H(i) H(i+1) . . . H(i+ib-1)
*
            CALL PDLARFT( 'Forward', 'Rowwise', N-I+IA, IB, A, I, J,
     $                    DESCA, TAU, WORK, WORK( IPW ) )
*
*           Apply H to A(i+ib:ia+m-1,j:ja+n-1) from the right
*
            CALL PDLARFB( 'Right', 'No transpose', 'Forward', 'Rowwise',
     $                     M-I-IB+IA, N-J+JA, IB, A, I, J, DESCA, WORK,
     $                     A, I+IB, J, DESCA, WORK( IPW ) )
         END IF
*
   10 CONTINUE
*
      CALL PTOPSET( ICTXT, 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPSET( ICTXT, 'Broadcast', 'Columnwise', COLBTOP )
*
      WORK( 1 ) = DBLE( LWMIN )
*
      RETURN
*
      END
