      SUBROUTINE PDAJDIAG( TASK, N, A, IA, JA, DESCA, ALPHA )
*     .. Scalar Arguments ..
      INTEGER            IA, JA, N
      DOUBLE PRECISION	 ALPHA
      CHARACTER          TASK
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  Purpose
*  =======
*
*  PDAJDIAG (ADJ)usts the (DIAG)onal of a square distributed matrix.
*  It can either performs a diagonal shift by ALPHA, or set the 
*  diagonal to ALPHA.
*  It operates on the matrix sub( A ) denoted by A(IA:IA+N-1, JA:JA+N-1).
*
*  Notes
*  =====
*
*  TASK	   (global input) Character*1
*          If TASK == 'A', ALPHA will be added to each entry on the diagonal
*             of sub(A);
*          if TASK == 'S', each element of the diagonal of sub(A) will be 
*             set to ALPHA
*
*  N       (global input) INTEGER
*          The number of rows and columns to be operated on i.e the
*          order of the distributed submatrix sub( A ).  N >= 0.
*
*  A       (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension ( LLD_A, LOCq(JA+N-1) ). 
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_
*          The array descriptor for the distributed matrix A.
*
*  ALPHA   (global input) INTEGER
*          The constant applied to each diagonal entry of the submatrix.
*          See variable 'TASK' for details on how ALPHA is interpreted.
*
*  ====================================================================
*
*     .. Parameters ..
      INTEGER            CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      DOUBLE PRECISION   ZERO
      PARAMETER          ( ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            ICURCOL, ICURROW, II, IOFFA, J, JB, JJ, JN,
     $                   LDA, LL, MYCOL, MYROW, NPCOL, NPROW
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DGSUM2D, INFOG2L
*     ..
*     .. External Functions ..
      INTEGER            ICEIL
      LOGICAL            LSAME
      EXTERNAL           ICEIL, LSAME
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, MYROW, MYCOL )
*
      IF ( N .EQ. 0 .OR. ( LSAME(TASK, 'A') .AND. ALPHA .EQ. ZERO ) )
     $   RETURN
*
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, II, JJ,
     $              ICURROW, ICURCOL )
*
      JN = MIN( ICEIL( JA, DESCA( NB_ ) ) * DESCA( NB_ ), JA+N-1 )
      JB = JN - JA + 1
      LDA = DESCA( LLD_ )
      IOFFA = II + ( JJ - 1 ) * LDA
*
*     Handle first diagonal block separately
*
      IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
         IF ( LSAME(TASK, 'S') ) THEN
            DO 10 LL = IOFFA, IOFFA + (JB-1)*(LDA+1), LDA+1
	       A(LL) = ALPHA
   10       CONTINUE
         ELSE
            DO 15 LL = IOFFA, IOFFA + (JB-1)*(LDA+1), LDA+1
	       A(LL) = A(LL) + ALPHA
   15       CONTINUE
         END IF
      END IF
      IF( MYROW.EQ.ICURROW )
     $   IOFFA = IOFFA + JB
      IF( MYCOL.EQ.ICURCOL )
     $   IOFFA = IOFFA + JB*LDA
      ICURROW = MOD( ICURROW+1, NPROW )
      ICURCOL = MOD( ICURCOL+1, NPCOL )
*
*     Loop over the remaining block of columns
*
      DO 30 J = JN+1, JA+N-1, DESCA( NB_ )
         JB = MIN( JA+N-J, DESCA( NB_ ) )
*
         IF( MYROW.EQ.ICURROW .AND. MYCOL.EQ.ICURCOL ) THEN
            IF ( LSAME(TASK, 'S') ) THEN
               DO 20 LL = IOFFA, IOFFA + (JB-1)*(LDA+1), LDA+1
	          A(LL) = ALPHA
   20          CONTINUE
         ELSE
               DO 25 LL = IOFFA, IOFFA + (JB-1)*(LDA+1), LDA+1
	          A(LL) = A(LL) + ALPHA
   25          CONTINUE
         END IF
      END IF
         IF( MYROW.EQ.ICURROW )
     $      IOFFA = IOFFA + JB
         IF( MYCOL.EQ.ICURCOL )
     $      IOFFA = IOFFA + JB*LDA
         ICURROW = MOD( ICURROW+1, NPROW )
         ICURCOL = MOD( ICURCOL+1, NPCOL )
   30 CONTINUE
*
      RETURN
*
*     End of PDAJDIAG
*
      END
