*
*     ScaLAPACK Debugging routines
*
*     Author: Howard Robinson, hbr@cs.berkeley.edu
*
      SUBROUTINE PRINT_DESC( DESC, MNAME )
*
*     Prints a Descriptor for the matrix (specified by its name).
*
      INTEGER            DESC( * )
      CHARACTER*8        MNAME
      INTEGER            BLOCK_CYCLIC_2D, CSRC_, CTXT_, DLEN_, DT_,
     $                   LLD_, MB_, M_, NB_, N_, RSRC_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1,
     $                     CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                     RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )


      WRITE( 6, FMT=* ) 'Printing Descriptor for ', MNAME
      WRITE( 6, FMT=99 ) 'CTXT', DESC( CTXT_ )
      WRITE( 6, FMT=99 ) ' M  ', DESC( M_ )
      WRITE( 6, FMT=99 ) ' N  ', DESC( N_ )
      WRITE( 6, FMT=99 ) ' MB ', DESC( MB_ )
      WRITE( 6, FMT=99 ) ' NB ', DESC( NB_ )
      WRITE( 6, FMT=99 ) 'RSRC', DESC( RSRC_ )
      WRITE( 6, FMT=99 ) 'CSRC', DESC( CSRC_ )
      WRITE( 6, FMT=99 ) 'LLD ', DESC( LLD_ )
      WRITE( 6, FMT=99 ) 'TYPE', DESC( DT_ )

 99   FORMAT( '   DESC(', A4, ') = ', I4 )

      RETURN
      END
