#if !defined(_ARRAY_H_)
#define _ARRAY_H_

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#define KEY(x) (*(double*)(x))

typedef struct {
  int maxElts, numElts, eltBytes;
  char * array;
} Array_t;

Array_t * ArrayCreate ( int eltBytes, int startSize );
void    * ArrayBase ( Array_t * array );
int       ArraySize ( Array_t * array );
int       ArrayIsEmpty ( Array_t * array );
int       ArrayInsert ( Array_t * array, void * eltPtr );
int       ArrayDelete ( Array_t * array, void * outEltPtr );
void      ArrayDestroy ( Array_t * a );
int 	  ArrayGet(Array_t * a, int k, void * outEltPtr );

#endif _ARRAY_H_
