
#include "array.h"

#define bcopy(_s1,_s2,_len) memcpy(_s2,_s1,_len)

Array_t * ArrayCreate ( int eltBytes, int startSize )
{
  Array_t * newArray = (Array_t*) malloc(sizeof(Array_t));
  newArray->numElts = 0;
  newArray->maxElts = startSize;
  newArray->eltBytes = eltBytes;
  newArray->array = (char*) malloc(eltBytes*startSize);
  return newArray;
}

void * ArrayBase ( Array_t * array )
{
  return array->array;
}

int ArraySize ( Array_t * array )
{
  return array->numElts;
}

int ArrayIsEmpty ( Array_t * a )
{
  return ArraySize(a) == 0;
}

int ArrayInsert ( Array_t * a, void * eltPtr )
{
  int i, here;

  if ( a->numElts == a->maxElts ) {
    fprintf(stderr, "ArrayInsert: array too small\n" );
    return 0;
  }

  for ( here = 0; here < a->numElts; here++ )
    if ( KEY(eltPtr) > KEY(a->array + here * a->eltBytes) )
      break;

  for (i=a->numElts; i>here; i--) {
     bcopy(a->array + (i-1)*a->eltBytes, a->array + i*a->eltBytes, a->eltBytes);
  }
/*
  bcopy(a->array + here * a->eltBytes, a->array + (here+1) * a->eltBytes,
	(a->numElts - here) * a->eltBytes);
*/
  bcopy(eltPtr, a->array + here * a->eltBytes, a->eltBytes);
  a->numElts++;
  return 1;
}
  
int ArrayGet(Array_t * a, int k, void * outEltPtr )
{
  if ( a->numElts < k )
    return 0;
  bcopy(a->array + (k-1)*a->eltBytes, outEltPtr, a->eltBytes);
  return 1;
}


int ArrayDelete ( Array_t * a, void * outEltPtr )
{
  if ( a->numElts == 0 )
    return 0;

  bcopy(a->array, outEltPtr, a->eltBytes);
  bcopy(a->array + a->eltBytes, a->array, (a->numElts-1) * a->eltBytes);
  a->numElts--;
  return 1;
}

void ArrayDestroy ( Array_t * a )
{
  if ( a->array )
    free(a->array);
  free(a);
}

void ArrayPrKey ( Array_t * a )
{
  int i;

  for ( i = 0; i < a->numElts; i++ )
    printf ( "%e ", KEY(a->array + i * a->eltBytes) );
  printf ( "\n" );
}

