      SUBROUTINE PDLASETT( UPLO, M, N, ALPHA, BETA, A, IA, JA, DESCA )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
* Purpose
* =======
*
* PLASETT initializes an M-by-N distributed matrix sub( A ) denoting
* A(IA:IA+M-1,JA:JA+N-1) to BETA on the diagonal and ALPHA on the
* offdiagonals.
*
* Note that sub(A) is  stored in packed storage.
*
* Notes
* =====
*
* Each global data object is described by an associated description
* vector.  This vector stores the information required to establish
* the mapping between an object element and its corresponding process
* and memory location.
*
* Let A be a generic term for any 2D block cyclicly distributed array.
* Such a global array has an associated description vector DESCA.
* In the following comments, the character _ should be read as
* "of the global array".
*
* NOTATION        STORED IN      EXPLANATION
* --------------- -------------- --------------------------------------
* DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                DTYPE_A = 1.
* CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                the BLACS process grid A is distribu-
*                                ted over. The context itself is glo-
*                                bal, but the handle (the integer
*                                value) may vary.
* M_A    (global) DESCA( M_ )    The number of rows in the global
*                                array A.
* N_A    (global) DESCA( N_ )    The number of columns in the global
*                                array A.
* MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                the rows of the array.
* NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                the columns of the array.
* RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                row of the array A is distributed.
* CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                first column of the array A is
*                                distributed.
* LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                array.  LLD_A >= MAX(1,LOCr(M_A)).
*
* Let K be the number of rows or columns of a distributed matrix,
* and assume that its process grid has dimension p x q.
* LOCr( K ) denotes the number of elements of K that a process
* would receive if K were distributed over the p processes of its
* process column.
* Similarly, LOCc( K ) denotes the number of elements of K that a
* process would receive if K were distributed over the q processes of
* its process row.
* The values of LOCr() and LOCc() may be determined via a call to the
* ScaLAPACK tool function, NUMROC:
*         LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*         LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
* An upper bound for these quantities may be computed by:
*         LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*         LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
* Arguments
* =========
*
* UPLO    (global input) CHARACTER
*         Specifies the part of the distributed matrix sub( A ) to be
*         set:
*         = 'U':      Upper triangular part is set; the strictly lower
*                     triangular part of sub( A ) is not changed;
*         = 'L':      Lower triangular part is set; the strictly upper
*                     triangular part of sub( A ) is not changed;
*         Otherwise:  All of the matrix sub( A ) is set.
*
* M       (global input) INTEGER
*         The number of rows to be operated on i.e the number of rows
*         of the distributed submatrix sub( A ). M >= 0.
*
* N       (global input) INTEGER
*         The number of columns to be operated on i.e the number of
*         columns of the distributed submatrix sub( A ). N >= 0.
*
* ALPHA   (global input) DTYPE
*         The constant to which the offdiagonal elements are to be
*         set.
*
* BETA    (global input) DTYPE
*         The constant to which the diagonal elements are to be set.
*
* A       (local output) DTYPE
*         an array of dimension (LLD_A,LOCc(JA+N-1)).  This array
*         contains the local pieces of the distributed matrix sub( A )
*         to be set.  On exit, the leading M-by-N submatrix sub( A )
*         is set as follows:
*
*         if UPLO = 'U', A(IA+i-1,JA+j-1) = ALPHA, 1<=i<=j-1, 1<=j<=N,
*         if UPLO = 'L', A(IA+i-1,JA+j-1) = ALPHA, j+1<=i<=M, 1<=j<=N,
*         otherwise,     A(IA+i-1,JA+j-1) = ALPHA, 1<=i<=M, 1<=j<=N,
*                                                  IA+i.NE.JA+j,
*         and, for all UPLO, A(IA+i-1,JA+i-1) = BETA, 1<=i<=min(M,N).
*
* IA      (global input) INTEGER
*         The row index in the global array A indicating the first
*         row of sub( A ).
*
* JA      (global input) INTEGER
*         The column index in the global array A indicating the
*         first column of sub( A ).
*
* DESCA   (global and local input) INTEGER array of dimension DLEN_.
*         The array descriptor for the distributed matrix A.
*
* =====================================================================
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, M_, N_, NB_
      PARAMETER          ( CTXT_ = 2, M_ = 3, N_ = 4, NB_ = 6 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, JA, M, N
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISLOWER, ISUPPER, ISVALID
      INTEGER            CONTXT, IADIAG, IAEND, IASTART, IIA, ISIZE,
     $                   JADIAG, JEND, JJA, JSIZE, JSTART, LOFFSET, NB
*     ..
*     .. Local Arrays ..
      INTEGER            DESC1( DLEN_ )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           DESCINITT, PDLASET, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MOD
*     ..
*     .. Executable Statements ..
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      CONTXT = DESCA( CTXT_ )
      NB = DESCA( NB_ )
      ISVALID = ISLOWER .OR. ISUPPER
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTXT, 'PxLASETT', 1 )
         RETURN
      ENDIF
      ISVALID = ( 1.LE.IA ) .AND. ( IA.LE.DESCA( M_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTXT, 'PxLASETT', 7 )
         RETURN
      ENDIF
      ISVALID = ( 1.LE.JA ) .AND. ( JA.LE.DESCA( N_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTXT, 'PxLASETT', 8 )
         RETURN
      ENDIF
      ISVALID = ( M.GE.1 ) .AND. ( IA+M-1.LE.DESCA( M_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTXT, 'PxLASETT', 2 )
         RETURN
      ENDIF
      ISVALID = ( N.GE.1 ) .AND. ( JA+N-1.LE.DESCA( N_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTXT, 'PxLASETT', 3 )
         RETURN
      ENDIF
      IF( ISLOWER ) THEN
         ISVALID = ( IA.GE.JA )
      ELSE
         IF( ISUPPER ) THEN
            ISVALID = ( JA.GE.IA )
         ENDIF
      ENDIF
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTXT, 'PxLASETT', 1 )
         RETURN
      ENDIF
      IF( ISLOWER ) THEN
         ISVALID = ( IA.GE.JA ) .AND. ( IA+M-1.GE.JA+N-1 )
      ELSE
         IF( ISUPPER ) THEN
            ISVALID = ( IA.LE.JA ) .AND. ( IA+M-1.LE.JA+N-1 )
         ENDIF
      ENDIF
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTXT, 'PxLASETT', 2 )
         RETURN
      ENDIF
      IF( ( M.LE.0 ) .OR. ( N.LE.0 ) ) THEN
         RETURN
      ENDIF
*
*    Main loop.
*
      JSTART = JA
   10 CONTINUE
      IF( JSTART.LE.JA+N-1 ) THEN
         JEND = JSTART - MOD( JSTART-1, NB ) + ( NB-1 )
         JEND = MIN( JA+N-1, JEND )
         JSIZE = JEND - JSTART + 1
         IADIAG = IA + ( JSTART-JA )
         JADIAG = JSTART
*
*        Set diagonal (triangular) part.
*
         CALL DESCINITT( UPLO, IADIAG, JADIAG, DESCA, IIA, JJA, LOFFSET,
     $                   DESC1 )
         CALL PDLASET( UPLO, JSIZE, JSIZE, ALPHA, BETA, A( LOFFSET ),
     $                 IIA, JJA, DESC1 )
*
*       Set off-diagonal (rectangular) part.
*
         IF( ISLOWER ) THEN
            IASTART = IADIAG + JSIZE
            IAEND = IA + M - 1
         ELSE
            IF( ISUPPER ) THEN
               IASTART = IA
               IAEND = IADIAG - 1
            ENDIF
         ENDIF
         ISIZE = IAEND - IASTART + 1
         IF( ISIZE.GE.1 ) THEN
            CALL DESCINITT( UPLO, IASTART, JSTART, DESCA, IIA, JJA,
     $                      LOFFSET, DESC1 )
            CALL PDLASET( 'G', ISIZE, JSIZE, ALPHA, ALPHA, A( LOFFSET ),
     $                    IIA, JJA, DESC1 )
         ENDIF
         JSTART = JEND + 1
         GOTO 10
      ENDIF
   20 CONTINUE
      RETURN
      END
