      REAL             FUNCTION PCLANHP( NORM, UPLO, N, A, IA, JA,
     $                 DESCA, WORK )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
* Purpose
* =======
*
* PLANxP  returns the value of the one norm, or the Frobenius norm,
* or the infinity norm, or the element of largest absolute value of a
* symmetric distributed matrix sub( A ) = A(IA:IA+N-1,JA:JA+N-1).
*
* Note sub(A) is stored in packed storage.
*
* PLANxP returns the value
*
*    ( max(abs(A(i,j))),  NORM = 'M' or 'm' with IA <= i <= IA+N-1,
*    (                                      and  JA <= j <= JA+N-1,
*
*    ( normF( sub( A ) ), NORM = 'F', 'f', 'E' or 'e'
*
* where norm1  denotes the  one norm of a matrix (maximum column sum),
* normI denotes the  infinity norm  of a matrix  (maximum row sum) and
* normF denotes the  Frobenius norm of a matrix (square root of sum of
* squares).  Note that  max(abs(A(i,j)))  is not a  matrix norm.
*
* Notes
* =====
*
* Each global data object is described by an associated description
* vector.  This vector stores the information required to establish
* the mapping between an object element and its corresponding process
* and memory location.
*
* Let A be a generic term for any 2D block cyclicly distributed array.
* Such a global array has an associated description vector DESCA.
* In the following comments, the character _ should be read as
* "of the global array".
*
* NOTATION        STORED IN      EXPLANATION
* --------------- -------------- --------------------------------------
* DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                DTYPE_A = 1.
* CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                the BLACS process grid A is distribu-
*                                ted over. The context itself is glo-
*                                bal, but the handle (the integer
*                                value) may vary.
* M_A    (global) DESCA( M_ )    The number of rows in the global
*                                array A.
* N_A    (global) DESCA( N_ )    The number of columns in the global
*                                array A.
* MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                the rows of the array.
* NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                the columns of the array.
* RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                row of the array A is distributed.
* CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                first column of the array A is
*                                distributed.
* LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                array.  LLD_A >= MAX(1,LOCr(M_A)).
*
* Let K be the number of rows or columns of a distributed matrix,
* and assume that its process grid has dimension p x q.
* LOCr( K ) denotes the number of elements of K that a process
* would receive if K were distributed over the p processes of its
* process column.
* Similarly, LOCc( K ) denotes the number of elements of K that a
* process would receive if K were distributed over the q processes of
* its process row.
* The values of LOCr() and LOCc() may be determined via a call to the
* ScaLAPACK tool function, NUMROC:
*         LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*         LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
* An upper bound for these quantities may be computed by:
*         LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*         LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
* Arguments
* =========
*
* NORM    (global input) CHARACTER
*         Specifies the value to be returned in PLANxP as described
*         above.
*
* UPLO    (global input) CHARACTER
*         Specifies whether the upper or lower triangular part of the
*         symmetric matrix sub( A ) is to be referenced.
*         = 'U':  Upper triangular part of sub( A ) is referenced,
*         = 'L':  Lower triangular part of sub( A ) is referenced.
*
* N       (global input) INTEGER
*         The number of rows and columns to be operated on i.e the
*         number of rows and columns of the distributed submatrix
*         sub( A ). When N = 0, PLANxP is set to zero. N >= 0.
*
* A       (local input)  DTYPE
*         an array of dimension (LLD_A, LOCc(JA+N-1)) containing the
*         local pieces of the symmetric distributed matrix sub( A ).
*         If UPLO = 'U', the leading N-by-N upper triangular part of
*         sub( A ) contains the upper triangular matrix which norm is
*         to be computed, and the strictly lower triangular part of
*         this matrix is not referenced.  If UPLO = 'L', the leading
*         N-by-N lower triangular part of sub( A ) contains the lower
*         triangular matrix which norm is to be computed, and the
*         strictly upper triangular part of sub( A ) is not referenced.
*
* IA      (global input) INTEGER
*         The row index in the global array A indicating the first
*         row of sub( A ).
*
* JA      (global input) INTEGER
*         The column index in the global array A indicating the
*         first column of sub( A ).
*
* DESCA   (global and local input) INTEGER array of dimension DLEN_.
*         The array descriptor for the distributed matrix A.
*
* WORK    (local workspace) FTYPE array dimension (LWORK)
*         LWORK >= 0 if NORM = 'M' or 'm' (not referenced),
*                  0 if NORM = 'F', 'f', 'E' or 'e' (not referenced),
*
*
*        WORK space will be needed when NORM = '1' is implemented.
*
*
* =====================================================================
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8 )
      INTEGER            NDIM
      PARAMETER          ( NDIM = 128 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          NORM, UPLO
      INTEGER            IA, JA, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( DLEN_ )
      REAL               WORK( * )
      COMPLEX            A( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISLOWER, ISMYCOL, ISMYROW, ISNORMF, ISNORMI,
     $                   ISNORMM, ISUPPER
      CHARACTER          CNORM
      INTEGER            CA, CDEST, CONTXT, CPROC, CSRC, IACOL, IADIAG,
     $                   IAEND, IAROW, IASTART, IFIRST, IIA1, IIA2,
     $                   JADIAG, JEND, JINC, JJA1, JJA2, JSIZE, JSTART,
     $                   LDA, LDA0, LDIA, LMM, LOFFSET, M, MB, MM,
     $                   MYPCOL, MYPROW, NB, NPCOL, NPROW, RA, RDEST,
     $                   RPROC, RSRC
      REAL               NORMDIAG, NORMF, NORMF_SCALE, NORMF_SUM, NORMI,
     $                   NORMM, NORMOFF, ONE, TWO, VALUE, ZERO
*     ..
*     .. Local Arrays ..
      REAL               RWORK( 3 )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXFIRST, INDXG2P, NUMROC2
      REAL               CLANGE, CLANSY
      EXTERNAL           LSAME, INDXFIRST, INDXG2P, NUMROC2, CLANGE,
     $                   CLANSY
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CLASSQ, INFOG2LT, INFOT,
     $                   PSTREECOMB, PXERBLA, SCOMBSSQ, SGAMX2D,
     $                   SGEBR2D, SGEBS2D
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD, REAL, SQRT
*     ..
*     .. Executable Statements ..
      ONE = REAL( 1 )
      TWO = REAL( 2 )
      ZERO = REAL( 0 )
      VALUE = ZERO
      NORMM = ZERO
      NORMI = ZERO
      NORMF = ZERO
      NORMF_SCALE = ZERO
      NORMF_SUM = ONE
      M = N
      IF( N.LE.0 ) THEN
         PCLANHP = ( ZERO )
         RETURN
      ENDIF
      CONTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( CONTXT, NPROW, NPCOL, MYPROW, MYPCOL )
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      ISNORMM = LSAME( NORM, 'M' )
      ISNORMF = LSAME( NORM, 'F' ) .OR. LSAME( NORM, 'E' )
      ISNORMI = LSAME( NORM, 'I' ) .OR. LSAME( NORM, '1' ) .OR.
     $          LSAME( NORM, 'O' )
*
*        1-norm is not implemented yet.
*
      IF( ISNORMI ) THEN
         CALL PXERBLA( CONTXT, 'PLANxP', 1 )
      ENDIF
      MB = DESCA( MB_ )
      NB = DESCA( NB_ )
      RSRC = DESCA( RSRC_ )
      CSRC = DESCA( CSRC_ )
      IAROW = INDXG2P( IA, MB, MYPROW, RSRC, NPROW )
      IACOL = INDXG2P( JA, NB, MYPCOL, CSRC, NPCOL )
      IF( ISNORMM ) THEN
         CNORM = 'M'
      ELSE
         IF( ISNORMF ) THEN
            CNORM = 'F'
         ELSE
            CNORM = '1'
         ENDIF
      ENDIF
      IF( ISNORMM .OR. ISNORMF ) THEN
         JINC = MIN( NDIM, NB )
      ELSE
         JINC = 1
      ENDIF
      JSTART = JA
   10 CONTINUE
      IF( JSTART.LE.JA+N-1 ) THEN
         JEND = MIN( JA+N-1, JSTART+JINC-1 )
         JEND = MAX( JSTART, MIN( JEND, ( JSTART-MOD( JSTART-1,
     $          NB ) )+( NB-1 ) ) )
         JSIZE = JEND - JSTART + 1
         NORMDIAG = ZERO
         NORMOFF = ZERO
         ISMYCOL = ( MYPCOL.EQ.INDXG2P( JSTART, NB, MYPCOL, CSRC,
     $             NPCOL ) )
         IF( ISMYCOL ) THEN
            IADIAG = IA + ( JSTART-JA )
            JADIAG = JA + ( JSTART-JA )
            ISMYROW = ( MYPROW.EQ.INDXG2P( IADIAG, MB, MYPROW, RSRC,
     $                NPROW ) )
            IF( ISMYROW ) THEN
*
*                  Diagonal (triangular) block.
*
               CALL INFOG2LT( UPLO, IADIAG, JADIAG, DESCA, NPROW, NPCOL,
     $                        MYPROW, MYPCOL, LOFFSET, RPROC, CPROC )
               CALL INFOT( UPLO, IADIAG, JADIAG, DESCA, IIA1, JJA1,
     $                     IIA2, JJA2 )
               LDA0 = NUMROC2( IIA2-IIA1+1, IIA1, MB, MYPROW, RSRC,
     $                NPROW )
               LDA = MAX( 1, LDA0 )
               NORMDIAG = CLANSY( CNORM, UPLO, JSIZE, A( LOFFSET ), LDA,
     $                    WORK )
            ENDIF
*
*                Off-diagonal block.
*
            IF( ISUPPER ) THEN
               IASTART = IA
               IAEND = IADIAG - 1
            ELSE
               IF( ISLOWER ) THEN
                  IASTART = IADIAG + JSIZE
                  IAEND = IA + M - 1
               ENDIF
            ENDIF
            MM = IAEND - IASTART + 1
            IF( MM.GE.1 ) THEN
               LMM = NUMROC2( MM, IASTART, MB, MYPROW, RSRC, NPROW )
               IF( LMM.GE.1 ) THEN
                  IFIRST = INDXFIRST( MM, IASTART, MB, MYPROW, RSRC,
     $                     NPROW )
                  CALL INFOG2LT( UPLO, IFIRST, JSTART, DESCA, NPROW,
     $                           NPCOL, MYPROW, MYPCOL, LOFFSET, RPROC,
     $                           CPROC )
                  CALL INFOT( UPLO, IFIRST, JSTART, DESCA, IIA1, JJA1,
     $                        IIA2, JJA2 )
                  LDA0 = NUMROC2( IIA2-IIA1+1, IIA1, MB, MYPROW, RSRC,
     $                   NPROW )
                  LDA = MAX( 1, LDA0 )
                  NORMOFF = CLANGE( CNORM, LMM, JSIZE, A( LOFFSET ),
     $                      LDA, WORK )
               ENDIF
            ENDIF
* end if (mm >= 1)
            IF( ISNORMM ) THEN
               NORMM = MAX( NORMM, MAX( NORMDIAG, NORMOFF ) )
            ELSE
               IF( ISNORMF ) THEN
                  RWORK( 1 ) = NORMOFF
                  RWORK( 2 ) = NORMOFF
                  RWORK( 3 ) = NORMDIAG
                  CALL CLASSQ( 3, RWORK, 1, NORMF_SCALE, NORMF_SUM )
               ENDIF
            ENDIF
         ENDIF
* end if (ismycol)
         JSTART = JEND + 1
         GOTO 10
      ENDIF
   20 CONTINUE
* end while
      IF( ISNORMF ) THEN
         RWORK( 1 ) = NORMF_SCALE
         RWORK( 2 ) = NORMF_SUM
         CALL PSTREECOMB( CONTXT, 'A', 2, RWORK, IAROW, IACOL,
     $                    SCOMBSSQ )
         NORMF_SCALE = RWORK( 1 )
         NORMF_SUM = RWORK( 2 )
         NORMF = NORMF_SCALE*SQRT( NORMF_SUM )
      ELSE
         IF( ISNORMM ) THEN
            RA = 0
            CA = 0
            LDIA = -1
            RDEST = IAROW
            CDEST = IACOL
            CALL SGAMX2D( CONTXT, 'A', ' ', 1, 1, NORMM, 1, RA, CA,
     $                    LDIA, RDEST, CDEST )
         ENDIF
      ENDIF
      VALUE = MAX( NORMI, MAX( NORMF, NORMM ) )
      IF( ( MYPROW.EQ.IAROW ) .AND. ( MYPCOL.EQ.IACOL ) ) THEN
         CALL SGEBS2D( CONTXT, 'All', ' ', 1, 1, VALUE, 1 )
      ELSE
         CALL SGEBR2D( CONTXT, 'All', ' ', 1, 1, VALUE, 1, IAROW,
     $                 IACOL )
      ENDIF
      PCLANHP = ( VALUE )
      RETURN
      END
