      INTEGER          FUNCTION INDXFIRST( N, IA, NB, IPROC, ISRCPROC,
     $                 NPROCS )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*  Purpose
*  =======
*
*  INDXFIRST  computes the first index in ia:(ia+n-1) that
*  is on processor iproc.
*
*  returns ia + n if not found
*
*
*     .. Scalar Arguments ..
      INTEGER            IA, IPROC, ISRCPROC, N, NB, NPROCS
*     ..
*     .. Local Scalars ..
      LOGICAL            FOUND
      INTEGER            GIDX, IFIRST
*     ..
*     .. External Functions ..
      INTEGER            INDXG2P
      EXTERNAL           INDXG2P
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MOD
*     ..
*     .. Executable Statements ..
*
*     The answer is either ia or on the beginning of a block.
*
      FOUND = .false.
      IFIRST = IA + N
      GIDX = IA
   10 CONTINUE
      IF( GIDX.LE.IA+N-1 ) THEN
         FOUND = ( IPROC.EQ.INDXG2P( GIDX, NB, IPROC, ISRCPROC,
     $           NPROCS ) )
         IF( FOUND ) THEN
            IFIRST = GIDX
            GOTO 20
         ENDIF
         GIDX = ( ( GIDX-MOD( GIDX-1, NB ) )+( NB-1 ) ) + 1
         GOTO 10
      ENDIF
   20 CONTINUE
      IF( .NOT.FOUND ) THEN
         IFIRST = IA + N
      ENDIF
      INDXFIRST = ( IFIRST )
      RETURN
      END
