#ifndef DTYPES_H

#define DTYPES_H 1


#if defined(USE_DOUBLE) || defined(USE_REAL) || defined(USE_COMPLEX) || defined(USE_ZCOMPLEX) || (USE_INTEGER)

#else

#define USE_ZCOMPLEX 1

#endif


#if defined(USE_DOUBLE)
#define PSYGVX pdsygvx
#define PSPGVX pdspgvx

#define PSYGST pdsygst
#define PSPGST pdspgst

#define SYMV  dsymv
#define PAXPY pdaxpy
#define PLAMCH pdlamch


#define PPPTRF pdpptrf
#define PPPTRFF pdpptrff
#define PPPTRS pdpptrs
#define PSPRK pdsprk
#define PSPRKF pdsprkf
#define PSPR2K pdspr2k
#define PSPR2KF pdspr2kf


#define GEMV dgemv
#define GEMM dgemm
#define SYR2K dsyr2k
#define SYRK dsyrk
#define SCAL dscal

#define PTRAN pdtran
#define PTRANC PTRAN
#define PTRANU PTRAN

#define PLASCALET pdlascalet
#define PLASCLT pdlasclt
#define PLASCL pdlascl

#define PLANTR pdlantr
#define PLANTP pdlantp
#define PLANSP pdlansp
#define PLANSY  pdlansy 
#define PLANGE  pdlange
#define PLASCHK pdlaschk

#define PLANHP PLANSP

#define LANGE dlange
#define LANSY dlansy
#define LASSQ dlassq
#define TRAPSUM dtrapsum


#define PLACPT pdlacpt
#define PLACPT2 pdlacpt2
#define PLACPT3 pdlacpt3
#define PPOTRFT pdpotrft
#define PPOTRST pdpotrst
#define PPOTRS pdpotrs
#define PTPSM pdtpsm
#define PTPMM pdtpmm
#define PTPMMF pdtpmmf
#define PTRMM pdtrmm

#define PSYRKT pdsyrkt
#define PHERKT PSYRKT

#define PLAMVT pdlamvt
#define PLAMVTF pdlamvtf

#define PSYPMV pdSYPMV
#define PSYPMVF pdSYPMVf
#define PSYMV pdsymv 


#define PLASET pdlaset
#define PLASETT pdlasett
#define PSYEV pdsyev
#define PSPEV pdspev
#define PSYEVX pdsyevx
#define PSPEVX pdspevx


#define PLAMVT2 pdlamvt2
#define PSYTRD pdsytrd
#define PSYTRDT pdsytrdt

#define PSYRKTF pdsyrkTF
#define PSYR2KTF pdsyr2kTF
#define PSYR2KT pdsyr2kT
#define PCOPY pdcopy
#define PSYR2K pdsyr2k

#define DTYPE double precision
#define DTYPE_CAST(x)  dble(x)
#define DTYPE_CAST2(x)  dble(x)

#define FTYPE double precision
#define FTYPE_CAST(x) dble(x)
#define TRANSPOSE_VALUE 'T'

#define LAWRITE dlawrite
#define LAREAD  dlaread

#define PSHIFT pdshift
#define GERV2D dgerv2d
#define GESD2D dgesd2d

#define GEBS2D dgebs2d
#define GEBR2D dgebr2d

#define FGEBS2D dgebs2d
#define FGEBR2D dgebr2d



#define PGEQRF pdgeqrf
#define PLAPIV pdlapiv
#define PGETRS pdgetrs
#define PGETRF pdgetrf
#define PTRSM pdtrsm
#define PSYRK pdsyrk
#define PHERK PSYRK
#define PGEMM pdgemm
#define PHEMM PGEMM
#define PGEMV pdgemv
#define PPOTRF pdpotrf
#define PORMQR pdormqr

#define PELGET pdelget
#define PELSET pdelset
#define PGEMR2DO pdgemr2do
#define PLAPRNT pdlaprnt
#define PLAPRNTT pdlaprntt

#define PSCAL pdscal
#define PMATGEN pdmatgen

#define FPGEMR2D fpdgemr2d



#define COPY dcopy
#define FILL dfill
#define PGTRSM pgdtrsm

#define GSUM2D dgsum2d
#define GAMX2D dgamx2d
#define GAMN2D dgamn2d

#define FSUM2D dgsum2d
#define FAMX2D dgamx2d
#define FAMN2D dgamn2d



#define PFLUSOLVE pfdlusolve
#define PFOCLU pfdoclu
#define PFGETF2 pfdgetf2
#define PFCHFACT pfdchfact
#define PFUCHFACT pfduchfact
#define PFLCHFACT pfdlchfact

#define PFPOTRS	pfdpotrs
#define PFPOTRF	pfdpotrf
#define PFQRAPPLY pfdqrapply
#define PFORMQR pfdormqr

#define PFTRSM pfdtrsm
#define PFLATRSM pfdlatrsm

#define PFGEMM pfdgemm
#define PFGETRF pfdgetrf
#define PFGETRS pfdgetrs
#define PFGELUP pfdgelup
#define PFGEQRF pfdgeqrf
#define PFGEQRS pfdgeqrs
#define PFQRFACT pfdqrfact
#define PFQRFACT2 pfdqrfact2
#define PFCOPYTAU pfdcopytau

#define PFMATGEN pfdmatgen

#define PNRM2 pdnrm2
#define PMATADD pdmatadd

#define PFQRSOLVE pfdqrsolve

#define PFLAPRNT pfdlaprnt
#define PFLAPRNT2 pfdlaprnt2

#elif defined(USE_REAL)
#define PSYGVX pssygvx
#define PSPGVX psspgvx

#define PSPGST psspgst
#define PSYGST pssygst

#define SYMV  ssymv

#define PAXPY psaxpy

#define PLAMCH pslamch

#define PPPTRF pspptrf
#define PPPTRFF pspptrff
#define PPPTRS pspptrs
#define PSPRK pssprk
#define PSPRKF pssprkf
#define PSPR2K psspr2k
#define PSPR2KF psspr2kf



#define GEMV sgemv
#define GEMM sgemm
#define SYR2K ssyr2k
#define SYRK ssyrk
#define SCAL sscal


#define PTRAN pstran
#define PTRANC PTRAN
#define PTRANU PTRAN

#define PLASCALET pslascalet
#define PLASCLT pslasclt

#define PLASCL pslascl

#define PLANTP pslantp
#define PLANTR pslantr
#define PLANSP pslansp
#define PLANSY  pslansy 
#define PLANGE  pslange
#define PLASCHK pslaschk
#define LANGE slange
#define LANSY slansy
#define LASSQ slassq
#define TRAPSUM strapsum


#define PLANHP PLANSP

#define PLACPT pslacpt
#define PLACPT2 pslacpt2
#define PLACPT3 pslacpt3

#define PPOTRFT pspotrft
#define PPOTRST pspotrst
#define PPOTRS pspotrs


#define PTPSM pstpsm
#define PTPMM pstpmm
#define PTPMMF pstpmmf
#define PTRMM pstrmm

#define PSYRKT pssyrkt
#define PHERKT PSYRKT


#define PLAMVT pslamvt
#define PLAMVTF pslamvtf

#define PSYPMV psSYPMV
#define PSYPMVF psSYPMVf
#define PSYMV pssymv

#define PLASET pslaset
#define PLASETT pslasett


#define PSYEV pssyev
#define PSPEV psspev
#define PSYEVX pssyevx
#define PSPEVX psspevx



#define PLAMVT2 pslamvt2

#define PSYTRD pssytrd
#define PSYTRDT pssytrdt

#define PSYRKTF pssyrkTF
#define PSYR2KTF pssyr2kTF
#define PSYR2KT pssyr2kT
#define PCOPY pscopy
#define PSYR2K pssyr2k

#define DTYPE real
#define DTYPE_CAST(x) real(x)
#define DTYPE_CAST2(x)  real(x)


#define FTYPE real
#define FTYPE_CAST(x) real(x)

#define TRANSPOSE_VALUE 'T'

#define LAWRITE slawrite
#define LAREAD  slaread

#define PSHIFT psshift
#define GERV2D sgerv2d
#define GESD2D sgesd2d

#define GEBS2D sgebs2d
#define GEBR2D sgebr2d

#define FGEBS2D sgebs2d
#define FGEBR2D sgebr2d





#define PGEQRF psgeqrf
#define PLAPIV pslapiv
#define PGETRS psgetrs
#define PGETRF psgetrf
#define PTRSM pstrsm
#define PSYRK pssyrk
#define PHERK PSYRK
#define PGEMM psgemm
#define PHEMM PGEMM
#define PGEMV psgemv
#define PPOTRF pspotrf
#define PORMQR psormqr

#define PELGET pselget
#define PELSET pselset
#define PGEMR2DO psgemr2do
#define PLAPRNT pslaprnt
#define PLAPRNTT pslaprntt

#define PSCAL psscal
#define PMATGEN psmatgen



#define FPGEMR2D fpsgemr2d

#define COPY scopy
#define FILL sfill
#define PGTRSM pgstrsm

#define GSUM2D sgsum2d
#define GAMX2D sgamx2d
#define GAMN2D sgamn2d

#define FSUM2D sgsum2d
#define FAMX2D sgamx2d
#define FAMN2D sgamn2d



#define PFLUSOLVE pfslusolve
#define PFOCLU pfsoclu
#define PFGETF2 pfsgetf2

#define PFCHFACT pfschfact
#define PFUCHFACT pfsuchfact
#define PFLCHFACT pfslchfact


#define PFPOTRS	pfspotrs
#define PFPOTRF	pfspotrf
#define PFQRAPPLY pfsqrapply
#define PFORMQR pfsormqr

#define PFTRSM pfstrsm
#define PFLATRSM pfslatrsm

#define PFGEMM pfsgemm
#define PFGETRF pfsgetrf
#define PFGETRS pfsgetrs
#define PFGELUP pfsgelup
#define PFGEQRF pfsgeqrf
#define PFGEQRS pfsgeqrs
#define PFQRFACT pfsqrfact
#define PFQRFACT2 pfsqrfact2
#define PFCOPYTAU pfscopytau


#define PFMATGEN pfsmatgen

#define PNRM2 psnrm2
#define PMATADD psmatadd




#define PFQRSOLVE pfsqrsolve

#define PFLAPRNT pfslaprnt
#define PFLAPRNT2 pfslaprnt2
#elif defined(USE_COMPLEX)
#define PHPGVX pchpgvx
#define PHEGVX pchegvx

#define PHPGST pchpgst
#define PHEGST pchegst

#define CONJG(x)    conjg(x)
#define SYMV  csymv
#define HEMV  chemv

#define HER2K cher2k

#define PAXPY pcaxpy

#define PLAMCH pslamch

#define PHPTRF pchptrf
#define PHPTRFF pchptrff
#define PHPTRS pchptrs
#define PSPRK pcsprk
#define PSPR2K pcspr2k
#define PSPRKF pcsprkf
#define PSPR2KF pcspr2kf
#define PHPRK pchprk
#define PHPR2K pchpr2k
#define PHPRKF pchprkf
#define PHPR2KF pchpr2kf



#define GEMV cgemv
#define GEMM cgemm
#define SYR2K csyr2k
#define SYRK csyrk
#define SCAL cscal
#define HERK cherk


#define PTRANC pctranc
#define PTRANU pctranu

#define PLASCALET pclascalet
#define PLASCLT pclasclt

#define PLASCL pclascl
#define PLANHE pclanhe

#define PLANTP pclantp
#define PLANTR pclantr
#define PLANSP pclansp
#define PLANSY  pclansy 
#define PLANGE  pclange
#define PLASCHK pclaschk

#define PLANHP pclanhp

#define LANGE clange
#define LANSY clansy
#define LASSQ classq
#define TRAPSUM ctrapsum



#define PLACPT pclacpt
#define PLACPT2 pclacpt2
#define PLACPT3 pclacpt3

#define PPOTRFT pcpotrft
#define PPOTRST pcpotrst
#define PPOTRS pcpotrs


#define PTPSM pctpsm
#define PTPMM pctpmm
#define PTPMMF pctpmmf
#define PTRMM pctrmm

#define PHERKT pcherkt


#define PSYRKT pcsyrkt

#define PLAMVT pclamvt
#define PLAMVTF pclamvtf

#define PHPMV pchpmv
#define PHEMV pchemv

#define PLASET pclaset
#define PLASETT pclasett


#define PSYEV pcheev
#define PSPEV pcheevt
#define PSYEVX pcheevx
#define PSPEVX pchpevx

#define PHEEVX pcheevx
#define PHPEVX pchpevx
#define PHEEV pcheev 
#define PHPEV pchpev 

#define PLAMVT2 pclamvt2


#define PSYTRD pcsytrd
#define PSYTRDT pcsytrdt

#define PHERKTF pcherktf
#define PSYRKTF pcsyrkTF
#define PSYR2KTF pcsyr2kTF
#define PSYR2KT pcsyr2kT
#define PCOPY pccopy
#define PSYR2K pcsyr2k

#define REAL_PART(aij) real(aij)
#define IMAG_PART(aij) aimag(aij)

#define DTYPE complex
#define DTYPE_CAST(x) cmplx(real(x))
#define DTYPE_CAST2(x) real(x)

#define FTYPE real
#define FTYPE_CAST(x) real(x)

#define TRANSPOSE_VALUE 'C'

#define LAWRITE clawrite
#define LAREAD  claread

#define PSHIFT pcshift
#define GERV2D cgerv2d
#define GESD2D cgesd2d

#define GEBS2D cgebs2d
#define GEBR2D cgebr2d

#define FGEBS2D sgebs2d
#define FGEBR2D sgebr2d




#define PGEQRF pcgeqrf
#define PLAPIV pclapiv
#define PGETRS pcgetrs
#define PGETRF pcgetrf
#define PTRSM pctrsm
#define PSYRK pcsyrk
#define PHERK pcherk
#define PGEMM pcgemm
#define PHEMM pchemm

#define PGEMV pcgemv
#define PPOTRF pcpotrf
#define PORMQR pcunmqr

#define PELGET pcelget
#define PELSET pcelset
#define PGEMR2DO pcgemr2do
#define PLAPRNT pclaprnt
#define PLAPRNTT pclaprntt

#define PSCAL pcscal
#define PMATGEN pcmatgen

#define PFLUSOLVE pfclusolve
#define PFOCLU pfcoclu
#define PFGETF2 pfcgetf2

#define PFCHFACT pfcchfact
#define PFUCHFACT pfcuchfact
#define PFLCHFACT pfclchfact

#define PFPOTRS	pfcpotrs
#define PFPOTRF	pfcpotrf
#define PFQRAPPLY pfcqrapply
#define PFORMQR pfcunmqr
#define PFTRSM pfctrsm
#define PFLATRSM pfclatrsm

#define PFGEMM pfcgemm
#define PFGETRF pfcgetrf
#define PFGETRS pfcgetrs
#define PFGELUP pfcgelup
#define PFGEQRF pfcgeqrf
#define PFGEQRS pfcgeqrs
#define PFQRFACT pfcqrfact
#define PFQRFACT2 pfcqrfact2
#define PFCOPYTAU pfccopytau

#define PFMATGEN pfcmatgen

#define PNRM2 pscnrm2
#define PMATADD pcmatadd



#define FPGEMR2D fpcgemr2d

#define COPY ccopy
#define FILL cfill
#define PGTRSM pgctrsm

#define GSUM2D cgsum2d
#define GAMX2D cgamx2d
#define GAMN2D cgamn2d

#define FSUM2D sgsum2d
#define FAMX2D sgamx2d
#define FAMN2D sgamn2d



#define PFQRSOLVE pfcqrsolve

#define PFLAPRNT pfclaprnt
#define PFLAPRNT2 pfclaprnt2
#elif defined(USE_ZCOMPLEX)
#define PHPGVX pzhpgvx
#define PHEGVX pzhegvx

#define PHPGST pzhpgst
#define PHEGST pzhegst

#define CONJG(x)   dconjg(x)
#define SYMV  zsymv
#define HEMV  zhemv

#define HER2K zher2k

#define PAXPY pzaxpy

#define PLAMCH pdlamch

#define PHPTRF pzhptrf
#define PHPTRFF pzhptrff
#define PHPTRS pzhptrs
#define PSPRK pzsprk
#define PSPR2K pzspr2k
#define PSPRKF pzsprkf
#define PSPR2KF pzspr2kf
#define PHPRK pzhprk
#define PHPR2K pzhpr2k
#define PHPRKF pzhprkf
#define PHPR2KF pzhpr2kf


#define GEMV zgemv
#define GEMM zgemm
#define SYR2K zsyr2k
#define SYRK zsyrk
#define SCAL zscal
#define HERK  zherk


#define PTRANU pztranu
#define PTRANC pztranc

#define PLASCALET pzlascalet
#define PLASCLT pzlasclt

#define PLASCL pzlascl

#define PLANHE pzlanhe

#define PLANTP pzlantp
#define PLANTR pzlantr
#define PLANSP pzlansp
#define PLANSY  pzlansy 
#define PLANGE  pzlange
#define PLASCHK pzlaschk
#define LANGE zlange
#define LANSY zlansy
#define LASSQ zlassq
#define TRAPSUM ztrapsum


#define PLANHP pzlanhp

#define PLACPT pzlacpt
#define PLACPT2 pzlacpt2
#define PLACPT3 pzlacpt3

#define PPOTRFT pzpotrft
#define PPOTRST pzpotrst
#define PPOTRS pzpotrs

#define PTPSM pztpsm
#define PTPMM pztpmm
#define PTPMMF pztpmmf
#define PTRMM pztrmm

#define PHERKT pzherkt

#define PSYRKT pzsyrkt

#define PLAMVT pzlamvt
#define PLAMVTF pzlamvtf


#define PHPMV pzhpmv
#define PHEMV pzhemv

#define PLASET pzlaset
#define PLASETT pzlasett


#define PSYEV pzheev
#define PSPEV pzheevt
#define PSYEVX pzheevx
#define PSPEVX pzhpevx

#define PHEEVX pzheevx
#define PHPEVX pzhpevx
#define PHEEV  pzheev 
#define PHPEV  pzhpev 

#define PLAMVT2 pzlamvt2

#define PSYTRD pzsytrd
#define PSYTRDT pzsytrdt

#define PHERKTF pzherktf
#define PSYRKTF pzsyrkTF
#define PSYR2KTF pzsyr2kTF
#define PSYR2KT pzsyr2kT
#define PCOPY pzcopy
#define PSYR2K pzsyr2k

#define REAL_PART(aij) dble(aij)
#define IMAG_PART(aij) dimag(aij)


#define DTYPE complex*16
#define DTYPE_CAST(x) dcmplx(dble(x))
#define DTYPE_CAST2(x) dble(x)


#define FTYPE double precision
#define FTYPE_CAST(x) dble(x)

#define TRANSPOSE_VALUE 'C'

#define LAWRITE zlawrite
#define LAREAD  zlaread

#define PSHIFT pzshift
#define GERV2D zgerv2d
#define GESD2D zgesd2d

#define GEBS2D zgebs2d
#define GEBR2D zgebr2d

#define FGEBS2D dgebs2d
#define FGEBR2D dgebr2d




#define PGEQRF pzgeqrf
#define PLAPIV pzlapiv
#define PGETRS pzgetrs
#define PGETRF pzgetrf
#define PTRSM pztrsm
#define PSYRK pzsyrk
#define PHERK pzherk
#define PGEMM pzgemm
#define PHEMM pzhemm

#define PGEMV pzgemv
#define PPOTRF pzpotrf
#define PORMQR pzunmqr

#define PELGET pzelget
#define PELSET pzelset
#define PGEMR2DO pzgemr2do
#define PLAPRNT pzlaprnt
#define PLAPRNTT pzlaprntt

#define PSCAL pzscal
#define PMATGEN pzmatgen

#define FPGEMR2D fpzgemr2d

#define COPY zcopy
#define FILL zfill
#define PGTRSM pgztrsm

#define GSUM2D zgsum2d
#define GAMX2D zgamx2d
#define GAMN2D zgamn2d

#define FSUM2D dgsum2d
#define FAMX2D dgamx2d
#define FAMN2D dgamn2d




#define PFLUSOLVE pfzlusolve
#define PFOCLU pfzoclu
#define PFGETF2 pfzgetf2

#define PFCHFACT pfzchfact
#define PFUCHFACT pfzuchfact
#define PFLCHFACT pfzlchfact

#define PFPOTRS	pfzpotrs
#define PFPOTRF	pfzpotrf
#define PFQRAPPLY pfzqrapply
#define PFORMQR pfzunmqr
#define PFTRSM pfztrsm
#define PFLATRSM pfzlatrsm

#define PFGEMM pfzgemm
#define PFGETRF pfzgetrf
#define PFGETRS pfzgetrs
#define PFGELUP pfzgelup
#define PFGEQRF pfzgeqrf
#define PFGEQRS pfzgeqrs
#define PFQRFACT pfzqrfact
#define PFQRFACT2 pfzqrfact2
#define PFCOPYTAU pfzcopytau

#define PFMATGEN pfzmatgen

#define PNRM2 pdznrm2
#define PMATADD pzmatadd

#define PFQRSOLVE pfzqrsolve

#define PFLAPRNT pfzlaprnt
#define PFLAPRNT2 pfzlaprnt2
#elif USE_INTEGER
#define DTYPE integer
#define FTYPE integer
#define FPGEMR2D fpigemr2d
#define COPY icopy
#define FILL ifill

#define PSHIFT pishift
#define GESD2D igesd2d
#define GERV2D igerv2d

#define GEBS2D igebs2d
#define GEBR2D igebr2d

#define PGEMR2DO pigemr2do

#define DTYPE_CAST(x)  int(x)

#endif


#endif
