#include "parpre_pc.h"
#include "petsc.h"
#include "src/sles/pc/pcimpl.h"          /*I   "pc.h"   I*/

extern int PCCreate_AddSchwarz(PC);
extern int PCCreate_MulSchwarz(PC);
extern int PCCreate_GBSSOR(PC);
extern int PCCreate_DomainDecomp(PC);
extern int PCCreate_MLevel(PC);

extern int PCCreate_mILU(PC);

#undef __FUNC__  
#define __FUNC__ "PCRegisterParPre"
/*@C
  PCRegisterParPre:
  register additional preconditioner routines defined in ParPre

.keywords: PC, register, all

.seealso: PCRegister(), PCRegisterDestroy()
@*/
int PCRegisterParPre(char *path)
{
  int ierr;

  PetscFunctionBegin;

  ierr = PCRegister(PCAdditiveSchwarz       ,path,  "PCCreate_AddSchwarz",PCCreate_AddSchwarz); CHKERRQ(ierr);
  ierr = PCRegister(PCMultiplicativeSchwarz ,path,  "PCCreate_MulSchwarz",PCCreate_MulSchwarz); CHKERRQ(ierr);
  ierr = PCRegister(PCGenBlockSSOR          ,path,  "PCCreate_GBSSOR",PCCreate_GBSSOR); CHKERRQ(ierr);
  ierr = PCRegister(PCDomainDecomp          ,path,  "PCCreate_DomainDecomp",PCCreate_DomainDecomp); CHKERRQ(ierr);
  ierr = PCRegister(PCMultiLevel            ,path,  "PCCreate_MLevel",PCCreate_MLevel); CHKERRQ(ierr);
  ierr = PCRegister(PCmILU                  ,path,  "PCCreate_mILU",PCCreate_mILU); CHKERRQ(ierr);

  PetscFunctionReturn(0);
}

