#include "src/sles/pc/pcimpl.h"      /*I "pc.h" I*/
#include "petscsles.h"
#include "petsc.h"
#include <stdio.h>
#include "petscsys.h"
#include "petscoptions.h"
#include "src/vec/vecimpl.h"                     /*I "vec.h" I*/
#include "parpre_subdomains.h"

extern int PCRegisterParPre(char *path);
extern int ParPreVecsInit();
extern int ParPreBlockVecInit();
extern int ParPreDenseInit();
extern int ParPreDomainDecompInit();

int ParPreInitializedCalled = 0;
int PetscInitializedThroughParPre = 0;

#if defined(USE_DYNAMIC_LIBRARIES)
extern DLLibraryList DLLibrariesLoaded;
#endif

/****************************************************************
 **************** ParPre Setup and such
 ****************************************************************/
#undef __FUNC__
#define __FUNC__ "ParPreInitialize"
/*@
  ParPreInitialize - initialise use of the ParPre library

  Parameters as for PetscInitialize.

  This routine will perform PetscInitialize, if that has not
  been done explicitly.
  @*/
int ParPreInitialize(int*argv,char***argc,char*p1,char*p2)
{
  int ierr;

  if (!PetscInitializeCalled) {
    PetscInitializedThroughParPre = 1;
    ierr = PetscInitialize(argv,argc,p1,p2); CHKERRQ(ierr);
  }

  if (!ParPreInitializedCalled) {
#if defined(USE_DYNAMIC_LIBRARIES)
    char libs[256];
#endif
    ParPreInitializedCalled = 1;

    ierr = OptionsSetValue("-mat_mpi",0); CHKERRQ(ierr);
#if defined(USE_DYNAMIC_LIBRARIES)
    ierr = PetscStrcpy(libs,PETSC_LDIR);CHKERRQ(ierr);
    ierr = PetscStrcat(libs,"/libparpresles"); CHKERRQ(ierr);
    ierr = DLLibraryAppend(PETSC_COMM_WORLD,&DLLibrariesLoaded,libs);
    CHKERRQ(ierr);
    ierr = PetscStrcpy(libs,PETSC_LDIR);CHKERRQ(ierr);
    ierr = PetscStrcat(libs,"/libparpremat"); CHKERRQ(ierr);
    ierr = DLLibraryAppend(PETSC_COMM_WORLD,&DLLibrariesLoaded,libs);
    CHKERRQ(ierr);
    ierr = PetscStrcpy(libs,PETSC_LDIR);CHKERRQ(ierr);
    ierr = PetscStrcat(libs,"/libparprevec"); CHKERRQ(ierr);
    ierr = DLLibraryAppend(PETSC_COMM_WORLD,&DLLibrariesLoaded,libs);
    CHKERRQ(ierr);
    ierr = PetscStrcpy(libs,PETSC_LDIR);CHKERRQ(ierr);
    ierr = PetscStrcat(libs,"/libparpresys"); CHKERRQ(ierr);
    ierr = DLLibraryAppend(PETSC_COMM_WORLD,&DLLibrariesLoaded,libs);
    CHKERRQ(ierr);
#endif

    /* register events and such */
    ierr = ParPreVecsInit(); CHKERRQ(ierr);
    ierr = ParPreBlockVecInit(); CHKERRQ(ierr);
    ierr = ParPreDenseInit(); CHKERRQ(ierr);
    ierr =  ParPreDomainDecompInit(); CHKERRQ(ierr);
    ierr = PCRegisterParPre(PETSC_NULL); CHKERRQ(ierr);
  }

  return 0;
}

#undef __FUNC__
#define __FUNC__ "ParPreFinalize"
/*@
  ParPreFinalize - end use of the ParPre library

  No parameters, as for PetscFinalize.

  This routine will perform PetscFinalize, if that has not
  been done explicitly.
  @*/
int ParPreFinalize()
{
  int ierr;
  if (PetscInitializedThroughParPre) {
    ierr = PetscFinalize(); CHKERRQ(ierr);}
  return 0;
}

#undef __FUNC__
#define __FUNC__ "ParPreSetup"
/*@
  ParPreSetup - set up a ParPre preconditioner

  Parameters:
+ comm - an MPI communicator
. A - the coefficient matrix
- B - the preconditioner

  This is basically the sequence PCSetOperators, MatGetLocalSize, VecCreateMPI,
  PCSetVector, PCSetFromOptions, PCSetUp.
@*/
int ParPreSetup(MPI_Comm comm,Mat A,PC B)
{
  Vec pc_vec;
  int ierr,lsize,idum;

  ierr = PCSetOperators(B,A,A,(MatStructure)0); CHKERRQ(ierr);
  ierr = MatGetLocalSize(A,&lsize,&idum); CHKERRQ(ierr);
  ierr = VecCreateMPI(comm,lsize,PETSC_DECIDE,&pc_vec); CHKERRQ(ierr);
  ierr = PCSetVector(B,pc_vec); CHKERRQ(ierr);
  ierr = PCSetFromOptions(B); CHKERRQ(ierr);
  ierr = PCSetUp(B); CHKERRQ(ierr);

  return 0;
}
