#include "parpre_pc.h"
#include "./ml_head.h"

int ViewIndices(MC_OneLevel_struct *level,Viewer viewer)
{
  int ierr;

  PetscPrintf(level->comm,"First block of indices of level %d:\n",level->level);
  ierr = ISView(level->indices1,viewer); CHKERRQ(ierr);
  if ((int) level->next_level) {
    ierr = ViewIndices(level->next_level,viewer); CHKERRQ(ierr);
  } else {
    PetscPrintf(level->comm,"Indices of deepest level:\n");
    ierr = ISView(level->indices2,viewer); CHKERRQ(ierr);
  }

  return 0;
}

#undef __FUNC__
#define __FUNC__ "ViewLevel"
int ViewLevel(MC_OneLevel_struct *level,Viewer viewer)
{
  MPI_Comm comm = level->comm;
  int i,ierr;

  PetscFunctionBegin;
  PetscPrintf(comm,"== Level %d ==\n",level->level);
  PetscPrintf(comm,"A11 solver\n");
  ierr = SLESView(level->a11_solve,viewer); CHKERRQ(ierr);
  if (level->degree>1) {
    PetscPrintf(comm,"Generalised W-cycle degree %d;\n coefficients:",
		level->degree);
    for (i=0; i<=level->degree; i++)
      PetscPrintf(comm," %e",-level->coffs[i]);
    PetscPrintf(comm,"\n");
  }
  if (level->next_level) {
    ierr = ViewLevel(level->next_level,viewer); CHKERRQ(ierr);
  } else {
    PetscPrintf(comm,"== Last level ==\n");
    ierr = SLESView(level->a22_solve,viewer); CHKERRQ(ierr);
  }
  PetscFunctionReturn(0);
}
