#ifndef __PARPRE_VEC_PACKAGE 
#define __PARPRE_VEC_PACKAGE
#include "petscpc.h"
#include "petscmat.h"
#include "petscvec.h"
#include "petscsys.h"
#include "petscviewer.h"

typedef enum 
{PETSC_NOT_SET_VALUES, PETSC_INSERT_VALUES, 
 PETSC_ADD_VALUES, PETSC_MAX_VALUES} ParPreInsertMode;

typedef enum
{GRAM_SCHMIDT, MOD_GRAM_SCHMIDT, GRAM_SCHMIDT_TWICE} QRMethod;

typedef enum
{DOT_REAL=0, DOT_COMPLEX=1, DOT_DIAGONAL=0, DOT_FULL} DotType;

/* combined dot product routines */
typedef struct _p_DotProducts* DotProducts;
typedef struct _p_BlockVec* BlockVec;
typedef int DPRequest;

extern int DotProductsCreate(MPI_Comm comm,int size,DotProducts *dp);
extern int DotProductsDestroy(DotProducts dp);
extern int DotProductsSet(DotProducts dp,Vec x,Vec y);
extern int DotProductsSetT(DotProducts dp,Vec x,Vec y);
extern int DotProductsGet(DotProducts dp,Scalar *r);
extern int DotProductsClear(DotProducts dp);
extern int DotProductsSetFull(DotProducts dp);
extern int DotProductsSetDiagonal(DotProducts dp);
extern int DotProductsGetMat(DotProducts dp,Mat *mat);
extern int DotProductsRestoreMat(DotProducts dp,Mat *mat);
extern int DotProductsGetDiagonal(DotProducts dp,Vec *v);
extern int DotProductsAssemblyBegin(DotProducts dp);
extern int DotProductsAssemblyEnd(DotProducts dp);

/* block vector routines */
extern int BlockVecCreateMPI(MPI_Comm comm,int nv,int n,int N,BlockVec *bv);
extern int BlockVecDestroy(BlockVec v);
extern int BlockVecCopy(BlockVec bi,BlockVec bo);
extern int BlockVecGetArray(BlockVec v,Scalar **a);
extern int BlockVecRestoreArray(BlockVec v,Scalar **a);
extern int BlockVecGetVec(BlockVec v,int i,Vec *vv);
extern int BlockVecRestoreVec(BlockVec v,int i,Vec *vv);
extern int BlockVecGetLocalSize(BlockVec v,int *i,int *j);
extern int BlockVecGetOwnershipRange(BlockVec v,int *first,int *last);
extern int BlockVecOrthogonalise(BlockVec v,MatReuse use,Mat *u,QRMethod m);
extern int BlockVecTOrthogonalise(BlockVec v,MatReuse use,Mat *u,QRMethod m);
extern int BlockVecBiOrthogonalise(BlockVec w,BlockVec v,
				   MatReuse use,Mat *u,QRMethod meth);
extern int BlockVecTBiOrthogonalise(BlockVec w,BlockVec v,
				    MatReuse use,Mat *u,QRMethod meth);
extern int BlockVec2Vecs(BlockVec vi,int n,Vec *vo);
extern int Vecs2BlockVec(Vec *vi,int n,BlockVec vo);
extern int BlockVecAXPY(Mat a,BlockVec u,BlockVec v);
extern int BlockVecAYPX(Mat a,char *trans,BlockVec u,BlockVec v,BlockVec t);
extern int BlockVecAuYPX(Mat a,char *trans,BlockVec u,BlockVec v);
extern int BlockVecMatMult(Mat A,BlockVec bi,BlockVec bo);
extern int BlockVecPCApply(PC M,BlockVec bi,BlockVec bo);
extern int BlockVecScale(Mat a,char *trans,BlockVec u,BlockVec v);
extern int BlockVecDot(BlockVec v1,BlockVec v2,MatReuse use,Mat *u);
extern int BlockVecTDot(BlockVec v1,BlockVec v2,MatReuse use,Mat *u);
extern int BlockVecDot_O(char *trans,BlockVec v1,BlockVec v2,
			 MatReuse use,Mat *u,Scalar *t,DotProducts dp);
extern int BlockVecNormalise(BlockVec v,MatReuse use,Mat *u);
extern int BlockVecBiNormalise(BlockVec v,BlockVec w,MatReuse use,Mat *u);
extern int BlockVecView(BlockVec b,Viewer vw);

extern int VecsOrthogonalise(MPI_Comm comm,Vec *vecs,int n,
			     MatReuse use,Mat *u,QRMethod m);
extern int VecsCopy(Vec *ivecs,Vec *ovecs,int n);
extern int VecsScale(Mat a,Vec *vecs,int n);
extern int VecsAXPY(Mat a,Vec *x,Vec *y,int n);
extern int VecsAYPX(Mat a,Vec *x,Vec *y,int n);
extern int VecsMatProd(Mat A,Vec *ivecs,Vec *ovecs,int n);
extern int VecsPCApply(PC M,Vec *ivecs,Vec *ovecs,int n);
extern int VecsDot(MPI_Comm comm,Vec *vecs1,Vec *vecs2,int n,
		   MatReuse use,Mat *u);
extern int VecsDot_O(MPI_Comm comm,Vec *vecs1,Vec *vecs2,int n,
		     MatReuse use,Mat *u,DotProducts dp);
extern int VecsSet(Scalar *x,Vec *vecs,int n);

#endif
