/* additions to pc.h for the parpre routines */

#if !defined(__PARPRE_PC_PACKAGE)
#define __PARPRE_PC_PACKAGE

#include "parpre_vec.h"
#include "petscpc.h"
#include "petscsles.h"

#define PCAdditiveSchwarz        "aschwarz"
#define PCMultiplicativeSchwarz  "mschwarz"
#define PCGenBlockSSOR           "gbssor"
#define PCDomainDecomp           "ddecomp"
#define PCMultiLevel             "mlevel"

#define PCmILU                   "milu"

extern int ParPreSetup(MPI_Comm comm,Mat A,PC B);
extern int PCIsParallel(PC);
extern int PCHasType(PC pc,PCType type,int *flag);
extern int PCParallelGetLocalSLES(PC pc,SLES *local_sles);
extern int PCParallelGetLocalPC(PC pc,PC *local_pc);

/* fill-in restriction; used in multilevel and gbssor */
typedef enum {FillNone=1, FillDiag=2, FillStrong=3,
	      FillFull=4 } FillMethod;

/* schwarz methods */
extern int PCIsSchwarzMethod(PC pc);
extern int PCSchwarzSetHaloSize(PC,int);
extern int PCSchwarzGetIndices(PC pc,IS *is);

/* generalised block ssor */
extern int PCGenBlockSSORSetGlobalFactorisation(PC pc);
extern int PCGenBlockSSORSetNoGlobalFactorisation(PC pc);

/* domain decomposition */
extern int PCDomainDecompGetInterfaceSLES(PC pc,SLES *intsles);
extern int PCDomainDecompGetInterfacePC(PC pc,PC *local_pc);
extern int PCDomainDecompGetInterfaceMat(PC pc,Mat *intmat);
extern int PCDomainDecompGetInterfaceIS(PC pc,IS *intis);
extern int PCDomainDecompSetWidth(PC pc,int w);

/* multilevel */
typedef enum {AMLFillNone=1, AMLFillDiag=2, AMLFillStrong=3,
	      AMLFillFull=4 } AMLFillMethod;
extern int AMLSetFillMethod(PC pc,AMLFillMethod fill_method);

typedef enum {AMLSolveMG=1, AMLSolvePolynomial=2,
	      AMLSolveILU=3} AMLSolveScheme;
extern int AMLSetSolutionScheme(PC pc,AMLSolveScheme solve_scheme);

typedef enum {AMLCoarseGridDependent=1,
	      AMLCoarseGridIndependent=2} AMLCoarseGridChoice;
extern int AMLSetCoarseGridDependent(PC pc);
extern int AMLSetCoarseGridIndependent(PC pc);

typedef enum {AMLSchurElimination=1,AMLSchurVariational=2} AMLSchurChoice;
extern int AMLSetSchurElimination(PC pc);
extern int AMLSetSchurVariational(PC pc);

typedef enum {AMLSmoothNone=1, AMLPreSmooth=2, AMLPostSmooth=3, 
	      AMLPrePostSmooth=4} AMLSmootherChoice;

extern int AMLSet11PCType(PC pc,PCType local_pctype);
extern int AMLSetCutoffSize(PC pc,int siz);
extern int AMLSetStrongRatio(PC pc,double weight);
extern int AMLSet11JacobiIterations(PC pc,int it);
extern int AMLSetSmootherChoice(PC pc,AMLSmootherChoice smoother);
extern int AMLSetCycleDegree(PC pc,int deg);
extern int AMLSetISFromStrong(PC pc);
extern int AMLSetISFromOriginal(PC pc);
extern int AMLSetModification(PC pc,int mod);

extern int AMLSetTraceLevel(PC pc,int lev);
typedef enum {AMLTraceProgress=1,AMLTraceColours=2,AMLTraceIndexSets=4,
	      AMLTraceFill=8} AMLTraceLevel;

typedef enum {AMLModScale=1, AMLModDiag=2} AMLMod;

/* undocumented aml functions */
extern int AMLSetTransfer(PC pc);
extern int AMLSetNoTransfer(PC pc);
extern int AMLSetPivotRepair(PC pc,int rep);
extern int AMLorth(PC pc);

/* Manteuffel ILU */
extern int PCmILUSetBaseType(PC pc,PCType type);
extern int PCmILUSetLevels(PC pc,int levels);
extern int PCmILUGetBasePC(PC pc,PC *base_pc);

/* Generally useful defs */
#define VSAVSF ADD_VALUES,SCATTER_FORWARD
#define VSIVSF INSERT_VALUES,SCATTER_FORWARD
#define VecScatterFor(a,b,c,e) \
    VecScatterBegin(a,b,c,SCATTER_FORWARD,e); CHKERRQ(ierr); \
    VecScatterEnd  (a,b,c,SCATTER_FORWARD,e); CHKERRQ(ierr);

#endif
