#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  PCType pc_name = PCMultiplicativeSchwarz;
  int mytid,ierr;

  MPI_Comm_rank(comm,&mytid);

  if (!mytid) printf("Setting up Multiplicative Schwarz pc %d\n",
		     (int)pc_name);
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);

  /* parametrised setting over overlap */
  ierr = PCSchwarzSetHaloSize(the_pc,1); CHKERRQ(ierr);

  /* Declare global communication scheme */
  ierr = PCParallelSubdomainPipelineSetType
    (the_pc,PIPELINE_SEQUENTIAL,(PetscObject)PETSC_NULL);

  /* Declare local solve */
  {
    PC local_pc;
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    PCSetType(local_pc,PCLU); CHKERRQ(ierr);
    /* set the local solve to SSOR, 10 iterations */
    /*PCSetType(local_pc,PCSOR); CHKERRQ(ierr);
      PCSORSetSymmetric(local_pc, SOR_SYMMETRIC_SWEEP); CHKERRQ(ierr);
      PCSORSetIterations(local_pc,10); CHKERRQ(ierr);*/
  }

  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  return 0;
}

