/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_d_seps.h"
d_number(	graph_seps_list_v,
		max_graphs,
		sep_numbers,
		start_numbers,
		end_numbers,
		new_numbers,
		new_graph_numbers,
		separator_list,
		index_separator_list,
		count_separator_list,
		scratch_start,
		scratch_end,
		coords_list,
		total_sep_size)

int        	*graph_seps_list_v,
		max_graphs,
		*sep_numbers,
		*start_numbers,
		*end_numbers,
		*new_numbers,
		*new_graph_numbers,
		*separator_list,
		*index_separator_list,
		*count_separator_list,
		*scratch_start,
		*scratch_end,
		*coords_list,
		*total_sep_size;
		
	
{
			int field_size, i, grf, i_limit,old_grf,
				new_max_graphs;
		
			field_size=4;
			count_up_halves(
				graph_seps_list_v,
				new_graph_numbers,
				separator_list,
				index_separator_list,
				count_separator_list,
				coords_list,
				deleted_v);
			size_seps (
				separator_list,
				index_separator_list,
				count_separator_list,
				max_graphs, 
				s_vector, field_size, 3,
				deleted_v);

			set_to(k_vector,(field_size*max_graphs),0);

			for(i=grf=0, i_limit= 
				field_size*max_graphs;
				i<i_limit; i+=field_size, grf+=2){
				k_vector[i]= s_vector[i] = my_pid;
				s_vector[i+1]=new_graph_numbers[grf];
				s_vector[i+2]=new_graph_numbers[grf+1];
			}
			arg_int[PARAM1] = k_vector;
			arg_int[PARAM2] = &field_size;	
			arg_int[PARAM3] = &max_graphs;	
			size_s_vector= size_r_vector=
				 size_k_vector = i_limit;
/*
cascade list field:
block_id lower(left) half count upper(right) half count sep count
*/

			dimensional_exchange(
					r_vector,
					&size_r_vector,
					&max_size_r_vector,
		                        s_vector,
					&size_s_vector,
					log_2_P,
					LS,
					(MSG_TYPE),
					processor_list,
					(cascade),
					arg_int,
					NULL);
			MSG_TYPE += log_2_P+1;
			for(i=grf=old_grf=0, i_limit= 
				field_size*max_graphs;
				i<i_limit; i+=field_size, grf+=2, old_grf++){
				new_graph_numbers[grf] = s_vector[i+1];
				new_graph_numbers[grf+1] = s_vector[i+2];
				total_sep_size[old_grf] = s_vector[i+3];
				if (total_sep_size[old_grf] > 0)
				sep_numbers[old_grf] = 
					end_numbers[old_grf]
						 - k_vector[i+3];
			}
			d_tree_stuff(
					new_graph_numbers,
					end_numbers, 
					total_sep_size);
						/* set up tree chains etc*/

		new_max_graphs = 
			 	assign_new_numbers( 
                         	max_graphs, field_size,
				sep_numbers,
						/*sep numbers*/
               			start_numbers, end_numbers, 
				new_numbers,
				total_sep_size,
				new_graph_numbers,
				separator_list,
				index_separator_list,
				count_separator_list,
				scratch_start,
				scratch_end);

			if( new_max_graphs != 2*max_graphs) exit_err(
			"d_dissect:not twice as many pieces2",not_twice);
return(new_max_graphs);
}/*end d_number*/
d_update_lists(
		graph_seps_list_ce,
		new_max_graphs,
		max_graphs,
		coords_list,
		new_graph_numbers,
		separator_list,
		index_separator_list,
		count_separator_list)
int
		*graph_seps_list_ce,
		new_max_graphs,
		max_graphs,
		*coords_list,
		*new_graph_numbers,
		*separator_list,
		*index_separator_list,
		*count_separator_list;
{

			set_col_map(	max_graphs,
	    				separator_list,
					index_separator_list,
					count_separator_list,
					new_numbers);
			d_phase_procs_update(max_graphs, d_scratch_list);
		
			l_update_lists (new_max_graphs,
					graph_seps_list_ce,
					coords_list,
					new_graph_numbers,
					separator_list,
					index_separator_list,
					count_separator_list);

			if ( new_max_graphs == P) d_phase =0;


}/*end d_update_lists*/
d_tree_stuff(
		new_graph_numbers,
		end_numbers, 
		total_sep_size)
int
		*new_graph_numbers,
		*end_numbers, 
		*total_sep_size;
{
			int i,j,k, count;
			extern	int old_my_graph_number,
					old_1, old_2, old_3, old_4;
		
			i = my_graph_number;

					/*the tree stuff*/
	
			chain_index[tree_size] = last_chain_index;
			for ( k= end_numbers[i] - total_sep_size[i]+1,
				old_3=k,
				j=last_chain_index, count =
						total_sep_size[i]; count >0;
							count--,k++,j++)
					tree_chains[j] = k; 
			old_1 = last_chain_index;
			old_2 = total_sep_size[i];
			old_4 = tree_chains[j-1];

			last_chain_index += total_sep_size[i];	
			tree_start_procs[d_tree_next] = start_proc;
			tree_end_procs[d_tree_next] = start_proc+
							(count_proc)-1;
			tree_count_procs[d_tree_next] =  count_proc;
			d_tree_next--;
			if ((my_pid >= start_proc) && (my_pid < (start_proc
					+(count_proc/2)))){
			start_proc = start_proc ;
			end_proc = start_proc + count_proc/2 -1;;
			old_my_graph_number = my_graph_number;
			my_graph_number = i*2;
			}else{
			start_proc = start_proc + (count_proc/2);
			end_proc = start_proc + count_proc/2 -1;;
			old_my_graph_number = my_graph_number;
			my_graph_number = i*2+1;
			}

			if(new_graph_numbers[my_graph_number]==0)
				exit_err("d_tree_stuffx","not_twice");

			count_proc = count_proc/2;
			tree_parent[tree_size] =parent_number;
			parent_number= tree_size;
			tree_size++;
}/*end d_tree_stuff*/
set_col_map(	max_graphs,
	    	vtx_list,
		index_vtx_list,
		count_vtx_list,
		new_numbers)
int		max_graphs,
		*vtx_list,
		*index_vtx_list,
		*count_vtx_list,
		*new_numbers;
{
		int i, j, proc , count, j_count,  start;
	  
			for (i=0; i <max_graphs; i++){
				start = start_procs[i];
				count = count_procs[i];
				for (j= index_vtx_list[i], 
				j_count = count_vtx_list[i];
					j_count>0; j_count--, j++){

					proc = new_numbers[vtx_list[j]] % count+
						start;
					if (col_map[vtx_list[j]] == EMPTY){
					col_map[vtx_list[j]] = proc;	
					color[vtx_list[j]] = last_color;
					}
					else 
					vtx_list[j] = EMPTY;

				}	
			}	
		last_color+=1;
}/*set_col_map*/
d_phase_procs_update(max_graphs, scratch_list)
int	max_graphs, *scratch_list;
{

			int i,j, count, start;
			for (i=j=0; i <max_graphs; i++){
				scratch_list[j++] = start_procs[i];	
				scratch_list[j++] = count_procs[i];	
			}
			for (i=j=0; i <max_graphs; i++){
				start = scratch_list[j];
				count = scratch_list[j+1];
				if (count >1){
					start_procs[j] = start;
					count_procs[j] = count/2;
					start_procs[j+1] = start +count/2;
					count_procs[j+1] = count/2;
				}
				j+=2;
						
			}
}/* end d_phase_procs_update*/
d_number_etc(used, 
		d_seps_list,
		graph_seps_list_ce,
		graph_seps_list_v,
		separator_list,
		index_separator_list,
		count_separator_list,
		max_graphs)

int	used,	
		*d_seps_list,
		*graph_seps_list_ce,
		*graph_seps_list_v,
		*separator_list,
		*index_separator_list,
		*count_separator_list,
		max_graphs;
			
{

		int	new_max_graphs, *scratch_start, 
			*new_graph_numbers,	*scratch_end,
			*total_sep_size, 
			*sep_numbers,
			*coords_list;
		int	now_graphs;

		scratch_start = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs;
		scratch_end= scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs;
		new_graph_numbers = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += 2*max_graphs;
		total_sep_size = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs;
		coords_list = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs; 
		sep_numbers = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs; 

		now_graphs = max_graphs;

		new_max_graphs =
				d_number(
				d_seps_list,
				max_graphs,
				sep_numbers,
				start_numbers,
				end_numbers,
				new_numbers,
				new_graph_numbers,
				separator_list,
				index_separator_list,
				count_separator_list,
				scratch_start,
				scratch_end,
				coords_list,
				total_sep_size);
		d_update_lists(
				d_seps_list,
				new_max_graphs,
				max_graphs,
				coords_list,
				new_graph_numbers,
				separator_list,
				index_separator_list,
				count_separator_list);
		d_gather(
				k_vector,
				separator_list,
				index_separator_list,
				count_separator_list,
				total_sep_size,
				now_graphs);
		MSG_TYPE += log_2_P+1;

}/*end d_number_etc*/
d_gather(	
		my_start_pos,
		separator_list,
		index_separator_list,
		count_separator_list,
		total_sep_size,
		now_graphs)
int
		*my_start_pos,
		*separator_list,
		*index_separator_list,
		*count_separator_list,
		*total_sep_size,
		now_graphs;
{
		
		get_global_col( separator_list,
				index_separator_list,
				count_separator_list,
				s_vector,
				&size_s_vector,
				total_sep_size,
				my_start_pos,
				now_graphs);
		size_r_vector = size_s_vector;
		dimensional_exchange(
					r_vector,
					&size_r_vector,
					&max_size_r_vector,
		                        s_vector,
					&size_s_vector,
					log_2_P,
					LS,
					(MSG_TYPE),
					processor_list,
					(do_union),
					NULL,
					NULL);
		MSG_TYPE += log_2_P+1;
		modify_numbers(s_vector, size_s_vector, k_vector, r_vector);
}/*end d_gather*/
