/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_defs.h"
#include	"o_d.h"
extern		int fanin_accumulate(), split_accumulate();
int		(*accumulate) ();
d_order()
{
		extern	double	clock0(), stats[];
		double	last_clock;
		extern	int P;
		int	message_increment;
		

		if (P >16) {
				accumulate = split_accumulate;
				message_increment = log_2_P +1;
		}
		else {
				accumulate = fanin_accumulate;
				message_increment = P +1;
		}
		last_clock = clock0();
		for (MSG_TYPE=1; d_phase ==1; ){
	
				d_find_dissection_coords(message_increment);
				
				d_dissect(d_graph_seps_list, 
					graph_seps_list_ce,
					graph_seps_list_v,
					d_scratch_list, max_graphs);
						
		}
		stats[o_d_t] = clock0() - last_clock;
}/* end d_order*/
d_find_dissection_coords(msg_incr)
int			msg_incr;
{
		int dim, field_size;
		extern int my_graph_number, Asubs, P;
		



		for (field_size = 2*D+1,
			dim=0; dim < D; dim++){
			make_count_lists(		
				dim,	vtx_counts[dim], 
				size_vtx_counts+dim,
				max_size_vtx_counts[dim],
				beta_counts,
				&size_beta_counts, 
				max_size_beta_counts,
				eps_counts, 
				&size_eps_counts,
				max_size_eps_counts);


			(*accumulate) (
				vtx_counts[dim],
				size_vtx_counts+dim,
				beta_counts,
				&size_beta_counts, 
				max_size_beta_counts,
				eps_counts, 
				&size_eps_counts,
				max_size_eps_counts, dim);
				
			make_kappa_counts(	
				beta_counts,
				&size_beta_counts, 
				max_size_beta_counts,
				eps_counts, 
				&size_eps_counts,
				max_size_eps_counts,
				kappa_counts[dim],	
				size_kappa_counts+dim,
				max_size_kappa_counts[dim]);
			MSG_TYPE += msg_incr;

		}



		cascade_gather(vtx_counts,
				size_vtx_counts,
				kappa_counts,
				size_kappa_counts,
				max_graphs);
		MSG_TYPE += log_2_P +1;
			

		for (dim=0; dim < D; dim++){
			augment_and_set_levels(         
				d_scratch_list+last_used_in_d_scratch_list,
				vtx_counts[dim],
                                size_vtx_counts[dim], max_graphs,
                                graph_bounds, 2,
                                k_vector, s_vector,
                                alpha,
                                field_size, 2*dim+1);

					
			find_min_eta_coords( 
				kappa_counts[dim],	
				size_kappa_counts[dim],
				vtx_counts[dim],
                                size_vtx_counts[dim], 
				d_graph_seps_list, 
				max_graphs, 3, dim,	
		  		graph_bounds,2) ;
		}

		min_gather(d_graph_seps_list, max_graphs);
		MSG_TYPE += log_2_P +1;
		if (MSGLVL >= TRACE_2)
		print_vec(dbgfile,d_graph_seps_list, 0, 3*max_graphs,
					"d_graph-seps-list");
}

d_dissect(d_seps_list, graph_seps_list_ce,
		graph_seps_list_v,
		d_scratch_list, max_graphs)
int		*d_seps_list,	*graph_seps_list_ce,
		*graph_seps_list_v,
		*d_scratch_list,	max_graphs;
{
		int used,	*separator_list,
				*index_separator_list,
				*count_separator_list, now_graphs;
		extern		int 	pad_code,
					*pad_list, last_used_in_scratch_list;


		now_graphs= max_graphs;
		last_used_in_d_scratch_list =0;
		last_used_in_scratch_list =0;
		replace_by_local_coords(d_seps_list, 
					graph_seps_list_ce, 
					graph_seps_list_v,
					d_scratch_list, max_graphs,
					&pad_code,
					pad_list);

		
		used = make_local_seps(
					graph_seps_list_ce, 
					graph_seps_list_v,
					&separator_list,
					&index_separator_list,
					&count_separator_list,
					pad_code,
					pad_list);


		d_number_etc(	used,
				d_seps_list,
				graph_seps_list_ce, 
				graph_seps_list_v,
				separator_list,
				index_separator_list,
				count_separator_list,
				max_graphs);
		last_used_in_d_scratch_list =0;
		last_used_in_scratch_list =0;
		update_region_limits(region_limits, 
			now_graphs, d_scratch_list, 
			max_size_d_scratch_list,
			d_seps_list);
					
}/*end d_dissect*/

replace_by_local_coords(global_seps_list, 
			local_seps_list_ce, 
			local_seps_list_v, 
			scratch_list, max_graphs, pad_code, pad_list)
int		*global_seps_list,	*local_seps_list_ce,
		*local_seps_list_v,
		*scratch_list,		max_graphs,
		*pad_code,	*pad_list;
{

	int dim,  *coords_list, *index_list, *global_lvls,
		i_g, i_l, g_l,  grf, limits,
		i, j, lvl,
		 limit, max_global_coord;

	coords_list = scratch_list + max_graphs+1;
	index_list = coords_list + max_graphs+1;

	for(dim=0; dim <D; dim++){
		make_coords_list(global_seps_list,
				max_graphs,
				3,
				dim,
				coords_list,
				&max_global_coord);
		if (max_global_coord != EMPTY){
		quick_sort(max_graphs,index_list,coords_list);	
		global_lvls = global_levels[dim];
		limits 	    =	*( limits_int[dim] +1);
			for (i_g=i_l=0; i_g < max_graphs; i_g++){
				g_l = coords_list[index_list[i_g]];
				grf = index_list[i_g];
				if (g_l != EMPTY) {
					for(; ((global_lvls[i_l] < g_l) 
					&& (i_l <limits)); )
							i_l++;
					grf = 3*grf;

					if (i_l == limits) {
					local_seps_list_v[
					grf] = 
					local_seps_list_ce[
					grf] = global_seps_list[grf];
					local_seps_list_v[
					grf+2] = 
					local_seps_list_ce[
					grf+2] = global_seps_list[grf+2];
					local_seps_list_v[
					grf+1] = -1 ; 
					local_seps_list_ce[
					grf+1] = -1 ; 
					} else {
					
					local_seps_list_v[
					grf] = 
					local_seps_list_ce[
					grf] = global_seps_list[grf];
					local_seps_list_v[
					grf+2] = 
					local_seps_list_ce[
					grf+2] = global_seps_list[grf+2];
					local_seps_list_v[
					grf+1] =i_l ; 
					if ((i_l >0)
					 	&& (global_lvls[i_l] >
						g_l)) i_l--;
					local_seps_list_ce[
					grf+1] =i_l ; 
					}
				}
			}
		}
	}/*outer for*/

	for(i=j=0; i < max_graphs; i++) {
			dim = global_seps_list[j];
			lvl = local_seps_list_v[j+1];
			if (lvl != EMPTY) {
			if (
				(*(global_levels[dim]+lvl))
				!= global_seps_list[j+1]) 
					local_seps_list_v[j+1] = EMPTY;
			}

			lvl = local_seps_list_ce[j+1];
			if (lvl != EMPTY) {
			if ( (*(global_levels[dim]+lvl))
				< global_seps_list[j+1]) 
				pad_list[i] =1;
			}
			else  {
				pad_list[i] = 0;
			}
			j+=3;
	}
	for(i=0; i <max_graphs; i++)
		*pad_code +=pad_list[i];
	if (*pad_code > 0) *pad_code =1;
}/*end*/
update_region_limits(region_limits, now_graphs, scratch_list, list_limits,
			d_seps_list)
int		*region_limits, now_graphs, *scratch_list, list_limits,
		*d_seps_list;
{

		int d2, i, j, k, k_count, l, dim, lvl;
		d2 = D*2;
		
		if ((now_graphs*d2) > list_limits)
			exit_err("update_region_limits",case_err);
		copy(now_graphs*d2,1,region_limits,1,scratch_list);

		for (i=j=0; i <now_graphs; i++) {
		
			dim= d_seps_list[j];
			lvl = d_seps_list[j+1];
			j +=3;
			for (k=i*d2,l = 2*i*d2,
				 k_count = d2; k_count >0; k_count--){
				region_limits[l] =
					region_limits[l+d2] = scratch_list[k];
				k++; l++;
			}
			l = 2*i*d2;
			region_limits[l+2*dim+1] = lvl;
			region_limits[l+2*dim+d2] = lvl+1;
		}
}
