/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	<stdio.h>
#define	real_type		float
#include	"map.h"
extern	int	             tipe;
exit_err(message, code)
char	*message;
int	code;
{
	if (code == malloc_err)
	printf("\n Out of memory: exiting\n");
	else if (code ==fopen_err)
		printf("\nError Opening file:%s, exiting\n");
		else if (code == int_err1) {
		printf("\nInternal error: please e-mail padma, exiting\n");
		}
	exit();

				 
}

part_mesh(	file_stem, D, N, Asubs, P, 
		block_labels, 
		count_vtxs,
		count_edges, map, 
		map_edges, edges, 
		x_int, y_int, z_int,
		x, y, z, a_nonz, b)
char		*file_stem;
int		D, N, Asubs, P, **block_labels, 
		*count_vtxs, 
		*count_edges, *map, 
		*map_edges, *edges, 
		*x_int, *y_int, *z_int;
float		*x, *y, *z, *a_nonz, *b; 
{

		int *local, *done,i,j, next, proc, count,
			check_N, check_Asubs, extra_vtxs[128];

		if ((local= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err();
		if ((done= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err();
		
		for(i=0; i < N; i++) {
			done[i] = -1;
		}
		
		for (proc=check_N= check_Asubs=0; 
				proc <P; proc++) {
			count_vtxs[proc] =0;
			for (next=0; next <N; next++){
				if (map[next] == proc){
				local[next] = count_vtxs[proc];
				count_vtxs[proc] += 1;
				} else local[next] = -1;
			}
		
			extra_vtxs[proc] = count_vtxs[proc];
			for (next=count=0; count < Asubs; count++) {
				if ( map_edges[count] == proc) {
				i = edges[next];
				j = edges[next+1];
					if (local[i] == -1) {
						local[i] = extra_vtxs[proc];
						extra_vtxs[proc] += 1;
					}
					if (local[j] == -1) {
						local[j] = extra_vtxs[proc];
						extra_vtxs[proc] += 1;
					}
				}
				next+=2;
			}

				
			print_stuff(file_stem,
					D, N, Asubs, P, block_labels,
					proc, map, map_edges, edges, local,
					count_vtxs[proc],
					extra_vtxs[proc],
					count_edges[proc],x_int,y_int,
					z_int, 
					x, y, z, done, a_nonz,b);
			check_N += count_vtxs[proc];
			check_Asubs += count_edges[proc];
		}
	
			
	if (check_N != N)
			 exit_err("check_N", int_err1);
	if (check_Asubs != Asubs) 
			exit_err("check_Asubs", int_err1);
	free (((char *) local));
	free (((char *) done));
		
}/*part_mesh*/	
print_stuff(	file_stem,
		D, N, 	Asubs, 	P,  block_labels,
		proc, 	map,	 map_edges, edges, local,
		count_vtxs, 	extra_vtxs,
		count_edges,	
		x_int,	y_int,	z_int,	
		x,	y,	z, 	
		done,a_nonz,real_b)
char		*file_stem;

int		D, N, Asubs,	P,  **block_labels,  proc, 
		*map, 	*map_edges, *edges, *local,
		count_vtxs,	 extra_vtxs, 	count_edges, 
		*x_int,*y_int, *done,	*z_int;
float		*x, *y, *z,	*a_nonz, *real_b;
{
			
		FILE	*fp_nonz,  *fp_xyz_int;
		int 	i, j,a, b, dim;
		char	in_file[80];
		sprintf(in_file, "%s.xyz_int.%-d",file_stem, proc);
        	if ((fp_xyz_int=fopen(in_file,"w")) == NULL)
                        		exit_err("main",proc);
		sprintf(in_file, "%s.nonz.%-d",file_stem, proc);
        	if ((fp_nonz=fopen(in_file,"w")) == NULL)
                       	 		 exit_err("main",proc);
		fprintf(fp_xyz_int,"%d %d %d \n", N, N, Asubs);
		fprintf(fp_xyz_int,"%d %d %d \n", extra_vtxs,
						 extra_vtxs,
						count_edges);
		fprintf(fp_xyz_int,
				"%d %d %d %d\n", P, D, 1, count_vtxs);
		for (dim=0; dim < D; dim++) {
				for (j =0; j <P+1; j++)
					fprintf(fp_xyz_int,
					"%d ",*(block_labels[dim] +j));
			
				fprintf(fp_xyz_int, "\n");
		}

		for (i=0; i <N; i++) {
			if ((map[i] == proc) && (local[i] < count_vtxs))				{
				if ( D==2) {
				fprintf(fp_xyz_int, "%10d %10d %10d\n",
					i,
					x_int[i], y_int[i]);
				} else {

				fprintf(fp_xyz_int, "%10d %10d %10d %10d\n",
					i,
					x_int[i], y_int[i], z_int[i]);

				}
				done[i] = proc;
			}
		}	


		for (i=j=0; i <Asubs; i++) {
				if (map_edges[i] == proc){
				a= edges[j];
				b= edges[j+1];
				if (done[a] != proc) {
				if (D==2) {
				fprintf(fp_xyz_int,"%10d %10d %10d\n",
				edges[j],
				x_int[a],y_int[a]);
				} else {
				fprintf(fp_xyz_int,"%10d %10d %10d %10d\n",
				edges[j],
				x_int[a],y_int[a], z_int[a]);
				}
				done[a] = proc;
				}
				if (done[b] != proc) {
				if (D==2) {
				fprintf(fp_xyz_int,"%10d %10d %10d\n",
				edges[j+1],
				x_int[b],y_int[b]);
				} else {	
				fprintf(fp_xyz_int,"%10d %10d %10d %10d\n",
				edges[j+1],
				x_int[b],y_int[b], z_int[b]);
				}
				done[b] = proc;
				}	
				}	
				j+=2;	
		
		}

		for (i=j=0; i <Asubs; i++) {
				if (map_edges[i] == proc){
				fprintf(fp_nonz,
					"%d %d %6.2f \n", edges[j], edges[j+1],
							 a_nonz[i]); 
				fprintf(fp_xyz_int,
					"%d %d \n", local[edges[j]], 
							local[edges[j+1]]); 
				
				}
				j+=2;
		}
		for (i=0; i<N; i++){
		if ((map[i] == proc) && (local[i] < count_vtxs))				{
				fprintf(fp_nonz,
					"%6.2f \n",real_b[i] ); 
		}
		}

		fclose(fp_xyz_int);
		fclose(fp_nonz);
						
}/*print_stuff*/

heap_sort(
		count,	
		field_size, 
              	key_list,	
		real_key_list,
		sorted_indices) 
int		count,
		field_size,
		*key_list,
		*sorted_indices;
real_type	*real_key_list;

/*
	key_list has fields of size field_size;
		the first value in a field is the key;
	sorted_indices contains field_numbers in sorted order on the key

	key_list can be put in sorted order by permuting according to 
	sorted_indices
	
*/
{


		int 	arg_err,	i, 	last;
		
		for(i=0; i <count; i++)
			*(sorted_indices+i) = i;
		
		for(last= count-1, i= count-2; i >=0; i --)
			heapify (field_size, key_list, real_key_list,
				sorted_indices, i, last); 
		
		for(i=last; i >=1;) {
			swap(sorted_indices+i, sorted_indices);
			i--;
			heapify(field_size, key_list, real_key_list,
					sorted_indices, 0, i);
		} 
}/*end heap_sort*/
						
heapify(	field_size,	key_list,	real_key_list,
		index_list,	i,	j)
int		field_size,	*key_list, 	*index_list,
		i,	j;	
real_type	*real_key_list;
{

		int	k1, k2, k, do_it;
		k1 = 2*i+1;
		k2 = 2*i+2;
		if  ( (k1 <= j) && (k2 <=j)) {
			if (real_key_list== NULL) {
				if (field_size ==1) 
                		k = (key_list[(index_list[k1]*field_size)] >
                                key_list[(index_list[k2]*field_size)])? 
				k1 : k2;
				else
               			k = ((key_list[(index_list[k1]*field_size)] >
                                key_list[(index_list[k2]*field_size)])
				|| (
                		(key_list[(index_list[k1]*field_size)] == 
                                key_list[(index_list[k2]*field_size)])
				&&  
                		(key_list[(index_list[k1]*field_size+1)] >= 
                                key_list[(index_list[k2]*field_size+1)])
				)) ? k1 : k2;
			}	
			else {
				if (field_size ==1) 
                		k = (real_key_list[(index_list[k1]*
					field_size)] >
                                real_key_list[(index_list[k2]*field_size)])? 
				k1 : k2;
				else
               			k = ((real_key_list[(index_list[k1]*
					field_size)] >
                                real_key_list[(index_list[k2]*field_size)])
				|| (
                		(real_key_list[(index_list[k1]*field_size)] == 
                                real_key_list[(index_list[k2]*field_size)])
				&&  
                		(real_key_list[(index_list[k1]*field_size+1)] 
				>= real_key_list[(index_list[k2]*field_size+1)])
				)) ? k1 : k2;
			}
		} else if ( k1 <= j) k = k1 ;
                else k= -1;

		if (k >=0) {
			do_it =0;
			if ( key_list != NULL) {
			do_it =
			 ((key_list[(index_list[i]*field_size)] <=
				key_list[(index_list[k]*field_size)]));
			
			if (( do_it ) && ( field_size >1) &&
				( (key_list[(index_list[i]*field_size)] ==
				key_list[(index_list[k]*field_size)])))
				do_it = (do_it) && 
			 	((key_list[(index_list[i]*field_size+1)] <
				key_list[(index_list[k]*field_size+1)]));
			} else {
			do_it =
			 ((real_key_list[(index_list[i]*field_size)] <=
				real_key_list[(index_list[k]*field_size)]));
			if (( do_it ) && ( field_size >1) &&
				( (real_key_list[(index_list[i]*field_size)] ==
				real_key_list[(index_list[k]*field_size)])))
				do_it = (do_it) && 
			 	((real_key_list[(index_list[i]*field_size+1)] <
				real_key_list[(index_list[k]*field_size+1)]));

			}	
			if (do_it) {
				swap(index_list+i, index_list+k);

		

				heapify(field_size,	
					key_list,	
					real_key_list,	
					index_list,	
					k,	j);
			}	
		} 
}/*end heapify_int*/
		 
swap( a,	b)
int	*a, *b;
{
		int tmp;
		tmp = *a;
		*a = *b;
		*b = tmp;
}
make_A_b(N, Asubs, edges, a_nonz,b)
int	N, Asubs, *edges;
float 	*a_nonz, *b;
{


		int i, j, c,d;
		
		for (i=0; i <N; i++)
				b[i] = 0.0;
		for (i=j=0; i <Asubs; i++) {
				c = edges[j++];
				d = edges[j++];
				if (c != d){
					a_nonz[i] = -1.0;
					b[c] += 1.0;
					b[d] += 1.0;
				}
		}
		for (i=j=0; i <Asubs; i++) {
				c = edges[j++];
				d = edges[j++];
				if (c==d) 
					a_nonz[i] = b[c] +1.0;	
		}
		for (i=0; i <N; i++)
				b[i] = 1.0;
}



