/**If number of coords is less than procs .. generate dummy coords **/


/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	<stdio.h>
#include	"map.h"
coord_data_main(file_stem,	file_in, T,  P, diagonals, decr)
char		*file_stem, *file_in;
int		T, P, diagonals, decr;
{

/*
 * expects a data file (named file_stem) of the form:
  |V| |E| D   
  |V| D tuples representing x,y,z coords, (D=2,3)
  |E| pairs representing edges
 * if diagonals - then edges of the form i,i are in the file;
   else the routine adds them
 * in the data file vtxs are assumed numbered i through N iff decr=1
   in our format they are numbered 0-N-1
*/




		int	N, D, E, Asubs, count_vtxs[MAX_P], 
			i,j, dim, per_proc, rem, next, proc,
			count_edges[MAX_P], *block_labels[MAX_DIMS],
			max_dim[MAX_DIMS], 
			*map, *map_edges, *edges, *tmp_count,
			*x_int,*y_int, *z_int;
		float	*x, *y, *z, *a_nonz, *b;	
		extern	int	gen_data;
		FILE	*fp_in;

                if ((fp_in=fopen(file_in,"r")) == NULL)
                                        exit_err("file_stem",fopen_err);

		fscanf(fp_in, "%d %d %d", &N, &E, &D);

		if ((map= (int *) malloc(((E) * sizeof(int))))
					== NULL) exit_err("map",malloc_err);
		if ((map_edges= (int *) malloc(((E+N) * sizeof(int))))
					== NULL) 
					exit_err("map_edges",malloc_err);
		if ((edges= (int *) malloc(((2*E+2*N) * sizeof(int))))
					== NULL) exit_err("edges",malloc_err);
		if ((x= (float *) malloc(((N) * sizeof(float))))
					== NULL) exit_err("x", malloc_err);
		if ((x_int= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err("x_int",malloc_err);
		if ((y= (float *) malloc(((N) * sizeof(float))))
					== NULL) exit_err("y", malloc_err);
		if ((y_int= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err("y_int", malloc_err);
		if (D>2) {
		if ((z= (float *) malloc(((N) * sizeof(float))))
					== NULL) exit_err("z",malloc_err);
		if ((z_int= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err("z_int",malloc_err);
		}
		if ((b= (float *) malloc(((N) * sizeof(float))))
					== NULL) exit_err("b",malloc_err);
		if ((gen_data ==1) && (diagonals ==0)){
		if ((a_nonz= (float *) malloc(((E+N) * sizeof(float))))
					== NULL) exit_err("a_nonz",exit_err);
		}
		else 
		if ((a_nonz= (float *) malloc(((E) * sizeof(float))))
					== NULL) exit_err("a_nonz",exit_err);

		for (i=0; i <N; i++ ) {
			if (D==2) fscanf(fp_in, "%f %f",
					x+i, y+i);
			else	fscanf(fp_in, "%f %f %f",
					x+i, y+i, z+i);
		}
		for (i=j=0; i <E; i++ ) {
			
			if(gen_data ==1)
			fscanf(fp_in, "%d %d",
					(edges+j),(edges+j+1));
			else
			fscanf(fp_in, "%d %d %f",
					(edges+j),(edges+j+1), (a_nonz+i));
			if (edges[j] > edges[j+1]) {
				next = edges[j];
				edges[j] = edges[j+1];
				edges[j+1] = next;
			}
			if (decr) {
				edges[j++] --;
				edges[j++] --;
				
			} else j+=2;
		}
		if(gen_data !=1){
			for (i=0; i <N; i++)
			fscanf(fp_in, "%f", (b+i));
		}

		integerize(N, D, max_dim, 
				x_int, y_int, z_int,
				x,y,z);
				



		if (diagonals==1) Asubs = E;
		else { 
				for (i=2*E,j=0; j < N; j++){
					edges[i++] =j;
					edges[i++] =j;
				}
			Asubs = E +N;
		}

		for (dim=0; dim <D; dim ++){
			per_proc = max_dim[dim] / P; 
			rem = max_dim[dim] %P;
			if(per_proc < 1) {
				per_proc =1;
				rem = 0;
			}
			next =0;	
			if ((block_labels[dim] =
				(int *) malloc(((P+1) * sizeof(int))))
					== NULL) exit_err("block_labels",
						malloc_err);
			for (proc=0; proc < P; proc++) {
				*(block_labels[dim] +proc) = next;		
				next += per_proc;
				if (proc <rem) next++;
			}
			*(block_labels[dim] + proc) = next;
/*
			if ( next != max_dim[dim]) exit_err ("internal_err1",
						int_err1);
*/
		}
		
	
		for (i=0; i <N; i++) {
					proc = i%P;
					map[i] = proc;
		}
		for (i=0; i <P; i++)  count_edges[i] =0;
		for (i=j=0; j <Asubs; i+=2, j++) {
				map_edges[j] = proc= map[edges[i]];
				count_edges[proc] +=1;
		}
						
		if (gen_data ==1)
		make_A_b(N, Asubs, edges, a_nonz,b);
		part_mesh(file_stem,
			D, N,	Asubs, P, block_labels, 
				count_vtxs, count_edges, map, map_edges, 
				edges,
				x_int, y_int, z_int,
				x, y, z,a_nonz,b);
}/*end_coord_data_main*/
integerize(	N, 
		D, max_dim, x_int,	y_int,
		z_int, x, y, z)
int	N, D, *max_dim,
	*x_int,	*y_int,	*z_int;
float	*x, *y, *z;
{

		int dim, *coords_int[3], *sorted;
		float	*coords[3];

		if ((sorted= (int *) malloc(((N) * sizeof(int))))
					== NULL) exit_err("sorted",malloc_err);
		coords_int[0] =x_int; coords[0] =x;
		coords_int[1] =y_int; coords[1] =y;
		coords_int[2] =z_int; coords[2] =z;
		for (dim=0; dim <D; dim++){
			max_dim[dim] = sort_and_squeeze(
					N, sorted,
				 coords_int[dim], coords[dim]);
		}
						 
}/*end integerize*/
sort_and_squeeze(count, sorted, list_int, list)
int		count, *list_int, *sorted;
float		*list;
{
		int i, last;
		float	a,b;
		double diff;
		heap_sort( count,	
				1,
				NULL,
              			list,	
				sorted);
		
		for (i=1,last=0, a = list[sorted[0]]; i < count; i++){
			b = list[sorted[i]];
			diff = (double) (a-b);
			diff = fabs(diff);
			if (diff >EPS) {
				list_int[sorted[i]] = ++last;
			} else list_int[sorted[i]] = last;
			a = b;
		}
		return(last+1);
}/*end sort_and_squeeze*/
print_vec( pfp, vec,    begin,          count,          msg)
int     *vec,   begin,  count;
char    *msg;
FILE    *pfp;
{
                int     i;
                fprintf(pfp,"%s:", msg);
                for (i = begin; count >0 ; count--, i++)
                {
                        fprintf(pfp, "%d ", *(vec+i));
                        if ((count % 20 ) == 0)
                                        fprintf(pfp,"\n");
                }
                fprintf(pfp,"\n");
}

print_vec_float( pfp,   vec,    begin,          count, msg)
int     begin,  count;
char    *msg;
float   *vec;
FILE    *pfp;
{
                int     i;
                fprintf(pfp,"%s:", msg);
                for (i = begin; count >0 ; count--, i++)
                {
                        fprintf(pfp, "%.4f ", *(vec+i));
                }
                fprintf(pfp,"\n");
}

