/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_defs.h"
extern		int	my_pid, P;
/*    
a dimensional exchange with different operations
routine does the operations and its arguments are arg_int and arg_real
*/

dimensional_exchange (
			r_vector,
			size_r_vector,
			max_size_r_vector,

			s_vector,
			size_s_vector,

			log_2_P,
			ms_ls_type,
			msg_type_param,	
			processor_list,

			routine,
			arg_int,
			arg_real)

char			*r_vector,
			*s_vector;
int			*size_r_vector,

						/* that which is  received 
						in each pass 		
						size_r_vector : meaningful
						number of bytes*/
									       
			*max_size_r_vector,
						/* the allocated size in bytes
						  of r_vector	*/

			
			*size_s_vector,
						/* that which is to be sent 
						in each pass 		
						size_s_vector : meaningful
						number of bytes*/
								        

			log_2_P,

			ms_ls_type,		/* parameter used to set 
						  processor communication
						  sequence;
						 example:
						 == LS, procs 
							0-1, 2-3, 4-5, 6-7
						      	0-2, 1-3, 4-6, 5-7
						 	0-4, 1-5, 2-6, 3-7

						 == MS, procs 
							0-4, 1-5, 2-6, 3-7
						      	0-2, 1-3, 4-6, 5-7
						        0-1, 2-3, 4-5, 6-7
						 use LS type with
							for cascade type ops
						 use MS type with
							for split+cat type ops
						 union/min/add:: works with either
						*/
								

			msg_type_param,
			            		/* used to generate msg
						type (id)		*/
			*processor_list,
			
			(*routine) (),	 	/*processing routine 	*/

			**arg_int;
real_type		**arg_real;
			       			/*parameters to routine	*/
{


			unsigned	to_do,		no_more;
			int		info_bytes, 	info_type,
					info_from;



			for (	to_do = (ms_ls_type == MS) ?
					(1 << (log_2_P -1)) :1,
				no_more = (ms_ls_type == MS) ?
					0:  (1 << log_2_P);

				 (to_do != no_more);
					to_do =  (ms_ls_type == MS) ? 
						 (to_do >>1) : (to_do << 1)
						)	
			{
				send0 (
					((char *)(s_vector )),

					((int)(sizeof(int) *
					 (*size_s_vector))),

					((int)	(get_msg_type(my_pid^to_do,
							to_do, 
							msg_type_param))),

					((int)(processor_list[(my_pid ^ to_do)])));

				recv0 (
					((char *) (r_vector)),

					((int) (sizeof(int))*(*max_size_r_vector)),

					((int)(get_msg_type((my_pid),
							to_do, 
							msg_type_param))));


				recvinfo0(
						&info_bytes,
						&info_type,
						&info_from);


				if ( (info_type != (get_msg_type((my_pid ),
								  to_do,
								  msg_type_param)))
					|| (info_from != 
						processor_list[(my_pid^to_do)]))
				{
		
					printf(
					"%d:Error: from: %d-%d, type %d-%d\n",
					my_pid, processor_list[(my_pid^to_do)],
						info_from,
				               	 (get_msg_type((my_pid ),
							  	to_do,
							  	msg_type_param)),
								info_type);
					exit_err("d_exchange",int_err3);
				}
				else *size_r_vector =
						info_bytes/ (sizeof(int));
						


				(*routine) (	r_vector,
						size_r_vector,
						max_size_r_vector,
						s_vector,
					 	size_s_vector,
						arg_int,
						arg_real);

			} /*for*/
}/*end dimensional exchange */



get_msg_type(	from_proc,
		bit_pos, 
		msg_type_param) 

int		from_proc,
		bit_pos, 
		msg_type_param;
			
{
			return(((msg_type_param+ bit_pos)));

}/*end get_msg_type*/

