/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	<stdio.h>
#include	"s_defs.h"
extern		int	 me;
print_link_vec(file_p,tmp_list, tmp_size, msg)
FILE    *file_p;
int     *tmp_list,       tmp_size;
char    *msg ;
{

                int     i, count;

                fprintf(file_p,"%s\n",msg);
                for(count=i=0; count < tmp_size; ) {
                        fprintf(file_p,"%d ", tmp_list[i]);
                        count++;
                        i = tmp_list[i+1] ;
                        if ((count %20) == 0) fprintf(file_p, "\n");

                }
                fprintf(file_p, "\n");
}/*end print_link_vec */

merge_int_lists(cut_off,	
		into_list,		into_list_size,
		from_list,		from_list_size,
		type_of_lists)

int		cut_off,
		*into_list,	*into_list_size,
		*from_list,	from_list_size,
		type_of_lists;
{

		int	buffer,		last_link,
			into_next,	from_next,		
			into_done,	from_done,	given_into_list_size;
		
		for(into_next= from_next= into_done = buffer= from_done = 
					last_link=0 ,
			given_into_list_size= *into_list_size;
			(from_done < from_list_size) &&
				(into_done < given_into_list_size);
					)
		{
			if ( from_list[from_next] < cut_off)
			{
				if (type_of_lists == LINK_and_NOT_LINK)
							from_next++;
				else from_next = from_list[from_next+1];
				last_link = into_next;
				buffer = into_next;
				from_done++;
			} else if ( from_list[from_next] < into_list[into_next])
				{
				into_list[buffer+1] = 2* (*into_list_size);
				into_list[2*(*into_list_size)] =
						from_list[from_next] ;
				into_list[2*(*into_list_size)+1] = into_next;
				last_link = into_list[buffer+1] ; 
				buffer =  last_link;
				*into_list_size += 1;
				if (type_of_lists == LINK_and_NOT_LINK)
						from_next++;
				else from_next = from_list[from_next+1];
				from_done++;
				}else if  (into_list[into_next] <
					from_list[from_next])
					{	
					last_link = into_next;
					buffer = into_next;
					into_next = into_list[into_next+1];
					into_done++;
					}
					else {

						into_done++; from_done++;
						last_link = into_next;
						buffer = into_next;
						into_next = 
						into_list[into_next+1];
						
						if (type_of_lists ==
							 LINK_and_NOT_LINK)
								from_next++;
						else from_next = 
							from_list[from_next+1];
					}
		}
		for (into_next = last_link; 
				from_done < from_list_size;
					from_done++)
		{
			if ( from_list[from_next] < cut_off)
			{
				if (type_of_lists == LINK_and_NOT_LINK)
							from_next++;
				else from_next = from_list[from_next+1];
			}
			else {
					into_list[into_next+1] = 
					2* (*into_list_size);

					into_list[2*(*into_list_size)] =
						from_list[from_next] ;
					into_list[2*(*into_list_size)+1] = -1;

					into_next = 2* (*into_list_size);
					*into_list_size += 1;
					if (type_of_lists == LINK_and_NOT_LINK)
						from_next++;
					else from_next = from_list[from_next+1];
			}
		}
}/*end merge_int_lists*/
		
convert_from_links_and_copy(	into_list,
				into_list_size,	
				from_list,	
				from_list_size)

int		*into_list,	*into_list_size,
		*from_list,	from_list_size;
{

		int	into_next, from_next, from_done;

		for(from_done=from_next= into_next=0; 
			from_done < from_list_size; from_done++)
		{
			into_list[into_next] = from_list[from_next] ;
			into_next++;
			from_next = from_list[from_next+1];
		}
		*into_list_size = into_next;
}/*end convert_from_links_and_copy*/
		
		
		
remove_duplicates(list, list_size)
int		*list,	*list_size;
{

		int i, removed, last_seen, count, previous;


		for (last_seen= list[0], previous =0, i =list[1], 
			count=1, removed =0 ;
				count < *list_size; count++)
		{
			if ( list[i] == last_seen)
			{
				
				list[previous+1] = list[i+1];
				removed++;
			}
			else { previous = i ;
				last_seen = list[i];
				}
			i= list[i+1] ;
		}
		*list_size -= removed;
}

check_and_realloc (	list,	max_list_size,
			list_size, to_be_added_size)
int			**list, *max_list_size,
			list_size, to_be_added_size;
{

		int	 need, *tmp_ptr, i, *list_ptr;

		need = list_size + to_be_added_size +1;
		if (*max_list_size < need)
		{

/*
			printf("%d: in check-reallocing %d, %d %d %d\n",
				me, list_size, to_be_added_size, need,
				*max_list_size);
*/
			if ((
			tmp_ptr = (int *) malloc(( need*int_size))) == NULL)
				exit_err( "check_and_realloc", malloc_err);
				/*copy */

			for (i=0, list_ptr = *list; i <list_size; i++)
				tmp_ptr[i] = list_ptr[i];

			free (((char *) *list));

			*list = tmp_ptr;  
			*max_list_size= need;
		}
}/*end check_and_realloc*/

local_structure_spd(current,
		child,
		tree_chains,
		chain_index,
		local_column,
		index_list)

int		current,
		child,
		*tree_chains,
		*chain_index,
		*local_column,
		*index_list;
{




		extern int		*a_index,	*a_struc,
		**factor_struc,	*factor_struc_sizes, 
		*send_vector,	send_vector_size, max_send_vector_size,
		*tmp_list,	tmp_list_size,  max_tmp_list_size;


			extern	int *a_size, N;
	

		tmp_list_size =0 ;

			

                check_and_realloc
                                (&tmp_list, &max_tmp_list_size,
                                2*tmp_list_size,
                                (2* (chain_index[current+1] -
					chain_index[current])));



		merge_int_lists( 
				tree_chains[chain_index[current]],
				tmp_list, 	&tmp_list_size,
				(tree_chains+ chain_index[current]),
				(chain_index[current+1] -
					chain_index[current]),
				LINK_and_NOT_LINK);

		


                check_and_realloc
                                (&tmp_list, &max_tmp_list_size,
                                2*tmp_list_size,
                                (2* (factor_struc_sizes[child])));


		merge_int_lists(
				tree_chains[chain_index[current]],
				tmp_list, 	&tmp_list_size,
				factor_struc[child],
				factor_struc_sizes[child],
				LINK_and_NOT_LINK);
	


		merge_subs_of_A_spd(
				(chain_index + current),
				(tree_chains +chain_index[current]),
				(chain_index[current+1] - chain_index[current]), 
 				(local_column +chain_index[current]),

				a_struc,
				a_index, a_size);


		remove_duplicates(tmp_list, &tmp_list_size);


		send_vector_size =0;
                check_and_realloc
                                (&send_vector, &max_send_vector_size,
                               	2*send_vector_size, 
                                (2* (tmp_list_size)));
		
		convert_from_links_and_copy(	send_vector,
						&send_vector_size,
						tmp_list,	
						tmp_list_size);

}/*end merge_local_structure_spd*/
			
set_up_structure_spd(
		me, 
		my_side,
		current,
		child,
		nprocs, start_proc,
		factor_struc_received,	factor_struc_received_size)

int		me,
		my_side,
		current,
		child,
		nprocs,
		start_proc,
		*factor_struc_received, *factor_struc_received_size;
{
		


		char	err_msg[80];
		extern	int *tree_chains, *chain_index,
				*index_list, stack_ptr,
				*stack_floats_list,
				stack_floats,
				max_stack_columns,
				max_stack_floats;
				
				
                check_and_realloc
                                (&tmp_list, &max_tmp_list_size,
                                2*tmp_list_size,
                                (2* (*factor_struc_received_size)));

		merge_int_lists(
				tree_chains[chain_index[current]],
				tmp_list, 	&tmp_list_size,
				factor_struc_received,
				*factor_struc_received_size,
				LINK_and_NOT_LINK);
	


		remove_duplicates(tmp_list, &tmp_list_size);


		
/*
		if ( factor_struc[current] != NULL) 
			free((char *) factor_struc[current]);
*/

		sprintf(err_msg,"%d: factor_struc[%d] (d_phase) size %d\n",
					me, current, tmp_list_size);
		if (( factor_struc[current] = (int *) malloc((tmp_list_size 
						*(sizeof(int))))) == NULL)
				exit_err("set_up_structure_spd",malloc_err);


		convert_from_links_and_copy(	factor_struc[current],
						factor_struc_sizes + current,
						tmp_list,	
						tmp_list_size);





                index_list[current] =  stack_ptr;
                stack_ptr += (factor_struc_sizes[current]/ nprocs +1 );
                index_list[current+1] = stack_ptr;
                stack_floats_list[current] = stack_floats;
                stack_floats += (int) ((double)
                                ((factor_struc_sizes[current]/nprocs +1) *
                                (factor_struc_sizes[current]  )*(0.5)));
                stack_floats_list[current+1] =  stack_floats;
                max_stack_columns = (max_stack_columns < stack_ptr ) ?
                                         stack_ptr :
                                        max_stack_columns;
                max_stack_floats = (max_stack_floats < stack_floats ) ?
                                         stack_floats :
                                        max_stack_floats;

		if( child != -1)
		{
		stack_ptr = index_list[child] + 
				(factor_struc_sizes[current]/nprocs +1 );
                stack_floats = stack_floats_list[child] +
				((int) ( (double)
                                ((factor_struc_sizes[current]/nprocs +1) *
                                (factor_struc_sizes[current]  )*(0.5))));
                                
                               
                stack_floats_list[current] = stack_floats_list[child];
                stack_floats_list[current+1] =  stack_floats;
                index_list[current] = index_list[child];
                index_list[current+1] = stack_ptr;
                max_stack_columns = (max_stack_columns < stack_ptr ) ?
                                        stack_ptr :
                                        max_stack_columns;
                max_stack_floats = (max_stack_floats < stack_floats ) ?
                                         stack_floats :
                                        max_stack_floats;
		}


}/*end set_up_structure_spd*/

merge_and_convert (
			recv_vector,
			recv_vector_size,
			max_vector_size,
			send_vector,
			send_vector_size,
			arg_int,
			arg_real)
int
			*recv_vector,
			*recv_vector_size,
			*max_vector_size,
			*send_vector,
			*send_vector_size,
			**arg_int;
real_type			**arg_real;
{


				int	 sum, start_value;
				extern	double stats[];


				start_value = *arg_int[PARAM2];
				
				
				
				stats[s_d_o] += *recv_vector_size;
			
				

				merge_int_lists(start_value,
						tmp_list,
						&tmp_list_size,
						recv_vector,
						*recv_vector_size,
						LINK_and_NOT_LINK);

				remove_duplicates (tmp_list,
							&tmp_list_size);

				if ( tmp_list_size >
					*max_vector_size)
				{
					exit_err(
					"Error : buffer is too small",int_err1);
				}
				convert_from_links_and_copy
					(send_vector,
					send_vector_size,
					tmp_list,
					tmp_list_size);

				stats[s_d_c] += *send_vector_size;
} /*end merge_and_convert */
