/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include "o_l_phase.h"
l_order()
{
		extern	double	clock0(), stats[];
		double last_clock;
		last_clock = clock0();
		for (; l_phase ==1; ){
	

				l_find_dissection_coords();

				l_dissect(l_graph_seps_list,
					l_graph_seps_list);
		}
		stats[o_l_t] = clock0() - last_clock;
}
l_find_dissection_coords()
{
		int dim;
		extern	double	clock0(), stats[];
		double last_clock;

		for (dim=0; dim < D; dim++){
			make_count_lists(		
				dim,	*vtx_counts, 
				size_vtx_counts,
				*max_size_vtx_counts, 
				beta_counts,
				&size_beta_counts, 
				max_size_beta_counts, 
				eps_counts, 
				&size_eps_counts,
				max_size_eps_counts);
			make_kappa_counts(	
				beta_counts,
				&size_beta_counts, 
				max_size_beta_counts, 
				eps_counts, 
				&size_eps_counts,
				max_size_eps_counts, 
				*kappa_counts,	
				size_kappa_counts,
				*max_size_kappa_counts);


			make_graph_count_lists(
				*vtx_counts,
                                *size_vtx_counts, 
				max_graphs, 
				total_graph_count,
				1,0, ((real_type) 0.0),
                                NULL, 2, 0, 0,ADD) ; 

					/*set total_graph_counts*/

			make_graph_count_lists( 
				*vtx_counts,
                                *size_vtx_counts, 
				max_graphs, 
				graph_bounds,
				2, 0,
				alpha,
                                total_graph_count, 1, 0, SMALL_LEVEL,
				ADD) ; 
			make_graph_count_lists( 
				*vtx_counts,
                                *size_vtx_counts, 
				max_graphs, 
				graph_bounds,
				2, 1,
				((float) (1.0 - alpha)),
                                total_graph_count, 1, 0, LARGE_LEVEL,
				ADD);
					/*set balance bounds*/
			find_min_eta_coords( 
				*kappa_counts,	
				*size_kappa_counts,
				*vtx_counts,
                                *size_vtx_counts, 
				l_graph_seps_list, 
				max_graphs, 3, dim,	
		  		graph_bounds, 2) ;
			if(MSGLVL == TRACE_ALL)
			print_vec(dbgfile, l_graph_seps_list, 0, 
					3*max_graphs,"l_graph_seps_list\n");
					/*compute sep level within 
					balance bounds*/
		}
}/*end*/
