/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	<stdio.h>
#include	"n_defs.h"

rec_factor	(
			current, 
			tree_child, 	tree_sibling,
		 	tree_parent,	tree_chains,
		 	chain_index,
			done_factor_columns,
			index_list)

int               	current,
			*tree_child, 	
			*tree_sibling,
		 	*tree_parent,	
			*tree_chains,
		 	*chain_index,
			*index_list,
			*done_factor_columns;


{
	int	child, n, t;




	for (child = tree_child[current]; child != -1; ) {
		

		rec_factor
			(child, 
			tree_child, 	tree_sibling,
		 	tree_parent,	tree_chains,
		 	chain_index,
			done_factor_columns,
			index_list);

	child = tree_sibling[child];
	}
	
	merge_matrices_spd	
			(current,
			tree_child,
			tree_sibling,
			tree_chains,
			chain_index,
			
			index_list);
			
					
	numeric_factor_spd
		(current,
		tree_chains,
		chain_index,
		index_list);





		
}/*end rec_factor_solve*/
numeric_factor_spd	
	(current,
	chain,
	chain_index,
	index_list)

int	current, 
	*chain,
	*chain_index,
	*index_list;
{


		extern	int	*factor_struc_sizes,
				**factor_struc,
				*tree_chains,
				done_factor_columns,
				*stack_nonz_sizes;
		extern	double  **stack_nonz;
		extern	double	clock0(), stats[];

		double	last_clock, n, t;
		
		last_clock = clock0();

		


		n = factor_struc_sizes[current];
		t = chain_index[current+1] - chain_index[current];
		local_chol(	
				(stack_nonz + index_list[current]),
				(chain_index[current+1] - chain_index[current]),
				(factor_struc_sizes[current]));
		stats[n_l_t] += clock0() - last_clock;
		stats[n_l_o] += (n*n*t - n*t*t + (t*t*t)/3.0);
		move_into_factor (
	      			current,
				(tree_chains +chain_index[current]),
				(chain_index[current+1] - 
				chain_index[current]), 
				index_list,
				&done_factor_columns);
					
}
	
