#BANGLINE

###############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;

my $util=new RIB::Util();
my $ribversion=$util->RibVersion();
my $ribdir=$util->RibDir();
my $riburl=$util->RibUrl();

unless(param('rh')=~/^\d+$/) {
	$util->error("repository handle not specified in input");
}
my $rh=param('rh');

unless(param('repoPasswd')) {
	param('repoPasswd',param('password'));
}

$util->dbConnect();

my $sth = $util->dbh->prepare("SELECT name FROM repositories WHERE handle="
                            . $rh);

my $repoName;
eval { $sth->execute(); };
if ($@) { $util->error($@); }
unless ($sth->rows() >= 1) {
  $util->error("The repository you have requested to administrate does not exist.");
}
$repoName = $sth->fetchrow_array();

unless($util->authenticateTry(param('repoPasswd'),$rh)) {
	print header,
	      start_html('-title'=>'Enter repository password',-BGCOLOR=>'#FFFFFF'),
	      center(h1("Enter Repository Password for $repoName")),
	      p,hr,p;
  if (defined param('repoPasswd')) {
    print "The password that you entered was incorrect. Please try again.<P>\n";
  }
  print "Please enter the repository password for <b>$repoName</b> or the main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'repoPasswd', -size=>50, -maxlength=>80),
        hidden(-name=>'rh'),
        submit(-value=>'Submit'), end_form,
        p,hr,p,
        "<A HREF=\"top.pl\">RIB management page</A>\n",
        end_html;
  goto FALLOFF;
}

my $INFILE=upload('filename');
unless($INFILE) {
	print header,
	      start_html('-title'=>'Upload file',-BGCOLOR=>'#FFFFFF'),
	      center(h1("Upload a file to $repoName")),
	      p,hr,p;
	print start_multipart_form(),
	      "Enter the file to upload or select browse:",br,
	      filefield('filename','',45),br,
	      hidden('rh',$rh),
	      hidden('repoPasswd',param('repoPasswd')),
	      submit('submit','Upload'),
	      endform;
	print end_html;
	goto FALLOFF;
}

# Isolate the filename
my $file=param('filename');
my @parts=split(/\//,$file);
my $infile=$parts[$#parts];
@parts=split(/\\/,$infile);
$infile=$parts[$#parts];

my $buffer;
open(OUTFILE,">$ribdir/docRoot/$rh/files/$infile");

while(read($INFILE,$buffer,1024)) {
	print OUTFILE $buffer;
}

print header,
      start_html('-title'=>'Upload file',-BGCOLOR=>'#FFFFFF'),
      center(h1('Upload complete')),
      p,hr,p,
      "$file has been uploaded to $repoName",
      end_html;

close($INFILE);
close(OUTFILE);

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();

