#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Object;

my $util = new RIB::Util();
$util->dbConnect();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
unless (param('class') =~ /^[A-Za-z]+$/) {
  $util->error("object's class not specified in input");
}
unless (param('oh') =~ /^\d+$/) {
  $util->error("object's class not specified in input");
}

my $object = new RIB::Object( $util->dbh, param('rh'), param('class'),
                              param('oh'), param('repoPasswd') );

eval {
  if (param('html')) {
    my $text = $object->asHTML();
    print header, $text;
  } else {
    my $text = $object->asXML();
    print header(-type=>"text/xml"), $text;
  }
  goto FALLOFF;
};

if ($@ =~ /approval/) {
  print header,
        start_html('-title'=>'Enter repository password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter Repository Password')),
        p,hr,p,
        "The object you wish to view has not been approved for general viewing. ",
        "To the view the object please supply the repository password in the ",
        "form below.",
        start_form,
        password_field(-name=>'repoPasswd', -size=>50, -maxlength=>80),
        hidden('rh'),
        hidden('class'),
        hidden('oh'),
        hidden('html'),
        submit, end_form, end_html;
}

elsif ($@) {
  $util->error($@);
}

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
