#BANGLINE

###################################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use XML::DOM;

###################################################

my $util = new RIB::Util();

unless(param('rh') =~ /^\d+$/) {
	$util->error("repository handle not specified in input");
}
my $rh=param('rh');

my $ribdir=$util->RibDir();
my $ribversion=$util->RibVersion();
my $riburl=$util->RibUrl();

opendir(DIR,"$ribdir/docRoot/$rh/files");
my @files=readdir(DIR);

my $document = new XML::DOM::Document();
my $xml_decl = new XML::DOM::XMLDecl();
$xml_decl->setVersion('1.0');
$xml_decl->setStandalone('yes');
$document->setXMLDecl($xml_decl);

my $rib_element=$document->createElement('rib');
$rib_element->setAttribute('version',$ribversion);
$document->appendChild($rib_element);

my $repo_element=$document->createElement('repository');
$repo_element->setAttribute('handle',$rh);
$repo_element->setAttribute('config',"$riburl/$rh/config.xml");
$rib_element->appendChild($repo_element);

foreach my $file (@files) {
	next if($file eq "." || $file eq "..");
	my $file_element=$document->createElement('file');
	$file_element->setAttribute('name',$file);
	$file_element->setAttribute('path',"$ribdir/docRoot/$rh/files/$file");
	$repo_element->appendChild($file_element);
}

print header(-type=>"text/xml"),
      $document->toString();

close(DIR);
