#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Parser; 

##########################################
my $util = new RIB::Util();
my $ribdir = $util->RibDir();
my $riburl = $util->RibUrl();

# determine repository handle
my $repoHandle = param('rh');
unless ($repoHandle =~ /^\d+$/) {
  $util->error("Properly formatted repository handle not supplied");
}
eval { $util->dbConnect(); };
if ($@) { $util->error("Database error $@"); }


##########################################
# get repository properties
my $sth = $util->dbh->prepare("SELECT name,contact,object_approval_required,"
                            . "join_enabled FROM "
                            . "repositories WHERE handle=$repoHandle");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }
my $row = $sth->fetchrow_hashref();
my $repoName = $row->{'name'};
my $repoContact = $row->{'contact'};
my $object_approval_required = $row->{'object_approval_required'};
my $join_enabled = $row->{'join_enabled'};

unless ($join_enabled) {
  print header, start_html,
        "Joins are not currently enabled for this repository.",
        end_html;
  goto FALLOFF;
}

##########################################
my $class = param('c');
my $rel1  = param('r1');
my $rel2  = param('r2');
my $attr  = (param('a') || "Name");
my $url=$ENV{'REQUEST_URI'};

##########################################
# This bit of code causes the browser to redirect to
# a url where all of the arguments are in the url.
# This allows the user to bookmark/share the results when
# the arguments came from a form.
#if (my $url=$ENV{'REQUEST_URI'}) {
  if (($class and $rel1 and $rel2) and
      (($url !~ /\Wc=\w+/) or ($url !~ /\Wr1=\w+/) or ($url !~ /\Wr2=\w+/))) {
    print redirect(self_url);
    goto FALLOFF;
  }
#}

# parse repository configuration
my $rp = new RIB::Parser;
eval { $rp->parse_config_file("$ribdir/docRoot/$repoHandle/config.xml"); };
if ($@) { $util->error("Can't parse repository configuration : " . $@); }

###########################################################
# print form if needed
unless ($class) {
  my @classNames;
  foreach my $class (@{$rp->classes()}) {
    next if $class->name eq "RigObject";
    push (@classNames, $class->name);
  }
  @classNames = sort @classNames;
  print header;
  unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/join_template.html")) {
    $util->error("Can't open join template : $!");
  }
  while (<TEMPLATE>) {
    s/\bREPOSITORY_NAME\b/$repoName/g;
    s/\bREPOSITORY_CONTACT\b/$repoContact/g;
    s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
    s/\bADVANCED_SEARCH_URL\b/$riburl\/advancedSearch.pl\?rh=$repoHandle/g;
    s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
    s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
    s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
    s/\bDATA_MODEL_URL\b/$riburl\/$repoHandle\/config.xml/g;
    s/\bREPOSITORY_HANDLE\b/$riburl\/repository.pl\?rh=$repoHandle/g;
    s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
    s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;
    print;
    if (/<!-- RIB -->/i) {
      print "This feature is for advanced users. From here you can join ",
            "two classes of information by choosing a third class which has ",
            "relationships to each of those classes.\nThe results will be ",
            "displayed in a matrix.\n<P>",
            "Please choose the intersection class. This class will appear in ",
            "the interior of the matrix created by the join. ",
            start_form,
            popup_menu(-name=>'c', -values=>\@classNames),
            hidden('rh'),
            submit(-value=>'Submit'),
            end_form,
            end_html;
    }
  }
  goto FALLOFF;
}

unless ($rel1 and $rel2) {
  my $c = $rp->getClass($class);
  $util->error("$class is not a valid class name") unless $c;
  my @relNames;
  foreach my $rel (@{$c->relationships}) {
    push(@relNames,$rel->name);
  }
  @relNames = sort(@relNames);
  my @attrNames;
  foreach my $attr (@{$c->attributes}) {
    next if $attr->name eq "Name"; # gets added later so its the default
    push(@attrNames,$attr->name);
  }
  @attrNames = sort(@attrNames);
  unshift(@attrNames,"Name");
  
  print header,
        start_html('-title'=>"Create custom join", '-BGCOLOR'=>"#FFFFFF"),
        h1("Create a custom Join"),
        p,hr,p;
        unless (@relNames > 1) {
          print "The intersection class must contain at least two relationships.",
                p,
                "Please <A HREF=", url, "?rh=$repoHandle>back up</A> ",
                "and choose another class";
          goto FALLOFF;
        }
  print "Please choose the intersection relationships. The first relationship ",
        "will be used to construct the column headings and the second ",
        "relationship will be used to construct the column rows for the matrix ",
        "created by the join.",
        start_form,
        "Relationship 1: ",
        popup_menu(-name=>'r1',
                   -values=>\@relNames),
        br,
        "Relationship 2: ",
        popup_menu(-name=>'r2',
                   -values=>\@relNames),
        p,
        "The attribute of $class that you choose here will be used in the ",
        "interior of the matrix.",
        br,
        popup_menu(-name=>'a',
                   -values=>\@attrNames),
        hidden('c'),
        hidden('rh'),
        p,
        submit(-value=>'Submit'),
        end_form,
        end_html;
  goto FALLOFF;
}

###########################################################
#  check arguments
unless ($rp->getClass($class)) {
  $util->error("$class is not a valid class name");
}
unless ($rp->getClass($class)->get_attribute($attr)) {
  $util->error("$attr is not a valid attribute name");
}
unless ($rp->getClass($class)->get_relationship($rel1)) {
  $util->error("$rel1 is not a valid relationship name");
}
unless ($rp->getClass($class)->get_relationship($rel2)) {
  $util->error("$rel2 is not a valid relationship name");
}


###########################################################
# get class objects
my $rel1name = $rel1;
my $rel2name = $rel2;
$rel1name =~ s/\./_/;
$rel2name =~ s/\./_/;
if ($object_approval_required) {
  $sth = $util->dbh->prepare("SELECT $attr\_, $rel1name\_, $rel2name\_, handle FROM "
                              . "$repoHandle\_$class WHERE "
                              . "handle IS NOT NULL AND "
                              . "$attr\_ IS NOT NULL AND "
                              . "$rel1name\_ IS NOT NULL AND "
                              . "$rel2name\_ IS NOT NULL AND "
                              . "approved=1");
} else {
  $sth = $util->dbh->prepare("SELECT $attr\_, $rel1name\_, $rel2name\_, handle FROM "
                              . "$repoHandle\_$class WHERE "
                              . "handle IS NOT NULL AND "
                              . "$attr\_ IS NOT NULL AND "
                              . "$rel1name\_ IS NOT NULL AND "
                              . "$rel2name\_ IS NOT NULL");
}
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }
unless($sth->rows >= 1) {
  print header,
        start_html,
        "The requested join did not produce any results.",
        end_html;
  goto FALLOFF;
}

my %class1_objects = ();
my %class2_objects = ();
my %class3_objects = ();

while (my ($attr,$rel1,$rel2,$handle) = $sth->fetchrow_array()) {
  next unless $rel1 =~ /\?.*oh=(\d+)/;
  my $handle1 = $1;
  next unless $rel1 =~ /\?.*class=(\w+)/;
  my $class1 = $1;
  unless (defined $class1_objects{$handle1}) {
    my $sth2;
    if ($object_approval_required) {
      $sth2 = $util->dbh->prepare("SELECT Name_ FROM $repoHandle\_$class1 WHERE "
                                 . "handle=$handle1 AND approved=1");
    } else {
      $sth2 = $util->dbh->prepare("SELECT Name_ FROM $repoHandle\_$class1 WHERE "
                                 . "handle=$handle1");
    }
    eval { $sth2->execute(); };
    if ($@) { $util->error("Database error $@"); }
    next unless $sth2->rows() >= 1;
    $class1_objects{$handle1} = [$sth2->fetchrow_arrayref()->[0], $rel1."&html=1"];
  }

  next unless $rel2 =~ /\?.*oh=(\d+)/;
  my $handle2 = $1;
  next unless $rel2 =~ /\?.*class=(\w+)/;
  my $class2 = $1;
  unless (defined $class2_objects{$handle2}) {
    my $sth2;
    if ($object_approval_required) {
      $sth2 = $util->dbh->prepare("SELECT Name_ FROM $repoHandle\_$class2 WHERE "
                                 . "handle=$handle2 AND approved=1");
    } else {
      $sth2 = $util->dbh->prepare("SELECT Name_ FROM $repoHandle\_$class2 WHERE "
                                 . "handle=$handle2");
    }
    eval { $sth2->execute(); };
    if ($@) { $util->error("Database error $@"); }
    next unless $sth2->rows() >= 1;
    $class2_objects{$handle2} = [$sth2->fetchrow_arrayref()->[0], $rel2."&html=1"];
  }

  $class3_objects{$handle1}{$handle2} = [$handle,$attr];
}

unless($sth->rows >= 1) {
  print header,
        start_html,
        "The requested join did not produce any results.",
        end_html;
  goto FALLOFF;
}

###################################
# run the join through the template

my $print_footer;
my $footer;
my $nojs = param('nojs');
print header;



unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/join_template.html")) {
  $util->error("Can't open join template : $!");
}
unless (open (TEMPLATE_OUT, ">$ribdir/docRoot/$repoHandle/template.htm")) {
  $util->error("Can't open join template for writing: $!");
}
while (<TEMPLATE>) {
  
  s/\bREPOSITORY_NAME\b/$repoName/g;
  s/\bREPOSITORY_CONTACT\b/$repoContact/g;
  s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
  s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
  s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
  s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
  s/\bDATA_MODEL_URL\b/$riburl\/$repoHandle\/config.xml/g;
  s/\bREPOSITORY_HANDLE\b/$riburl\/repository.pl\?rh=$repoHandle/g;
  s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
  s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;
  if (/<!-- RIB -->/i) {
      $print_footer = 1;
  }
  if ($print_footer) {
      $footer .= $_;
  } else {
    print TEMPLATE_OUT;
  }
  
  
}
close(TEMPLATE_OUT);

if(!$nojs) {

#############################################
### VARS FOR DYNAMIC CELL DIMENSIONS

my $width;
my $height;
my $frame_width;
my $frame_height;

my @vars;
my $word;
my $longest_row   = 0;
my $longest_word = 0;
my $num_rows    = 0;
my $mod;
my $cnt = 0;

###  dynamic heading hacks begin here   ###

foreach my $handle1 (keys %class1_objects) {
  if (length($class1_objects{$handle1}->[0]) > $longest_row) {
    $longest_row = length($class1_objects{$handle1}->[0]);
  }
  @vars = split /\s+/,$class1_objects{$handle1}->[0];
  foreach $word (@vars) {
    if (length($word) > $longest_word) {
      $longest_word = length($word);
    }
  }
}

foreach my $handle2 (keys %class2_objects) {
  if (length($class2_objects{$handle2}->[0]) > $longest_row) {
    $longest_row = length($class2_objects{$handle2}->[0]);
  }
  @vars = split /\s+/,$class2_objects{$handle2}->[0];
  foreach $word (@vars) {
    if (length($word) > $longest_word) {
      $longest_word = length($word);
    }
  }
  
  
  foreach my $handle1 (keys %class1_objects) {
    if (exists($class3_objects{$handle1}{$handle2})) {
    
      if (length($class3_objects{$handle1}{$handle2}->[1]) > $longest_row) {
        $longest_row = length($class3_objects{$handle1}{$handle2}->[1]);
      }
      @vars = split /\s+/,$class3_objects{$handle1}{$handle2}->[1];
      foreach $word (@vars) {
        if (length($word) > $longest_word) {
          $longest_word = length($word);
        }
      }
    }
  }
  
  
}


$num_rows = int($longest_row/$longest_word);
$mod = $longest_row%$longest_word;
if ($mod >= 1) {
  $num_rows = 1 + $num_rows;
}

$width = $longest_word * 9;
$height = $num_rows * 16;

$frame_height = $height + 6;
$frame_width  = $width  + 6;


###  PRINTING DATA  ###

unless (open (MAIN, ">$ribdir/docRoot/$repoHandle/join_main.htm")) {
  $util->error("Can't open main.htm for writing: $!");
}

print MAIN <<HTML;

<html>
<head>
<title>MAIN Join body</title>

<SCRIPT LANGUAGE="Javascript1.2">
<!--

if (document.all) {
  onscroll = keepTogether;
} else if (document.layers) {
  onload = checkScroll;
} else if (document.getElementById) {
  onload = checkDiv;
}

function keepTogether() {
  //leftFrame.document.body.scrollTop = document.body.scrollTop;
  //topFrame.document.body.scrollLeft = document.body.scrollLeft;
  parent.frames.topHeading.document.all.topDiv.style.left = -document.body.scrollLeft;
  parent.frames.left.document.all.leftDiv.style.top       = -document.body.scrollTop;
  
}

function checkScroll() {
  setInterval("scrollLayer()",10);
}

function checkDiv() {
  setInterval("scrollDiv()",10);
}

function scrollLayer() {
  parent.frames.topHeading.document.layers[0].left = -pageXOffset;
  parent.frames.left.document.layers[0].top        = -pageYOffset;
}

function scrollDiv() {
  
  myleftDiv = parent.frames.left.document.getElementById('leftDiv');
  mytopDiv = parent.frames.topHeading.document.getElementById('topDiv');
  myleftDiv.style.top = -pageYOffset + "px";
  mytopDiv.style.left = -pageXOffset + "px";
  
}


//-->
</SCRIPT>

<style type='text/css'>
A.GRID {  font: 10pt Courier }
TH {  font: 10pt Courier }
</style>

<BASE TARGET=\"_top\">

</head>

<BODY MARGINWIDTH=0 MARGINHEIGHT=0 LEFTMARGIN=0 TOPMARGIN=0>

HTML
    
    print MAIN "<TABLE BORDER=1 CELLPADDING=0 CELLSPACING=1><TR>\n";
    
    foreach my $handle2 (sort {
            lc($class2_objects{$a}->[0]) cmp lc($class2_objects{$b}->[0]);
                              } keys %class2_objects) {
      
      
      foreach my $handle1 (sort {
            lc($class1_objects{$a}->[0]) cmp lc($class1_objects{$b}->[0]);
                              } keys %class1_objects) {
        
        print MAIN "<TH WIDTH=$width HEIGHT=$height>";
        
        if (exists($class3_objects{$handle1}{$handle2})) {
          print MAIN "<A CLASS=GRID HREF=$riburl/object.pl?rh=$repoHandle&class=$class&oh=$class3_objects{$handle1}{$handle2}->[0]&html=1 title=\"$class2_objects{$handle2}->[0] \\ $class1_objects{$handle1}->[0]\">";
          print MAIN "$class3_objects{$handle1}{$handle2}->[1]</A>";
        } else {
          print MAIN "-";
        }
        print MAIN "</TH>\n";
         }
      print MAIN "<TH WIDTH=$width HEIGHT=$height BGCOLOR=\"#F0F0F0\"><IMG SRC=\"/images/trans.gif\" WIDTH=$width HEIGHT=$height></TH></TR>\n"; 
     
      
    }
    for (my $i=0;  $i <= scalar(keys %class3_objects); $i++) {
      print MAIN "<TH WIDTH=$width HEIGHT=$height BGCOLOR=\"#F0F0F0\"><IMG SRC=\"/images/trans.gif\" WIDTH=$width HEIGHT=$height></TH>";
    }    
    print MAIN "</TR></TABLE>\n";
    print MAIN "<BR CLEAR=ALL>$footer\n";
    
close(MAIN);  


###  PRINTING COL HEADINGS TOPLAYER ###

unless (open (TOP, ">$ribdir/docRoot/$repoHandle/join_top.htm")) {
  $util->error("Can't open join_top.htm for writing: $!");
}

print TOP <<HTML;

<HTML>
<HEAD>
<TITLE>TOP Join Heading</TITLE>
<HEAD>

<style type='text/css'>
A {  font: 10pt Courier }
TH {  font: 10pt Courier }
</style>

<BASE TARGET=\"_top\">

</HEAD>

<BODY MARGINWIDTH=0 MARGINHEIGHT=0 LEFTMARGIN=0 TOPMARGIN=0>

HTML
    
    print TOP "<LAYER><DIV ID=\"topDiv\" style=\"position:absolute; left:0; top:0\">\n";
    print TOP "<TABLE BORDER=1 CELLPADDING=0 CELLSPACING=1 ALIGN=LEFT><TR>\n";
      foreach my $handle1 (sort {
        lc($class1_objects{$a}->[0]) cmp lc($class1_objects{$b}->[0]);
                                } keys %class1_objects) {
        print TOP "<TH WIDTH=$width HEIGHT=$height BGCOLOR=\"#F0F0F0\"><A HREF=\"$class1_objects{$handle1}->[1]\"><font style=\"font: 10pt Courier\">$class1_objects{$handle1}->[0]</font></A></TH>\n";
    }
    print TOP "<TH WIDTH=$width HEIGHT=$height BGCOLOR=\"#F0F0F0\"><IMG SRC=\"/images/trans.gif\" WIDTH=$width HEIGHT=$height></TH>\n";
    print TOP "</TR><TR>\n";
    for (my $i=0;  $i <= scalar(keys %class1_objects); $i++) {
      print TOP "<TH WIDTH=$width HEIGHT=$height BGCOLOR=\"#F0F0F0\"><IMG SRC=\"/images/trans.gif\" WIDTH=$width HEIGHT=$height></TH>\n";
    }
    print TOP "</TR></TABLE>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</DIV></LAYER></BODY></HTML>\n";
    
close(TOP);
  

###  PRINTING ROW HEADINGS LEFTLAYER ### 

unless (open (LEFT, ">$ribdir/docRoot/$repoHandle/join_left.htm")) {
  $util->error("Can't open join_left.htm for writing: $!");
}

print LEFT <<HTML;

<HTML>
<HEAD>
<TITLE>LEFT Join Heading</TITLE>
<HEAD>

<style type='text/css'>
A { font: 10pt Courier }
TH { font: 10pt Courier }
</style>

<BASE TARGET=\"_top\">

</HEAD>

<BODY MARGINWIDTH=0 MARGINHEIGHT=0 LEFTMARGIN=0 TOPMARGIN=0>

HTML
  
    print LEFT "<LAYER><DIV ID=\"leftDiv\" style=\"position:absolute; left:0; top:0\">\n";
    print LEFT "<TABLE BORDER=1 CELLPADDING=0 CELLSPACING=1>\n";
    
    foreach my $handle2 (sort {
      lc($class2_objects{$a}->[0]) cmp lc($class2_objects{$b}->[0]);
                              } keys %class2_objects) {
      print LEFT "<TR><TH HEIGHT=$height WIDTH=$width BGCOLOR=\"#F0F0F0\"><A HREF=\"$class2_objects{$handle2}->[1]\"><font style=\"font: 10pt Courier\">$class2_objects{$handle2}->[0]</font></A></TH>\n";
      print LEFT "<TH HEIGHT=$height WIDTH=$width BGCOLOR=\"#F0F0F0\"><IMG SRC=\"/images/trans.gif\" WIDTH=$width HEIGHT=$height></TH></TR>\n";
      
    }
    print LEFT "<TR><TH HEIGHT=$height WIDTH=$width BGCOLOR=\"#F0F0F0\"><IMG SRC=\"/images/trans.gif\" WIDTH=$width HEIGHT=$height></TH>\n";
    print LEFT "<TH HEIGHT=$height WIDTH=$width BGCOLOR=\"#F0F0F0\"><IMG SRC=\"/images/trans.gif\" WIDTH=$width HEIGHT=$height></TH></TR>\n";
    print LEFT "</TABLE><BR><BR></DIV></LAYER></BODY></HTML>\n";
    
close(LEFT);

###  PRINT FRAME NOW  ###

print <<HTML;

<HTML>
<HEAD>
<TITLE>$repoName</TITLE>

<style type='text/css'>
A {  font: 10pt Courier }
TH {  font: 10pt Courier }
</style>

</HEAD>

<SCRIPT LANGUAGE="Javascript1.2">
//<!--

document.writeln('<FRAMESET ROWS="164,*" BORDER=0>');

document.writeln('<FRAME NAME="template" SRC="/$repoHandle/template.htm">');

document.writeln('<FRAMESET COLS="$frame_width,*" BORDER=0>');
document.writeln('<FRAMESET ROWS="$frame_height,*">');

document.writeln('<FRAME SCROLLING="no">');
document.writeln('<FRAME NAME="left" SRC="/$repoHandle/join_left.htm" MARGINWIDTH=0 MARGINHEIGHT=0 SCROLLING="no">');

document.writeln('</FRAMESET>');

document.writeln('<FRAMESET ROWS="$frame_height,*">');

document.writeln('<FRAME NAME="topHeading" SRC="/$repoHandle/join_top.htm" MARGINWIDTH=0 MARGINHEIGHT=0 SCROLLING="no">');
document.writeln('<FRAME NAME="main"   SRC="/$repoHandle/join_main.htm" MARGINWIDTH=0 MARGINHEIGHT=0>');

document.writeln('</FRAMESET></FRAMESET>');

//-->
</SCRIPT>

<NOSCRIPT>

<FRAMESET ROWS="164,*" BORDER=0>

<FRAME NAME="template" SRC="/$repoHandle/template.htm">
<FRAME NAME="main"   SRC="$url&nojs=1" MARGINWIDTH=0 MARGINHEIGHT=0>


</NOSCRIPT>

<NOFRAMES>

Your browser seems to be having trouble displaying this frameset.<br>
You can try a frameless version <a href="$url&nojs=1">here.</a>

</NOFRAMES>

</FRAMESET>

</HTML>


HTML
    
} elsif ($nojs) {

print "<HTML><BODY><TABLE BORDER=1 CELLPADDING=1 ALIGN=LEFT><TR><TH BGCOLOR=\"#F0F0F0\"><BR></TH>\n";
    
    
   
    
    foreach my $handle1 (sort {
             lc($class1_objects{$a}->[0]) cmp lc($class1_objects{$b}->[0]);
                              } keys %class1_objects) {
      
      print "<TH BGCOLOR=\"#F0F0F0\"><BR><A CLASS=GRID HREF=\"$class1_objects{$handle1}->[1]\" TARGET=\"_top\">$class1_objects{$handle1}->[0]</A></TH>\n";
    }
    
    foreach my $handle2 (sort {
            lc($class2_objects{$a}->[0]) cmp lc($class2_objects{$b}->[0]);
                              } keys %class2_objects) {
      
      print "<TR><TH BGCOLOR=\"#F0F0F0\"><A CLASS=GRID HREF=\"$class2_objects{$handle2}->[1]\" TARGET=\"_top\">$class2_objects{$handle2}->[0]</A></TH>\n";
      
      foreach my $handle1 (sort {
            lc($class1_objects{$a}->[0]) cmp lc($class1_objects{$b}->[0]);
                              } keys %class1_objects) {
        
        print "<TD ALIGN=CENTER>";
        
        if (exists($class3_objects{$handle1}{$handle2})) {
          print "<A CLASS=GRID HREF=$riburl/object.pl?rh=$repoHandle&class=$class&oh=$class3_objects{$handle1}{$handle2}->[0]&html=1 title=\"$class2_objects{$handle2}->[0] \\ $class1_objects{$handle1}->[0]\" TARGET=\"_top\">";
          print "$class3_objects{$handle1}{$handle2}->[1]</A>";
        } else {
          print "-";
        }
        print "</TD>\n";
      }
      print "</TR>\n";
    }
    print "</TABLE><BR CLEAR=ALL>$footer\n";


}

###   dynamic heading hacks end here   ###

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
