#!/bin/sh

RIBVERSION="2.1.2"
PATH=/bin:/usr/bin:/usr/local/bin:/usr/ucb:$PATH
export PATH

echo
echo "Repository In a Box (RIB) ,version $RIBVERSION installation"
echo
echo "This script will guide you through the RIB installation process."
echo "Press ENTER to accept default values appearing in []'s. If at"
echo "any time you need to stop this script, press CTRL-C."
echo

########################################################################
# Where do we install RIB?
while true; do
	echo
	echo "Where do you want to install RIB? [/usr/local/rib/rib-$RIBVERSION]"
	read rib_path
	if test $rib_path"x" = "x"; then
		rib_path="/usr/local/rib/rib-$RIBVERSION"
	fi
	if test -x $rib_path; then
		echo
		echo "The directory $rib_path already exists. Install here anyway? [y]"
		read tmp
		if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
			if test -w $rib_path; then
				break
			else
				echo
				echo "!!!!!! You don't have write permission at $rib_path !!!!!!!"
			fi
		fi
	else
		if mkdir $rib_path; then
			break;
		else
			echo
			echo "!!!!!! Can't create directory $rib_path !!!!!!"
		fi
	fi
done

#######################################################################
# Which user runs RIB?
default_usr="nobody"
if grep '^rib:' /etc/passwd >/dev/null 2>&1; then
	default_usr="rib"
fi
user=`whoami`;
if test $user = "root"; then
	while true; do
		echo
		echo "Which user would you like to run the RIB server as? [$default_usr]"
		read rib_usr
		if test $rib_usr"x" = "x"; then
			rib_usr=$default_usr
			break;
		elif test $rib_usr = "root"; then
			echo
			echo "Running RIB as \"root\" is NOT recommended."
			echo "Are you sure you want to do this? [n]"
			read tmp
			if test $tmp = "y"; then
				break;
			fi
		else
			break;
		fi
	done
else
	echo
	echo "Since you are not logged in as root, you cannot"
	echo "configure the RIB server to run as anyone other"
	echo "than yourself. Is this okay? [y]"
	read tmp
	if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
		rib_usr=$user
	else
		echo
		echo "To enable RIB to run as another user, please"
		echo "log in as root and run this installation "
		echo "program again."
		echo
		exit
	fi
fi

##########################################################################
# RIB needs a password
while true; do
	echo
	echo "Please specify a password for the RIB Management Page. The"
	echo "password should be at least 5 characters long. This password"
	echo "protects the RIB management interface."
	read rib_pass
	length=`echo $rib_pass | wc -c`
	if test $length -gt 5; then
		break;
	fi
done

##########################################################################
# Which host are we running on?
while true; do
	echo
	echo "What is the hostname of your machine (e.g. dinah.cs.utk.edu)?"
	read rib_host
	if test $rib_host"x" = "x"; then
		echo
	else
		break
	fi
done

##########################################################################
# What port number are we using?
while true; do
	echo
	echo "Which port do you want to run the RIB HTTP server on? [80]"
	echo "Choosing a port number other than 80 will cause the number"
	echo "to appear in URLs used to access your RIB server"
	echo "(e.g. http://your.machine.org:port)."
	read http_port
	if test $http_port"x" = "x"; then
		http_port=80
	fi
	if test $user != "root"; then
		if test $http_port -lt 1023; then
			echo
			echo "Since you have chosen to run RIB on a port less than 1023"
			echo "you will need to start RIB as root (preferably from your"
			echo "machine's startup scripts). Is this okay? [y]"
			read tmp
			if test $tmp"x" = "x" -o $tmp"x" = "yx"; then
				break;
			fi
		else
			break;
		fi
	else
		break;
	fi
done

#########################################################################
# Now we're ready to install RIB
mydir=`pwd`
echo
echo "Installing RIB software"
echo "======================="
echo

# MySQL
echo "Installing MySQL...."
cd $mydir/src/mysql-3.23.38
./configure --prefix=$rib_path/lib/mysql > $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
	echo > /dev/null
else
	echo "Unable to make MySQL!"
	exit
fi
if make install >> $mydir/install.log 2>&1; then
	echo >/dev/null
else
	echo "Unable to install MySQL!"
	exit
fi
mkdir $rib_path/lib/mysql/var
scripts/mysql_install_db
echo "Done"

# Perl
echo "Installing Perl...."
cd $mydir/src/perl-5.6.1
sh Configure -des -Dprefix=$rib_path/lib/perl >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
	echo > /dev/null
else
	echo "Unable to make Perl!"
	exit
fi
if make install >> $mydir/install.log 2>&1; then
	echo > /dev/null
else
	echo "Unable to install Perl!"
	exit
fi
echo "Done"

# Apache + modules
echo "Installing Apache...."
cd $mydir/src/apache_1.3.22/src/modules
mkdir gzip
cp $mydir/src/mod_gzip.c ./gzip
./configure --with-apache=$mydir/src/apache_1.3.22 >> $mydir/install.log 2>&1
cd $mydir/src/mod_perl-1.25
$rib_path/lib/perl/bin/perl Makefile.PL APACHE_SRC=$mydir/src/apache_1.3.22 \
        DO_HTTPD=1 USE_APACI=1 PREP_HTTPD=1 EVERYTHING=1 \
        >> $mydir/install.log 2>&1
make >> $mydir/install.log 2>&1
make install >>$mydir/install.log 2>&1
cd $mydir/src/apache_1.3.22
./configure --prefix=$rib_path/lib/apache --enable-module=status \
        --enable-module=info \
        --add-module=src/modules/gzip/mod_gzip.c \
        --activate-module=src/modules/perl/libperl.a \
        >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
	echo > /dev/null
else
	echo "Unable to make Apache!"
	exit
fi
if make install >> $mydir/install.log 2>&1; then
	echo > /dev/null
else
	echo "Unable to install Apache!"
	exit
fi
echo "Done"

# Make some links for convenience
mkdir $rib_path/bin
ln -s $rib_path/lib/perl/bin/perl $rib_path/bin/perl
ln -s $rib_path/lib/apache/bin/apachectl $rib_path/bin/apachectl
ln -s $rib_path/lib/mysql/bin/safe_mysqld $rib_path/bin/safe_mysqld

# Perl modules
echo "Installing Perl modules...."
cd $mydir/src/CGI.pm-2.753
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
	echo > /dev/null
else
	echo "Unable to make CGI module!"
	exit
fi
if make install >> $mydir/install.log 2>&1; then
	echo > /dev/null
else
	echo "Unable to install CGI module!"
	exit
fi

cd $mydir/src/Digest-MD5-2.13
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make MD5 module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install MD5 module!"
  exit
fi

cd $mydir/src/MIME-Base64-2.12
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make MIME-Base64 module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install MIME-Base64 module!"
  exit
fi

cd $mydir/src/URI-1.12
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make URI module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install URI module!"
  exit
fi

cd $mydir/src/HTML-Tagset-3.03
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make HTML-Tagset module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install HTML-Tagset module!"
  exit
fi

cd $mydir/src/HTML-Parser-3.25
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make HTML-Parser module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install HTML-Parser module!"
  exit
fi

cd $mydir/src/libwww-perl-5.53
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make libwww module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install libwww module!"
  exit
fi

cd $mydir/src/XML-Parser-2.30
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make XML-Parser module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install XML-Parser module!"
  exit
fi

cd $mydir/src/XML-DOM-1.25
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make XML-DOM module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install XML-DOM module!"
  exit
fi

cd $mydir/src/DBI-1.15
$rib_path/bin/perl Makefile.PL >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make DBI module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install DBI module!"
  exit
fi

cd $rib_path/lib/mysql
bin/safe_mysqld --basedir=$rib_path/lib/mysql &
cd $mydir/src/Msql-Mysql-modules-1.2216
$rib_path/bin/perl Makefile.PL --noprompt --nomsql-install \
              --nomsql1-install --mysql-test-db=test --mysql-test-user=undef \
              --mysql-test-host=$rib_host --mysql-test-pass=undef \
              --mysql-incdir=$rib_path/lib/mysql/include/mysql \
              --mysql-libdir=$rib_path/lib/mysql/lib/mysql >> $mydir/install.log 2>&1
if make >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to make MySQL module!"
  exit
fi
if make install >> $mydir/install.log 2>&1; then
  echo > /dev/null
else
  echo "Unable to install MySQL module!"
  exit
fi

echo "Done"

echo "Installing RIB...."
cd $mydir/rib
cp -R * $rib_path

cd $mydir/src/CGI
cat > bangtest.pl <<DONE
#!$rib_path/bin/perl
print "good shell\n";
DONE

chmod +x bangtest.pl
if ./bangtest.pl; then
	goodbang=1
else
	goodbang=0
fi

for file in `ls *.pl`
do
	if [ $goodbang -eq 1 ]; then
		sed -e "/#BANGLINE/s%.*%#!$rib_path/bin/perl%" \
		       $file > $rib_path/docRoot/$file
	else
		sed -e "/#BANGLINE/i\\
#!/bin/sh -- # perl \\
eval 'exec $rib_path/bin/perl -S \$0 \${1+\"\$@\"}' \\
if 0;" \
		    $file > $rib_path/docRoot/$file
	fi
	chmod +x $rib_path/docRoot/$file
done

cd $rib_path/bin
for file in `ls *.pl`
do
	if [ $goodbang -eq 1 ]; then
		sed -e "/#BANGLINE/s%.*%#!$rib_path/bin/perl%" \
		    $file > $file.new
	else
		sed -e "/#BANGLINE/i\\
#!/bin/sh -- #perl \\
eval 'exec $rib_path/bin/perl -S \$0 \${1+\"\$@\"}' \\
if 0;" \
		    $file > $file.new

	mv $file.new $file
	rm $file.new
	chmod +x $file
	fi
done

cat > $rib_path/bin/ribctl << DONE
#!/bin/sh

ARGV="\$@"
if test "x\$ARGV" = "x"; then
	ARGS="help"
fi

for ARG in \$@ \$ARGS
do
	case \$ARG in

	start)
		$rib_path/bin/apachectl start
		cd $rib_path/lib/mysql
		bin/safe_mysqld --basedir=$rib_path/lib/mysql &
		;;

	stop)
		$rib_path/bin/apachectl stop
		$rib_path/lib/mysql/bin/mysqladmin --user=root --password=$rib_pass shutdown
		;;

	restart)
		$rib_path/bin/ribctl stop
		$rib_path/bin/ribctl start
		;;

	help)
		echo "Usage: ribctl {start|stop|restart|help}"
		;;

	esac
done
DONE

chmod +x $rib_path/bin/ribctl

echo "Done"

echo
echo "Configuring RIB database"
echo "========================"
echo

cd $mydir

sql_cmd="$rib_path/lib/mysql/bin/mysql --user=root mysql"

create_cmd="INSERT INTO user (Host, User, Password, Select_priv, Insert_priv, Update_priv, Delete_priv, Create_priv, Drop_priv, Reload_priv, Shutdown_priv, Index_priv, Alter_priv) VALUES ('localhost','$rib_usr',password('$rib_pass'),'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y');"
echo $create_cmd | $sql_cmd

$rib_path/lib/mysql/bin/mysqladmin --user=root create rib
$rib_path/lib/mysql/bin/mysqladmin --user=root password $rib_pass

sql_cmd="$rib_path/lib/mysql/bin/mysql --user=root --password=$rib_pass mysql"

db_cmd="INSERT INTO db (Host, Db, User, Select_priv, Insert_priv, Update_priv, Delete_priv, Create_priv, Drop_priv, Index_priv, Alter_priv) VALUES ('localhost','rib','$rib_usr','Y','Y','Y','Y','Y','Y','Y','Y');"
echo $db_cmd | $sql_cmd

sql_cmd="$rib_path/lib/mysql/bin/mysql --user=root --password=$rib_pass rib"

cat tables/repositories | $sql_cmd
cat tables/admin | $sql_cmd
echo "delete from admin;" | $sql_cmd
echo "insert into admin (password,is_locked) values ('$rib_pass',0)" | $sql_cmd
cat tables/sequences | $sql_cmd

echo "Done"

echo
echo "Configuring files"
echo "================="
echo

cd $rib_path/lib/apache/conf
mv httpd.conf httpd.conf.old
sed -e "/Port 8.*/s/8.*/$http_port/" \
    -e "/User n.*/s/n.*/$rib_usr/" \
    -e "/DocumentRoot \"/s%.*%DocumentRoot \"$rib_path/docRoot/\"%" \
    httpd.conf.old > httpd.conf
cat >> httpd.conf << DONE
<Files *.pl>
SetHandler perl-script
PerlHandler Apache::Registry
Options +ExecCGI
</Files>
PerlSendHeader off
LockFile /var/tmp/accept.lock
DONE

if test $http_port -eq 80; then
	rib_url="http://"$rib_host
else
	rib_url="http://"$rib_host":"$http_port
fi

rib_lib=$rib_path/lib/perl/lib/site_perl/5.6.1/RIB
mkdir $rib_lib
cd $mydir/src/RIB
cp * $rib_lib
sed -e "s%RIBDIR%$rib_path%" \
    -e "s%RIBURL%$rib_url%" \
    -e "s%RIBUSR%$rib_usr%" \
    -e "s%RIBPASS%$rib_pass%" \
    -e "s%RIBVERSION%$RIBVERSION%" \
    Util.pm.old > $rib_lib/Util.pm

echo "Done"

echo "RIB installation complete"
