#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Parser;

my $util = new RIB::Util();
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;

my $repoHandle = param('rh');
unless ($repoHandle =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

## make sure new primary class is valid
unless (param('primClass') =~ /^\w+$/) {
  $util->error("primary class not specified");
}
my $rp = new RIB::Parser();
my $status;
eval { $status = $rp->parse_config_file("$ribdir/docRoot/$repoHandle/config.xml"); };
if ($@ or (!$status)) {
  $util->error("Can't parse repository data model");
}
my $class;
unless ($class = $rp->getClass(param('primClass'))) {
  $util->error("Invalid class name : " . param('primClass'));
}
my $attr;
if (param('primAttr')) {
  unless ($attr = $class->get_attribute(param('primAttr'))) {
    $util->error("Invalid attribute name : " . param('primAttr'));
  }
}

## update the repositories table
my $sth;
my $rv;
if (param('primAttr') =~ /^\w+$/) {
  $sth = $util->dbh->prepare("UPDATE repositories SET primary_attribute='"
                           . param('primAttr')
                           . "', primary_class='"
                           . param('primClass')
                           . "' WHERE handle=$repoHandle");
} else {
  $sth = $util->dbh->prepare("UPDATE repositories SET primary_attribute=NULL "
                           . ", primary_class="
                           . $util->dbh->quote(param('primClass'))
                           . " WHERE handle=$repoHandle");
}
eval { $rv = $sth->execute(); };
if ($@) { $util->error("Database error $@"); }
unless ($rv) { $util->error("Database error ". $sth->errstr); }

## reconfigure the interop_objects table
eval {
  #$util->dbh->do("DELETE FROM $repoHandle\_interop_objects");
  $rv = $util->dbh->do("DROP TABLE $repoHandle\_interop_objects");
};
if ($@) { $util->error("Database error $@"); }
unless ($rv) { $util->error("Database error ". $sth->errstr); }

my $query = "CREATE TABLE $repoHandle\_interop_objects (";
foreach my $field (@{$class->attributes},@{$class->relationships}) {
  my $fieldname = $field->name;
  $fieldname =~ s/\./\_/;
  $query .= "$fieldname\_ TEXT, ";
}
$query .= "url TEXT, owner_handle BIGINT UNSIGNED, "
        . "last_modified TIMESTAMP, created TIMESTAMP)";

$sth = $util->dbh->prepare($query);
eval { $status = $sth->execute(); };
if ($@) {
  $util->error("Database error : $@");
} elsif (!$status) {
  $util->error("Database error : " . $sth->errstr);
}

print header(-type=>"text/plain"), "ok";

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
