#BANGLINE

###################################################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use HTTP::Date;
###################################################################

my $util=new RIB::Util;
my $ribdir=$util->RibDir;
my $riburl=$util->RibUrl;

$util->dbConnect();

my $SCRIPT=<<'END';
function form_select(f) {

	//strip off the current script name
	myurl=location.href.substring(0,location.href.lastIndexOf("/")+1);

	//add on the target script name
	i=f.rh.selectedIndex;
	repositoryHandle=document.forms[0].rh.options[i].value;
	myurl+="adminRepository.pl?rh="+repositoryHandle;

	//change the action for the form
	f.action=myurl;
	return true;
}
END

my $sth=$util->dbh->prepare("SELECT handle,name FROM repositories ORDER by name");
my %labels=();
eval { $sth->execute(); };
if($@) { $util->error("Database error $@"); }

while($_=$sth->fetchrow_arrayref) {
	$labels{$_->[0]}=$_->[1];
}

## Information should expire in 5 minutes. This helps ensure newly created
## repositories show up in the list.
my $now=HTTP::Date::time2str(time);
my $later=HTTP::Date::time2str(time+5*60);

print header('-Expires'=>$later,'-Date'=>$now),
	start_html('-title'=>'RIB administration portal',-BGCOLOR=>'#FFFFFF',
	           '-script'=>{-language=>'JavaScript',-code=>$SCRIPT}),
	"<NOSCRIPT>",
	"<B><FONT COLOR=red>",
	"This page requires JavaScript and you do not have it enabled.",
	"The controls on this page will not function correctly until JavaScript",
	"has been reenabled.",
	"</FONT></B>",
	"</NOSCRIPT>",
	"<CENTER>",
	"<TABLE BORDER=5 CELLPADDING=15><TR><TD>",
	"<A HREF=http://www.nhse.org/RIB/>",
	"<IMG BORDER=0 WIDTH=150 HEIGHT=150 SRC=$riburl/doc/RIBlogo.gif>",
	"</A>",
	"</TD><TD ALIGN=CENTER VALIGN=CENTER>",
	"<H2>Repository In a Box</H2>",
	"<H3>Administration Portal</H3>",
	"</TD></TR></TABLE>",
	p,hr,p;

if(keys %labels) {
	my @repoNames=sort {lc($labels{$a}) cmp lc($labels{$b})} keys %labels;
	print start_form(-onSubmit=>'return form_select(this)'),
		"Administer repository named ",
		popup_menu(-name=>'rh',
			-values=>\@repoNames,
			-default=>$repoNames[0],
			-labels=>\%labels),
		submit(-value=>'Go'),
		end_form,
		p;
}

print hr,
	"<A HREF=$riburl/doc/top_help.html>Click here for help</A>",
	end_html;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
