####################################
package RIB::Catalog;
use strict;
use RIB::Util;
use RIB::Parser;
use RIB::VocabularyTerm;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {
    'DBH' => undef,
    'REPO_HANDLE' => undef,
    'CONFIG' => undef,
    'PRIMARY_ATTR' => undef,
    'PRIMARY_CLASS' => undef
  };
  bless ($self, $class);
  return $self;
}

sub dbh {
  my $self = shift;
  if (@_) { $self->{'DBH'} = shift; }
  return $self->{'DBH'};
}

sub repoHandle {
  my $self = shift;
  if (@_) { $self->{'REPO_HANDLE'} = shift; }
  return $self->{'REPO_HANDLE'};
}

sub config {
  my $self = shift;
  if (@_) { $self->{'CONFIG'} = shift; }
  return $self->{'CONFIG'};
}

sub primAttr {
  my $self = shift;
  if (@_) { $self->{'PRIMARY_ATTR'} = shift; }
  return $self->{'PRIMARY_ATTR'};
}

sub primClass {
  my $self = shift;
  if (@_) { $self->{'PRIMARY_CLASS'} = shift; }
  return $self->{'PRIMARY_CLASS'};
}

sub buildCatalog {
  my ($self,$term) = @_;
  $term = '' unless defined($term);
  my $util = new RIB::Util;
  my $ribdir = $util->RibDir;
  my $riburl = $util->RibUrl;

  my $sth = $self->dbh->prepare("SELECT primary_class, primary_attribute, name, contact, object_approval_required, whats_new_enabled FROM repositories WHERE handle=" . $self->repoHandle());
  eval { $sth->execute(); };
  if ($@) { $util->error($@); }

  my $catalogInfo = $sth->fetchrow_hashref();
  my ($primClass,$primAttr);
  if (!($self->primClass())) {
    $primClass = $catalogInfo->{'primary_class'};
    if (!($self->primAttr())) {
      $primAttr = $catalogInfo->{'primary_attribute'};
    } else {
      $primAttr = $self->primAttr();
    }
  } else {
    $primClass = $self->primClass();
    if (!($self->primAttr())) {
      $primAttr = undef;
    } else {
      $primAttr = $self->primAttr();
    }
  }

  my $name = $catalogInfo->{'name'};
  my $contact = $catalogInfo->{'contact'};
  my $object_approval_required = $catalogInfo->{'object_approval_required'};
  my $repoHandle = $self->repoHandle();
  my $whatsNewEnabled = $catalogInfo->{'whats_new_enabled'};

  my ($class, $attribute, $vocabulary);
  # find the vocabulary for sorting objects
  unless ($class = $self->{'CONFIG'}->getClass($primClass)) {
    $util->error("Repository configuration error. Primary class not found.")
  }
  if ($primAttr) {
    unless ($attribute = $class->get_attribute($primAttr)) {
      $util->error("Repository configuration error. Primary attribute ($primAttr) not found.")
    }
    $vocabulary = $attribute->vocabulary();
  }
  my $titleLine = "";
  if ($class->get_attribute("TitleLine")) {
    $titleLine = ", TitleLine_";
  }

  my $buf = undef;
  my $prefix = "$riburl/object.pl?rh=$repoHandle&class=$primClass&html=1&oh=";
  my $catalog = "$riburl/catalog.pl?rh=$repoHandle&term=";

  ###################################
  # if no primary attribute exists then list all primary class objects
  if (!($primAttr)) {
    if ($object_approval_required) {
      $sth = $self->dbh->prepare("SELECT Name_, handle, last_modified $titleLine FROM $repoHandle\_$primClass WHERE extends IS NULL AND approved=1 ORDER BY Name_");
    } else {
      $sth = $self->dbh->prepare("SELECT Name_, handle, last_modified $titleLine FROM $repoHandle\_$primClass WHERE extends IS NULL ORDER BY Name_");
    }
    eval { $sth->execute(); };
    if ($@) { $util->error("Can't create catalog. $@"); }
    my @entries = ();
    while (my $row = $sth->fetchrow_hashref()) {
      push (@entries, [$row->{'Name_'},$prefix.$row->{'handle'},$row->{'TitleLine_'}]);
    }
    my $interops = $self->getInteropObjects($primAttr,"%",$util,$titleLine);
    foreach my $name (keys %{$interops}) {
      push (@entries,[$name,$interops->{$name}->[0],$interops->{$name}->[1]]);
    }
    if (@entries) {
      $buf .= "<P><dl>";
      foreach my $entry (sort {lc($a->[0]) cmp lc($b->[0])} @entries) {
        $buf .= "<dd><a href=\""
             . $entry->[1]
             . "\">"
             . $entry->[0]
             . "</a> "
             . $entry->[2];
      }
      $buf .= "</dl>";
    }
  }

  ###################################
  # if primary attribute doesn't have a vocabulary then sort on its value alone
  elsif (!($vocabulary)) {
    if ($object_approval_required) {
      $sth = $self->dbh->prepare("SELECT Name_, handle $titleLine FROM $repoHandle\_$primClass WHERE extends IS NULL AND approved=1 ORDER BY $primAttr\_");
    } else {
      $sth = $self->dbh->prepare("SELECT Name_, handle $titleLine FROM $repoHandle\_$primClass WHERE extends IS NULL ORDER BY $primAttr\_");
    }
    eval { $sth->execute(); };
    if ($@) { $util->error("Can't create catalog. " . $self->dbh->errstr); };
    my @entries = ();
    while (my $row = $sth->fetchrow_hashref()) {
      push (@entries, [$row->{'Name_'},$prefix.$row->{'handle'},$row->{'TitleLine_'}]);
    }
    my $interops = $self->getInteropObjects($primAttr,"%",$util,$titleLine);
    foreach my $name (keys %{$interops}) {
      push (@entries,[$name,$interops->{$name}->[0],$interops->{$name}->[1]]);
    }
    if (@entries) {
      $buf .= "<P><dl>";
      foreach my $entry (sort {lc($a->[0]) cmp lc($b->[0])} @entries) {
        $buf .= "<dd><a href=\""
             . $entry->[1]
             . "\">"
             . $entry->[0]
             . "</a> "
             . $entry->[2];
      }
      $buf .= "</dl>";
    }
  }

  ###################################
  # if $term is not defined then just print the top table of contents
  elsif ($term eq '') {
    $buf .= "<strong>Table of Contents</strong><dl>";
    my $count = 0;
    foreach my $childTerm ($vocabulary->getChildren()) {
      $buf .= "<dd><a href=\"$catalog$count\"><strong>"
            . $childTerm->term()
            . "</strong></a>";

      if ($object_approval_required) {
        $sth = $self->dbh->prepare("SELECT Name_ FROM $repoHandle\_$primClass "
                                 . "WHERE LOCATE("
                                 . $self->dbh->quote($childTerm->term())
                                 . ",$primAttr\_)=1 AND approved=1");
      } else {
        $sth = $self->dbh->prepare("SELECT Name_ FROM $repoHandle\_$primClass "
                                 . "WHERE LOCATE("
                                 . $self->dbh->quote($childTerm->term())
                                 . ",$primAttr\_)=1");
      }
      eval { $sth->execute(); };
      my $total = int($sth->rows())
                + int($self->countInteropObjects($primAttr,$childTerm->term()));
      $buf .= " (" . $total . ")";
      $count++;
    }
    $buf.="</dl>";
    if ($object_approval_required) {
      $sth = $self->dbh->prepare("SELECT Name_, handle $titleLine FROM $repoHandle\_$primClass "
                               . "WHERE extends IS NULL AND approved=1 AND "
                               . "$primAttr\_='' ORDER BY Name_");
    } else {
      $sth = $self->dbh->prepare("SELECT Name_, handle $titleLine FROM $repoHandle\_$primClass "
                               . "WHERE extends IS NULL and $primAttr\_='' ORDER "
                               . "BY Name_");
    }
    eval { $sth->execute(); };
    if ($@) { $util->error("Can't create catalog. " . $self->dbh->errstr); };
    my @entries = ();
    while (my $row = $sth->fetchrow_hashref()) {
      push (@entries, [$row->{'Name_'},$prefix.$row->{'handle'},$row->{'TitleLine_'}]);
    }
    my $interops = $self->getInteropObjects($primAttr,"",$util,$titleLine);
    foreach my $name (keys %{$interops}) {
      push (@entries,[$name,$interops->{$name}->[0],$interops->{$name}->[1]]);
    }
    if (@entries) {
      $buf .= "<P><HR><P><dl>";
      foreach my $entry (sort {lc($a->[0]) cmp lc($b->[0])} @entries) {
        $buf .= "<dd><a href=\""
             . $entry->[1]
             . "\">"
             . $entry->[0]
             . "</a> "
             . $entry->[2];
      }
      $buf .= "</dl>";
    }
  }

  ###################################
  # $term is a set of coordinates for the vocabulary term
  elsif ($term ne '') {
    my $pathNumberPrefix = "";
    my $path = "";
    $buf = "<strong><a href=\"$catalog\">Home</a> / ";
    my $node = $vocabulary;
    my @parts = split (/!/,$term);
    for (my $i=0; $i<@parts; $i++) {
      $pathNumberPrefix .= $parts[$i];
      $node = $node->getChildAt(int($parts[$i]));
      $util->error("Invalid term") unless $node;
      $path .= $node->term();
      if ($i != $#parts) {
        $path .= "!";
        $buf .= "<a href=\"$catalog$pathNumberPrefix\">" . $node->term() . "</a> / ";
        $pathNumberPrefix .= "!";
      } else {
        $buf .= $node->term();
      }
    }

    $buf .= "</strong><dl>";
    my $count = 0;
    foreach my $childTerm ($node->getChildren()) {
      $buf .= "<dd><a href=\"$catalog$pathNumberPrefix!$count\"><strong>"
            . $childTerm->term()
            . "</strong></a>";

      if ($object_approval_required) {
        $sth = $self->dbh->prepare("SELECT Name_ FROM $repoHandle\_$primClass WHERE "
                                 . "LOCATE("
                                 . $self->dbh->quote("$path!".$childTerm->term())
                                 . ",$primAttr\_)=1 AND approved=1");
      } else {
        $sth = $self->dbh->prepare("SELECT Name_ FROM $repoHandle\_$primClass WHERE "
                                 . "LOCATE("
                                 . $self->dbh->quote("$path!".$childTerm->term())
                                 . ",$primAttr\_)=1");
      }
      eval { $sth->execute(); };
      my $total = int($sth->rows())
                + int($self->countInteropObjects($primAttr,$path."!".$childTerm->term()));
      $buf .= " (" . $total . ")";
      $count++;
    }
    $buf .= "</dl></strong>";

    # first get main rows (handle != NULL)
    if ($object_approval_required) {
      $sth = $self->dbh->prepare("SELECT Name_, handle $titleLine FROM $repoHandle\_$primClass "
                               . "WHERE $primAttr\_="
                               . $self->dbh->quote($path)
                               . " AND extends IS NULL AND approved=1");
    } else {
      $sth = $self->dbh->prepare("SELECT Name_, handle $titleLine FROM $repoHandle\_$primClass "
                               . "WHERE $primAttr\_="
                               . $self->dbh->quote($path)
                               . " AND extends IS NULL");
    }
    eval { $sth->execute(); };
    if ($@) { $util->error($@); }
    my @entries = ();
    while (my $row = $sth->fetchrow_arrayref()) {
      push (@entries, [$row->[0],$prefix.$row->[1],$row->[2]]);
    }
    # now get extended rows
    $sth = $self->dbh->prepare("SELECT extends FROM $repoHandle\_$primClass WHERE "
                             . "$primAttr\_="
                             . $self->dbh->quote($path)
                             . " AND handle IS NULL");
    eval { $sth->execute(); };
    if ($@) { $util->error($@); }
    while (my $row = $sth->fetchrow_arrayref()) {
      my $handle = $row->[0];
      my $sth2;
      if ($object_approval_required) {
        $sth2 = $self->dbh->prepare("SELECT Name_ $titleLine FROM $repoHandle\_$primClass "
                                  . "WHERE handle=$handle AND approved=1");
      } else {
        $sth2 = $self->dbh->prepare("SELECT Name_ $titleLine FROM $repoHandle\_$primClass "
                                  . "WHERE handle=$handle");
      }
      eval { $sth2->execute(); };
      if ($@) { $util->error($@); }
      if ($sth2->rows() >= 1) {
        my $row2 = $sth2->fetchrow_arrayref();
        push (@entries,[$row2->[0],$prefix.$handle,$row2->[1]]);
      }
    }
    # add in the interop objects
    my $interops = $self->getInteropObjects($primAttr,$path,$util,$titleLine);
    foreach my $name (keys %{$interops}) {
      push (@entries,[$name,$interops->{$name}->[0],$interops->{$name}->[1]]);
    }
    if (@entries) {
      $buf .= "<P><HR><P><DL>";
      foreach my $entry (sort {lc($a->[0]) cmp lc($b->[0])} @entries) {
        $buf .= "<DD><A HREF=\""
             . $entry->[1]
             . "\">"
             . $entry->[0]
             . "</A> "
             . $entry->[2];
      }
      $buf .= "</DL>";
    }
  }
  
  ###################################
  # run the catalog through the template
  unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/catalog_template.html")) {
    $util->error("Can't open template : $!");
  }
  my $html = undef;
  while (<TEMPLATE>) {
    s/\bREPOSITORY_NAME\b/$name/g;
    s/\bREPOSITORY_CONTACT\b/$contact/g;
    s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
    s/\bADVANCED_SEARCH_URL\b/$riburl\/advancedSearch.pl\?rh=$repoHandle/g;
    s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
    s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
    s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
    s/\bDATA_MODEL_URL\b/$riburl\/$repoHandle\/config.xml/g;
    s/\bREPOSITORY_HANDLE\b/$riburl\/repository.pl\?rh=$repoHandle/g;
    s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
    s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;

    $html.=$_;
    $html.="\n".$buf if /<!-- RIB -->/i;
  }
  return $html;
}

sub getInteropObjects {
  my ($self,$primAttr,$term,$util,$titleLine) = @_;
  my %h = ();
  my $sth;
  #return \%h unless $primAttr;
  if ($primAttr) {
    $sth = $self->dbh->prepare("SELECT Name_,url $titleLine FROM "
                              . $self->repoHandle() 
                              . "_interop_objects WHERE $primAttr\_="
                              . $self->dbh->quote($term));
  } else {
    $sth = $self->dbh->prepare("SELECT Name_,url $titleLine FROM "
                              . $self->repoHandle() 
                              . "_interop_objects");
  }
  eval { $sth->execute(); };
  if ($@) { $util->error("Can't create catalog. $@"); }
  while (my $row = $sth->fetchrow_arrayref()) {
    my $url = $row->[1];
    #unless ($url =~ s,(rib/repositories/[^/]+/)objects/,${1}catalog/,) {
    unless ($url =~ m,rib/repositories/[^/]+/objects/,) {
      $url .= "&html=1";
    }
    $h{$row->[0]} = [$url,$row->[2]];
  }
  return \%h;
}

sub countInteropObjects {
  my ($self,$primAttr,$term,$util) = @_;
  return 0 unless $primAttr;
  my $sth = $self->dbh->prepare("SELECT Name_ FROM "
                              . $self->repoHandle()
                              . "_interop_objects WHERE "
                              . "LOCATE("
                              . $self->dbh->quote($term)
                              . ",$primAttr\_) = 1");
  eval { $sth->execute(); };
  if ($@) { $util->error("Can't create catalog. $@"); }
  return int($sth->rows());
}

1;
