#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use HTTP::Date;

##############################################
my $util = new RIB::Util;
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;

if (!defined(param('password'))) {
  print header,
        start_html('-title'=>'RIB management page',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter Main RIB Password')),
        p,hr,p,
        "Please enter the main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'password', -size=>50, -maxlength=>80),
        submit(-value=>'Submit'), end_form, end_html;
  goto FALLOFF;
}

$util->dbConnect();

#get the main rib password
my $sth = $util->dbh->prepare("select password from admin");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }

my $main_rib_password = $sth->fetchrow_array;

#check the password supplied by the user
if (param('password') ne $main_rib_password) {
  param('password',''); # setting -value=>'' doesn't seem to work
  print header,
        start_html('-title'=>'RIB management page',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter Main RIB Password')),
        p,hr,p,
        "The password that you entered was incorrect. Please try again.<P>\n",
        "Please enter the main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'password', -size=>50, -maxlength=>80, -value=>''),
        submit(-value=>'Submit'), end_form, end_html;
  goto FALLOFF;
}

my $SCRIPT = <<'END';
function form_select(f) {

  // strip off the current script name
  //myurl = location.href.replace(/^(.+\/)[^\/]+$/,"$1");
  myurl = location.href.substring(0,location.href.lastIndexOf("/")+1);
  cgiurl = myurl;

  // add on the target script name
  myurl += f.navigate.options[f.navigate.selectedIndex].value;

  // add the repository handle to the url if headed towards adminRepository.pl.
  // this makes it easier to know the url of the admin page for bookmarks,etc
  if (myurl.indexOf("adminRepository.pl") > 0) {
    // does myurl already have encoded args? if so then use "&", otherwise "?"
    separator = "?";
    if (myurl.indexOf("?") > 0) {
      separator = "&";
    }
    i = f.rh.selectedIndex;
    repositoryHandle = document.forms[0].rh.options[i].value;
    myurl += separator + "rh=" + repositoryHandle;
  }

  // if import.pl script was chosen then add interop_handle param
  if (myurl.indexOf("importRepository.pl") > 0) {
    i = f.rh.selectedIndex;
    repositoryHandle = document.forms[0].rh.options[i].value;
    f.interop_handle.value = cgiurl+"repository.pl?rh="+repositoryHandle;
    alert("You will be taken to the repository import page. "
        + "Follow the "
        + "instructions on that page except do not change the value of "
        + "the interoperation handle. The interoperation handle supplied "
        + "in the form belongs to the repository that you want to copy.");
  }

  // change the action for the form
  f.action = myurl; 
  return true;
}
END

$sth = $util->dbh->prepare("SELECT handle,name FROM repositories ORDER by name");
my %labels = ();
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }

while ($_ = $sth->fetchrow_arrayref) {
  $labels{$_->[0]} = $_->[1];
}

## information should expire in 5 minutes. this helps ensure that
## newly created repositories show up in the list.
my $now = HTTP::Date::time2str(time);
my $later = HTTP::Date::time2str(time + 5*60);

print header('-Expires'=>$later, '-Date'=>$now),
      start_html('-title'=>'RIB management page',-BGCOLOR=>'#FFFFFF',
                 -script=>{-language=>'JavaScript',-code=>$SCRIPT}),
      "<NOSCRIPT>",
      "<B><FONT COLOR=red>",
      "This page requires JavaScript and you do not have it enabled. ",
      "The controls on this page will not function correctly until JavaScript ",
      "has been reenabled.",
      "</FONT></B>",
      "</NOSCRIPT>",
      "<CENTER>",
      "<TABLE BORDER=5 CELLPADDING=15><TR><TD>",
      "<A HREF=http://www.nhse.org/RIB/>",
      "<IMG BORDER=0 WIDTH=150 HEIGHT=150 SRC=$riburl/doc/RIBlogo.gif>",
      "</A>",
      "</TD><TD ALIGN=CENTER VALIGN=CENTER>",
      "<H2>Repository In a Box</H2>",
      "<H3>Management Page</H3>",
      "</TD></TR></TABLE>",
      p,hr,p;
      
if (keys %labels) {
  my @repoNames = sort {lc($labels{$a}) cmp lc($labels{$b})} keys %labels;
  print start_form(-onSubmit=>'return form_select(this)'),
        hidden('password'),
        "<SELECT NAME=navigate>",
        "<OPTION SELECTED  VALUE=adminRepository.pl>Go to the administration page for",
        "<OPTION  VALUE=catalog.pl>View catalog for",
        "<OPTION  VALUE=changePasswd2.pl>Change password for",
        "<OPTION  VALUE=deleteRepository.pl>Delete",
        "<OPTION  VALUE=importRepository.pl>Make a copy of",
        "</SELECT>",
        " repository named ",
        popup_menu(-name=>'rh',
                  #-values=>[sort {lc($labels{$a}) cmp lc($labels{$b})} keys %labels],
                   -values=>\@repoNames,
                   -default=>$repoNames[0],
                   -labels=>\%labels),
        hidden(-name=>'came_from_top',-value=>'1'),
        hidden(-name=>'interop_handle',-value=>''), # for importRepository.pl
        submit(-value=>'Go'),
        end_form,
        p;
}
print "<TABLE><TR><TD>",
      start_form(-action=>'createRepository.pl'),
      hidden('password'),
      submit(-value=>'Create a repository'),
      end_form,
      "</TD><TD>",
      start_form(-action=>'importRepository.pl'),
      hidden('password'),
      submit(-value=>'Import a repository'),
      end_form,
      "</TD></TR><TR><TD COLSPAN=2 ALIGN=CENTER>",
      start_form(-action=>'changeMainPasswd.pl'),
      hidden('password'),
      submit(-value=>'Change the main RIB password'),
      end_form,
      "</TD></TR></TABLE>",
      hr,
      "<A HREF=$riburl/doc/top_help.html>Click here for help</A>",
      "</CENTER>",
      end_html;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
