#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

if (param('required') eq 'true') {
  my $sth = $util->dbh->prepare("UPDATE repositories SET object_approval_required=1 WHERE handle="
                     . param('rh'));
  unless ($sth->execute) {
    $util->error($util->dbh->errstr);
  }
  print header(-type=>"text/plain"), "ok";
}

elsif (param('required') eq 'false') {
  my $sth = $util->dbh->prepare("UPDATE repositories SET object_approval_required=0 WHERE handle="
                     . param('rh'));
  unless ($sth->execute) {
    $util->error($util->dbh->errstr);
  }
  print header(-type=>"text/plain"), "ok";
}

else {
  $util->error("Required paramater not supplied");
}

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
