#BANGLINE
use strict;
use CGI qw/:standard/;
use LWP::UserAgent;
use RIB::Util;

my $util = new RIB::Util();
unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $url = param('url');
my $ua  = LWP::UserAgent->new('RIB Proxy 1.0');
my $req = HTTP::Request->new('GET', $url);
my $res = $ua->request($req);
if ($res->is_success) {
  print header(-type=>$res->content_type()),
        $res->content();
} else {
  print header, $res->error_as_HTML;
}

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
