#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use Apache;

##############################################

my $util = new RIB::Util();
my $ribdir = $util->RibDir();
my $notify = 0;

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $table_name = param('rh') . "_interop_registry";

foreach my $x (param()) {
  next unless $x =~ /^ih\d+$/;
  my $handle = param($x);
  next unless $handle =~ /^[0-9]+$/;
  eval {
    &start_interop($handle);
  };
  if ($@ && $@ !~ /\ at /) {
    $util->error($@);
  }
}
print header(-type=>"text/plain"), "ok";

sub start_interop {
  my $ih = shift;
  my $pid;
  if ($pid = fork()) {
    wait;  ## parent wait on first child (should happen quickly)
    return 1;
  } elsif (defined $pid) {
    # 2nd fork forces child into background
    unless (fork()) {   # child's child
      ## there's a bug in NCSA httpd1.3 and some netscape servers
      ## that prevents backgrounding of the child process. so the
      ## first 20 filehandles are closed.  This kills unclosed socket
      my $SYS_close;
      if (`uname -s` =~ /irix/i) {
        # per /usr/include/sys.s
        $SYS_close = 1006;
      } else {
        $SYS_close = 6;
      }
      if (`uname -s` !~ /aix/i) {
        my $i;
        for ($i=0; $i<20; $i++) {
          eval {syscall($SYS_close, $i+0)};
        }
      }
      sleep 1 until getppid == 1;
      if ($notify) {
        exec "$ribdir/bin/updateInterop.pl", "-r", param('rh'), "-i", $ih, "-n";
      } else {
        exec "$ribdir/bin/updateInterop.pl", "-r", param('rh'), "-i", $ih;
      }
    }
    ## first child exits quickly
    $util->{dbh} && $util->{dbh}->disconnect();
    exit(0);
  } else  { # this isn't supposed to happen
    die $!;
  }
  $util->{dbh} && $util->{dbh}->disconnect();
}

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
