####################################
package RIB::VocabularyTerm;
use strict;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {
    'TERM'        => shift,
    'CHILDTERMS'  => []
  };
  bless ($self, $class);
  return $self;
}

sub term {
  my $self = shift;
  if (@_) { $self->{'TERM'} = shift }
  return $self->{'TERM'};
}

sub addChild {
  my ($self,$term) = @_;
  push (@{$self->{'CHILDTERMS'}}, $term);
}

sub getChildren {
  my $self = shift;
  return sort {lc($a->{'TERM'}) cmp lc($b->{'TERM'})} @{$self->{'CHILDTERMS'}};
}

sub getChildrenPtr {
  my $self = shift;
  return $self->{'CHILDTERMS'};
}

sub getChild {
  my $self = shift;
  my $s = shift;
  foreach my $child (@{$self->{'CHILDTERMS'}}) {
    if ($child->{'TERM'} eq $s) {
      my $class = ref($self);
      bless $child, $class;
      return $child;
    }
  }
  return undef;
}

sub getChildAt {
  my ($self,$position) = @_;
  $position ||= 0;
  my @tmp = $self->getChildren(); # sorts them
  return $tmp[$position];
}

1;
